/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.partitions;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.annotation.SdkInternalApi;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.partitions.PartitionRegionImpl;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.partitions.model.Partition;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.partitions.model.Region;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.AbstractRegionMetadataProvider;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> getRegions() {
        ArrayList<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> regions = new ArrayList<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        return null;
    }

    private com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region region = new com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region>();
        for (com.appdynamics.serverless.tracers.dependencies.com.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

