/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.internal.auth;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.AmazonWebServiceClient;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.AmazonWebServiceRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.Request;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.auth.Signer;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.auth.SignerFactory;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.auth.SignerParams;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.auth.SignerTypeAware;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.internal.auth.SignerProvider;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.internal.auth.SignerProviderContext;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.util.AwsHostNameUtils;
import java.net.URI;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.defaultSigner = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext context) {
        Request<?> request = context.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (context.isRedirect()) {
                return this.awsClient.getSignerByURI(context.getUri());
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams params = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), params);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest originalRequest) {
        return !(originalRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uri) {
        String regionName = this.awsClient.getSignerRegionOverride();
        if (regionName == null) {
            regionName = AwsHostNameUtils.parseRegion(uri.getHost(), this.awsClient.getEndpointPrefix());
        }
        return regionName;
    }
}

