/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.http;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.annotation.Immutable;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.http.HttpResponse;
import java.util.Collections;
import java.util.Map;

@Immutable
public class SdkHttpMetadata {
    private final Map<String, String> httpHeaders;
    private final int httpStatusCode;

    private SdkHttpMetadata(Map<String, String> httpHeaders, int httpStatusCode) {
        this.httpHeaders = Collections.unmodifiableMap(httpHeaders);
        this.httpStatusCode = httpStatusCode;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static SdkHttpMetadata from(HttpResponse httpResponse) {
        return new SdkHttpMetadata(httpResponse.getHeaders(), httpResponse.getStatusCode());
    }
}

