/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.utils;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.utils.AWSLambdaContextUtil;
import com.appdynamics.serverless.tracers.dependencies.feign.Feign;
import com.appdynamics.serverless.tracers.dependencies.feign.Logger;
import com.appdynamics.serverless.tracers.dependencies.feign.Request;
import com.appdynamics.serverless.tracers.dependencies.feign.gson.GsonDecoder;
import com.appdynamics.serverless.tracers.dependencies.feign.gson.GsonEncoder;
import com.appdynamics.serverless.tracers.dependencies.feign.okhttp.OkHttpClient;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.Credentials;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;

public class ServiceProvider<T> {
    static final String customTruststorePath = "/tmp/CustomTruststore";

    public T get(String uri, Class<T> type, AWSLambdaLogger logger, Map<String, String> headers) {
        return this.get(uri, type, logger, headers, 0, 0);
    }

    public T get(String uri, Class<T> type, final AWSLambdaLogger logger, Map<String, String> headers, int connectTimeout, int readTimeout) {
        com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient delegateClient;
        Request.Options options = connectTimeout <= 0 && readTimeout <= 0 ? new Request.Options() : new Request.Options(connectTimeout, readTimeout);
        Feign.Builder builder = Feign.builder().encoder(new GsonEncoder()).decoder(new GsonDecoder()).logLevel(Logger.Level.FULL).requestInterceptor(template -> headers.forEach((x$0, xva$1) -> template.header((String)x$0, (String)xva$1))).logger(new Logger(){

            @Override
            protected void log(String configKey, String format, Object ... args) {
                logger.log(AWSLambdaLogger.LogLevel.DEBUG, 1.methodTag(configKey) + format + "%n", args);
            }
        }).options(options);
        if (System.getenv("APPDYNAMICS_HTTP_PROXY_SERVER_CERTIFICATE") != null) {
            try {
                this.addProxyCertificateToTruststore();
            }
            catch (Exception e) {
                logger.log(AWSLambdaLogger.LogLevel.WARN, String.format("Failed to add proxy certificate to trust store: %s", e.getMessage()), new Object[0]);
            }
        }
        if ((delegateClient = this.getProxyClientIfEnabled(logger)) != null) {
            builder.client(new OkHttpClient(delegateClient));
        }
        return builder.target(type, uri);
    }

    private com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient getProxyClientIfEnabled(AWSLambdaLogger logger) {
        Proxy proxy = this.getProxyIfEnabled(logger);
        if (proxy == null) {
            return null;
        }
        OkHttpClient.Builder delegateBuilder = new OkHttpClient.Builder().proxy(proxy);
        if (this.isProxyBasicAuthenticationEnabled()) {
            delegateBuilder.proxyAuthenticator((route, response) -> {
                String user = System.getenv("APPDYNAMICS_HTTP_PROXY_USER");
                String password = System.getenv("APPDYNAMICS_HTTP_PROXY_PASSWORD");
                String passwordFile = System.getenv("APPDYNAMICS_HTTP_PROXY_PASSWORD_FILE");
                logger.log(AWSLambdaLogger.LogLevel.DEBUG, String.format("Authenticating to proxy server as user %s", user), new Object[0]);
                if (passwordFile != null) {
                    try {
                        File pwFile = new File(passwordFile);
                        String rootDir = AWSLambdaContextUtil.getLambdaDeploymentDirectory();
                        if (pwFile.isAbsolute() && !passwordFile.startsWith(rootDir + File.separator)) {
                            logger.log(AWSLambdaLogger.LogLevel.ERROR, "No permission to read file from absolute path %s; disabling proxy authentication", passwordFile);
                            return null;
                        }
                        byte[] pass = pwFile.isAbsolute() && passwordFile.startsWith(rootDir + File.separator) ? Files.readAllBytes(Paths.get(passwordFile, new String[0])) : Files.readAllBytes(Paths.get(rootDir, passwordFile));
                        password = new String(pass, Charset.forName("UTF-8")).trim();
                        logger.log(AWSLambdaLogger.LogLevel.DEBUG, String.format("Authenticating with password in file '%s'", passwordFile), new Object[0]);
                    }
                    catch (IOException e) {
                        String error = String.format("IOException while reading password file %s: %s", passwordFile, e.getMessage());
                        logger.log(AWSLambdaLogger.LogLevel.ERROR, error, new Object[0]);
                        return null;
                    }
                    catch (Exception e) {
                        String error = String.format("Unknown error occurred while reading password file %s: %s", passwordFile, e.getMessage());
                        logger.log(AWSLambdaLogger.LogLevel.ERROR, error, new Object[0]);
                        return null;
                    }
                }
                String credential = Credentials.basic(user, password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            });
        }
        return delegateBuilder.build();
    }

    private void addProxyCertificateToTruststore() throws Exception {
        String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fis = new FileInputStream(filename);){
            keystore.load(fis, "changeit".toCharArray());
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate caCert = cf.generateCertificate(new FileInputStream(System.getenv("APPDYNAMICS_HTTP_PROXY_SERVER_CERTIFICATE")));
        keystore.setCertificateEntry("customer-proxy-cert", caCert);
        try (FileOutputStream out = new FileOutputStream(customTruststorePath);){
            keystore.store(out, "@ppDyn@mic5-$3rvl$$".toCharArray());
        }
        System.setProperty("javax.net.ssl.trustStore", customTruststorePath);
    }

    private Proxy getProxyIfEnabled(AWSLambdaLogger logger) {
        String proxyHost = System.getenv("APPDYNAMICS_HTTP_PROXY_HOST");
        String proxyPortStr = System.getenv("APPDYNAMICS_HTTP_PROXY_PORT");
        Integer proxyPort = null;
        try {
            proxyPort = Integer.parseInt(proxyPortStr);
        }
        catch (NumberFormatException e) {
            logger.log(AWSLambdaLogger.LogLevel.DEBUG, String.format("Unable to parse integer from port %s", proxyPortStr), new Object[0]);
        }
        if (proxyHost == null || proxyPort == null) {
            logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Proxy server not configured, continuing", new Object[0]);
            return null;
        }
        if (proxyPort < 0 || proxyPort >= 65536) {
            logger.log(AWSLambdaLogger.LogLevel.WARN, String.format("Client configured with out-of-range proxy port %d", proxyPort), new Object[0]);
            return null;
        }
        logger.log(AWSLambdaLogger.LogLevel.DEBUG, String.format("Proxying is correctly configured for %s:%s", proxyHost, proxyPort), new Object[0]);
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
    }

    private boolean isProxyBasicAuthenticationEnabled() {
        return System.getenv("APPDYNAMICS_HTTP_PROXY_USER") != null && (System.getenv("APPDYNAMICS_HTTP_PROXY_PASSWORD") != null || System.getenv("APPDYNAMICS_HTTP_PROXY_PASSWORD_FILE") != null);
    }
}

