/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.utils;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;

public class AWSLambdaContextUtil {
    static String getLambdaDeploymentDirectory() {
        return File.separator + String.join((CharSequence)File.separator, "var", "task");
    }

    public static String getFunctionName(Object target, AWSLambdaLogger logger) {
        return (String)AWSLambdaContextUtil.invokeMethod(target, "getFunctionName", logger);
    }

    public static String getFunctionVersion(Object target, AWSLambdaLogger logger) {
        return (String)AWSLambdaContextUtil.invokeMethod(target, "getFunctionVersion", logger);
    }

    public static Object getLambdaLogger(Object target, AWSLambdaLogger logger) {
        return AWSLambdaContextUtil.invokeMethod(target, "getLogger", logger);
    }

    public static String getInvokedFunctionArn(Object target, AWSLambdaLogger logger) {
        return (String)AWSLambdaContextUtil.invokeMethod(target, "getInvokedFunctionArn", logger);
    }

    public static Map<String, String> getClientContextEnvironment(Object target, AWSLambdaLogger logger) {
        Object clientContext = AWSLambdaContextUtil.invokeMethod(target, "getClientContext", logger);
        if (clientContext == null) {
            return null;
        }
        return (Map)AWSLambdaContextUtil.invokeMethod(clientContext, "getEnvironment", logger);
    }

    private static Object invokeMethod(Object target, String mName, AWSLambdaLogger logger) {
        try {
            Class<?> cls = target.getClass();
            Method m = cls.getMethod(mName, new Class[0]);
            m.setAccessible(true);
            return m.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            logger.log(AWSLambdaLogger.LogLevel.ERROR, "Error reflecting => %s", e.getMessage());
            return null;
        }
    }
}

