/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.publish;

import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.publish.EventService;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;

public class EventManager {
    private final ArrayBlockingQueue<Event> eventQueue;
    private final EventService eventService;
    private AWSLambdaLogger logger;
    private long lastTimeEventsFlushed;
    private final long flushPeriodMs;
    private boolean containsColdStartEvent;

    public EventManager(ArrayBlockingQueue<Event> eventQueue, AWSLambdaLogger logger, EventService eventService, long flushPeriodMs) {
        this.eventQueue = eventQueue;
        this.eventService = eventService;
        this.logger = logger;
        this.lastTimeEventsFlushed = System.currentTimeMillis();
        this.flushPeriodMs = flushPeriodMs;
        this.containsColdStartEvent = false;
    }

    int getQueueLength() {
        return this.eventQueue.size();
    }

    public boolean offer(Event event) {
        if (event.isColdStartEvent()) {
            this.containsColdStartEvent = true;
        }
        return this.eventQueue.offer(event);
    }

    public void flush() {
        long now = System.currentTimeMillis();
        if (this.containsColdStartEvent || now - this.lastTimeEventsFlushed >= this.flushPeriodMs) {
            this.sendEvents();
            this.lastTimeEventsFlushed = now;
            this.containsColdStartEvent = false;
        }
    }

    private void sendEvents() {
        try {
            ArrayList<Event> toSend = new ArrayList<Event>();
            this.eventQueue.drainTo(toSend);
            if (!toSend.isEmpty()) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Sending events => %s", toSend);
                this.eventService.postEvents(toSend);
            }
        }
        catch (Exception e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR sending events => %s", e.getMessage());
        }
    }
}

