/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.logging;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;

public class SysOutLogger
implements AWSLambdaLogger {
    private AWSLambdaLogger.LogLevel currentLogLevel;

    public SysOutLogger(AWSLambdaLogger.LogLevel currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    @Override
    public void log(AWSLambdaLogger.LogLevel level, String format, Object ... args) {
        if (level.ordinal() >= this.currentLogLevel.ordinal()) {
            System.out.println(String.format("[AppDynamics Tracer] [" + level.name() + "]: " + format + "%n", args));
        }
    }

    @Override
    public void setCurrentLogLevel(AWSLambdaLogger.LogLevel currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    @Override
    public AWSLambdaLogger.LogLevel getCurrentLogLevel() {
        return this.currentLogLevel;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.currentLogLevel.ordinal() == AWSLambdaLogger.LogLevel.DEBUG.ordinal();
    }

    @Override
    public void debug(String message) {
        this.log(AWSLambdaLogger.LogLevel.DEBUG, message, new Object[0]);
    }
}

