/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.impl;

import com.appdynamics.serverless.tracers.aws.api.ExitCall;
import com.appdynamics.serverless.tracers.aws.api.Transaction;
import com.appdynamics.serverless.tracers.aws.correlation.EumMetadataCollector;
import com.appdynamics.serverless.tracers.aws.events.BTEvent;
import com.appdynamics.serverless.tracers.aws.events.BackendRegistrationEvent;
import com.appdynamics.serverless.tracers.aws.events.ErrorEvent;
import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.exit.ExitCallIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredBackendInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredExitCall;
import com.appdynamics.serverless.tracers.aws.impl.NoOpExitCall;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.transactions.CurrentTransactionContext;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;
import com.appdynamics.serverless.tracers.aws.utils.PropertyUtil;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TransactionImpl
implements Transaction {
    final String correlationHeader;
    final TransactionMonitoringContext txContext;
    CurrentTransactionContext ctc;
    final ExitCall noOpExitCall = new NoOpExitCall();
    byte state;
    EumMetadataCollector eumMetadataCollector;
    private boolean errorOccuredInTx;

    public TransactionImpl(String correlationHeader, TransactionMonitoringContext txContext) {
        this.correlationHeader = correlationHeader;
        this.txContext = txContext;
    }

    private boolean shouldCollectEumMetadata() {
        return StringOperations.isEmpty(this.correlationHeader) && StringOperations.isNotEmpty(this.ctc.getRequestGUID()) && StringOperations.isNotEmpty(this.txContext.getGlobalAccountName());
    }

    @Override
    public void start() {
        try {
            if ((this.state & 1) == 1) {
                this.txContext.getLogger().debug("Transaction already started");
                return;
            }
            this.txContext.getReadWriteLock().readLock().lock();
            try {
                this.ctc = this.txContext.getTxCorrelator().createTransactionContext(this.correlationHeader, this.txContext);
            }
            finally {
                this.txContext.getReadWriteLock().readLock().unlock();
            }
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "return value for CTC => %s", this.ctc);
            if (null != this.ctc) {
                long timestamp = System.currentTimeMillis();
                this.ctc.setStartTimeInMs(timestamp);
                if (!this.ctc.isContinuingTransaction()) {
                    timestamp = this.txContext.isLagging() ? timestamp + this.txContext.getTimeSkew() : timestamp - this.txContext.getTimeSkew();
                    this.ctc.setSkewAdjustedBeginTimestamp(Long.toString(timestamp));
                }
                this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "CTC => %s", this.ctc);
            }
            this.state = (byte)(this.state | 1);
        }
        catch (Exception e) {
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.ERROR, "%s => %s", "ERROR starting transaction", e.getMessage());
        }
    }

    @Override
    public void stop() {
        if ((this.state & 2) == 2) {
            this.txContext.getLogger().debug("Transaction already stopped");
            return;
        }
        if (null != this.ctc) {
            BTEvent btEvent;
            long endTimeInMs = System.currentTimeMillis();
            if (this.ctc.getBtId() != 0L) {
                btEvent = new BTEvent(Event.Type.BT.name(), this.ctc.getBtId(), this.ctc.getRequestGUID(), this.ctc.getStartTimeInMs(), endTimeInMs, this.ctc.getCallerChainAsString(), "1");
            } else {
                String btName = this.txContext.getDefaultBtName();
                if (StringOperations.isNotEmpty(this.txContext.getBtName())) {
                    btName = this.txContext.getBtName();
                }
                btEvent = new BTEvent(Event.Type.BT.name(), this.ctc.getRequestGUID(), this.ctc.getStartTimeInMs(), endTimeInMs, this.ctc.getCallerChainAsString(), "1", btName, "POJO");
            }
            if (this.shouldCollectEumMetadata()) {
                this.eumMetadataCollector = new EumMetadataCollector(this.ctc.getRequestGUID(), this.txContext.getGlobalAccountName());
                long duration = endTimeInMs - this.ctc.getStartTimeInMs();
                this.eumMetadataCollector.setBTDuration(this.ctc.getBtId(), duration);
            }
            this.txContext.getEventManager().offer(btEvent);
            this.ctc = null;
        }
        this.state = (byte)(this.state | 2);
        this.txContext.getEventManager().flush();
    }

    @Override
    public ExitCall createExitCall(String exitType, Map<String, String> identifyingProperties) {
        return this.createExitCall(exitType, exitType, identifyingProperties);
    }

    @Override
    public ExitCall createExitCall(String exitType, String exitSubType, Map<String, String> identifyingProperties) {
        try {
            if (null == this.ctc) {
                this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "Transaction not active. Will not create ExitCall", new Object[0]);
                return this.noOpExitCall;
            }
            ExitCallIdentifyingInfo exitCallIdentifyingInfo = new ExitCallIdentifyingInfo(exitType, exitSubType, identifyingProperties);
            RegisteredBackendInfo registeredBackendInfo = this.txContext.getExitCallInfoToRegisteredInfoCache().get(exitCallIdentifyingInfo);
            if (null != registeredBackendInfo) {
                RegisteredExitCall currentExitCall = new RegisteredExitCall(exitCallIdentifyingInfo, registeredBackendInfo, this, this.txContext);
                this.ctc.setCurrentExitCall(currentExitCall);
                this.ctc.setCorrelatedExitCallCounter(this.ctc.getCorrelatedExitCallCounter() + 1);
                String outgoingHeader = this.txContext.getTxCorrelator().getCorrelationHeader(this.ctc, currentExitCall);
                currentExitCall.setCorrelationHeader(outgoingHeader);
                this.ctc.getId2ExitCalls().put(outgoingHeader, currentExitCall);
                this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "Started exit call for %s", currentExitCall);
                return currentExitCall;
            }
            BackendRegistrationEvent backendRegistrationEvent = new BackendRegistrationEvent(Event.Type.REGISTRATION_BACKEND.name(), exitType, exitSubType, PropertyUtil.toPropertyList(identifyingProperties), "1");
            this.txContext.getEventManager().offer(backendRegistrationEvent);
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "Sending registration request => %s", backendRegistrationEvent);
            return this.noOpExitCall;
        }
        catch (Exception e) {
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.ERROR, "%s => %s", "ERROR starting exit call", e.getMessage());
            return this.noOpExitCall;
        }
    }

    @Override
    public List<String> getEumMetadata() {
        return this.eumMetadataCollector == null ? Collections.emptyList() : this.eumMetadataCollector.getMetadataForResponseHeaders();
    }

    @Override
    @Deprecated
    public String identifier() {
        if (this.ctc != null) {
            return this.ctc.isContinuingTransaction() ? this.correlationHeader : this.ctc.getRequestGUID();
        }
        return null;
    }

    @Override
    public void reportError(Throwable throwable) {
        if (this.ctc != null) {
            String errorName = this.txContext.getErrorHelper().generateDisplayName(throwable);
            String errorMessage = this.txContext.getErrorHelper().generateDetail(throwable);
            this.reportError(errorName, errorMessage);
        }
    }

    @Override
    public void reportError(String errorName, String errorMessage) {
        if (this.ctc != null && !this.errorOccuredInTx) {
            ErrorEvent errorEvent;
            this.errorOccuredInTx = true;
            long endTimeInMs = System.currentTimeMillis();
            if (this.ctc.getBtId() != 0L) {
                errorEvent = new ErrorEvent(Event.Type.ERROR.name(), this.ctc.getBtId(), 0L, this.ctc.getCallerChainAsString(), errorName, errorMessage, "1", 0, this.ctc.getStartTimeInMs(), endTimeInMs, this.ctc.getRequestGUID());
            } else {
                String btName = this.txContext.getDefaultBtName();
                if (StringOperations.isNotEmpty(this.txContext.getBtName())) {
                    btName = this.txContext.getBtName();
                }
                errorEvent = new ErrorEvent(Event.Type.ERROR.name(), 0L, this.ctc.getCallerChainAsString(), errorName, errorMessage, "1", 0, this.ctc.getStartTimeInMs(), endTimeInMs, this.ctc.getRequestGUID(), btName, "POJO");
            }
            this.txContext.getEventManager().offer(errorEvent);
        }
    }

    public CurrentTransactionContext getCurrentTransactionContext() {
        return this.ctc;
    }

    public void removeExitCall(String exitCallIdentifier) {
        if (null != this.ctc) {
            this.ctc.getId2ExitCalls().remove(exitCallIdentifier);
        }
    }
}

