/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.errors;

import com.appdynamics.serverless.tracers.aws.errors.ExceptionOperations;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;

public class LightWeightThrowable {
    private final String fullyQualifiedName;
    private final LightWeightThrowable cause;
    private final StackTraceElement[] trace;
    private final String throwableToString;
    private final String message;
    private final ExceptionOperations exceptionOperations;
    private final AWSLambdaLogger logger;

    public LightWeightThrowable(Throwable t, AWSLambdaLogger logger, ExceptionOperations exceptionOperations) {
        this(t, 5000, logger, exceptionOperations);
    }

    private LightWeightThrowable(Throwable t, int stackDepth, AWSLambdaLogger logger, ExceptionOperations exceptionOperations) {
        this.fullyQualifiedName = t.getClass().getName();
        Throwable cause = t.getCause();
        this.cause = cause == null ? null : new LightWeightThrowable(cause, stackDepth, logger, exceptionOperations);
        this.throwableToString = t.toString();
        this.message = t.getMessage();
        this.exceptionOperations = exceptionOperations;
        this.logger = logger;
        this.trace = this.constructTrace(t, stackDepth);
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public LightWeightThrowable getCause() {
        return this.cause;
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.throwableToString;
    }

    private StackTraceElement[] constructTrace(Throwable t, int stackDepth) {
        StackTraceElement[] trace;
        try {
            trace = this.exceptionOperations.getStackTraceOptimized(t, stackDepth, this.logger);
        }
        catch (Exception e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Error getting stack trace for %s ", this.fullyQualifiedName);
            return new StackTraceElement[0];
        }
        return trace;
    }
}

