/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.errors;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ExceptionOperations {
    private final AWSLambdaLogger logger;
    private final StackTraceElement[] EMPTY_ARRAY = new StackTraceElement[0];
    private Method getOurStackTrace;
    private Method getStackTraceElement;
    private Method getStackTraceDepth;
    private Field stackTraceField;
    private volatile boolean gotMethods;

    public ExceptionOperations(AWSLambdaLogger logger) {
        this.logger = logger;
    }

    private boolean getMethods() {
        boolean success = false;
        if (!this.gotMethods) {
            this.gotMethods = true;
            try {
                this.getOurStackTrace = Throwable.class.getDeclaredMethod("getOurStackTrace", new Class[0]);
                this.getOurStackTrace.setAccessible(true);
                this.getStackTraceElement = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
                this.getStackTraceElement.setAccessible(true);
                this.getStackTraceDepth = Throwable.class.getDeclaredMethod("getStackTraceDepth", new Class[0]);
                this.getStackTraceDepth.setAccessible(true);
                this.stackTraceField = Throwable.class.getDeclaredField("stackTrace");
                this.stackTraceField.setAccessible(true);
                success = true;
            }
            catch (Throwable t) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s caught trying to reflect Throwable methods", t);
            }
        }
        return success;
    }

    public StackTraceElement[] getStackTraceOptimized(Throwable t, int stackDepth, AWSLambdaLogger logger) {
        if (!this.gotMethods) {
            this.getMethods();
        }
        if (this.getOurStackTrace != null && this.getStackTraceDepth != null && this.getStackTraceElement != null && this.stackTraceField != null) {
            try {
                StackTraceElement[] stackTraceElements = (StackTraceElement[])this.stackTraceField.get(t);
                if (stackTraceElements != null && stackTraceElements.length > 0) {
                    return this.cloneWithDepth(stackTraceElements, stackDepth);
                }
                StackTraceElement[] elements = (StackTraceElement[])this.getOurStackTrace.invoke((Object)t, new Object[0]);
                return this.cloneWithDepth(elements, stackDepth);
            }
            catch (Throwable t1) {
                logger.log(AWSLambdaLogger.LogLevel.ERROR, "%s caught in getStackTraceOptimized", t1);
                this.getOurStackTrace = null;
                return this.cloneWithDepth(t.getStackTrace(), stackDepth);
            }
        }
        return this.cloneWithDepth(t.getStackTrace(), stackDepth);
    }

    private StackTraceElement[] cloneWithDepth(StackTraceElement[] elements, int stackDepth) {
        if (elements == null) {
            return this.EMPTY_ARRAY;
        }
        if (elements.length <= stackDepth) {
            return elements;
        }
        int len = stackDepth + 1;
        StackTraceElement[] clonedElements = new StackTraceElement[len];
        System.arraycopy(elements, 0, clonedElements, 0, stackDepth);
        clonedElements[stackDepth] = new StackTraceElement("Exception limited to " + stackDepth + " frames", "", "", 0);
        return clonedElements;
    }
}

