/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.correlation;

import com.appdynamics.serverless.tracers.aws.correlation.ComponentLink;
import com.appdynamics.serverless.tracers.aws.correlation.CorrelationHeader;
import com.appdynamics.serverless.tracers.aws.correlation.CorrelationHeaderOverSizedException;
import com.appdynamics.serverless.tracers.aws.correlation.HeaderChain;
import com.appdynamics.serverless.tracers.aws.events.BTRegistrationEvent;
import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.exit.CurrentExitCall;
import com.appdynamics.serverless.tracers.aws.exit.TransactionExitPointType;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.transactions.BTIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.transactions.CurrentTransactionContext;
import com.appdynamics.serverless.tracers.aws.transactions.RegisteredBT;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;
import com.appdynamics.serverless.tracers.aws.utils.ArrayEncoder;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import com.appdynamics.serverless.tracers.aws.utils.ThreadChainParserUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class TransactionCorrelator {
    private final AWSLambdaLogger logger;
    static final int METRIC_NAME__LENGTH = 51;
    static final String OVERFLOW_TRANSACTION_NAME = "_APPDYNAMICS_DEFAULT_TX_";

    public TransactionCorrelator(AWSLambdaLogger logger) {
        this.logger = logger;
    }

    public String getCorrelationHeader(CurrentTransactionContext context, CurrentExitCall exitCall) {
        try {
            return this.generateCorrelationHeader(context, exitCall, false);
        }
        catch (CorrelationHeaderOverSizedException e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Not returning any header as header oversize exception hit", new Object[0]);
            return null;
        }
    }

    private String generateCorrelationHeader(CurrentTransactionContext context, CurrentExitCall currentExitCall, boolean skipDupChains) throws CorrelationHeaderOverSizedException {
        boolean debugEnabled = context.isDebugRequired();
        HeaderChain headerChain = context.getHeaderChain();
        if (headerChain != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s => %s", "Header chain exists", headerChain.toString());
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append(headerChain.getRoot());
            CorrelationHeader corHeader = new CorrelationHeader(sb);
            corHeader.addHeader("exitguid", this.getExitCallIdentificationHeader(context, context.getCorrelatedExitCallCounter()));
            corHeader.addHeader("unresolvedexitid", this.getUnresolvedExitIdHeader(context));
            if (context.isDevModeEnabled()) {
                corHeader.addHeader("devmodeenabled", Boolean.TRUE.toString());
            }
            if (debugEnabled) {
                corHeader.addHeader("debug", Boolean.TRUE.toString());
            }
            this.addComponentLinkHeaderChain(currentExitCall.getExitType(), currentExitCall.getExitSubtype(), currentExitCall.getExitComponent().getExitComponentAsStr(), headerChain.getFromCompIds(), headerChain.getFromCompChainString(), headerChain.getExitTypeCallChain(), headerChain.getExitSubTypeCallChain(), headerChain.getToCompChain(), corHeader, headerChain.getThreadCallChainForOutOfProcess());
            if (this.logger.isDebugEnabled()) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s [%s]", "Correlation Header generated from header chain", corHeader.getHeaderString());
            }
            this.addAsync2IndicatorToCorrelHeader(corHeader, context.isAsync2ContinuingTransaction());
            return corHeader.getHeaderString();
        }
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Header chain is null, generating new.", new Object[0]);
        CorrelationHeader corHeader = new CorrelationHeader();
        String appId = String.valueOf(context.getApplicationID());
        corHeader.addHeader("appId", appId);
        this.addControllerAndAccountGUIDsToCorrHeader(corHeader, context);
        if (context.getSkewAdjustedBeginTimestamp() != null) {
            corHeader.addHeader("ts", String.valueOf(context.getSkewAdjustedBeginTimestamp()));
        }
        if (context.getBtId() != 0L) {
            headerChain = new HeaderChain();
            context.setHeaderChain(headerChain);
            String transactionId = String.valueOf(context.getBtId());
            corHeader.addHeader("btid", transactionId);
            if (context.isForceHotspotSnapshot()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s %s %s", "hotspotenable", "added to correlation header for transaction", context.toString());
                }
                corHeader.addHeader("hotspotenable", Boolean.TRUE.toString());
            } else if (context.isSnapshotEnabled()) {
                corHeader.addHeader("snapenable", Boolean.TRUE.toString());
                headerChain.setSnapshotEnabledSet();
            }
            if (context.isDevModeEnabled()) {
                corHeader.addHeader("devmodeenabled", Boolean.TRUE.toString());
            }
            if (context.isHotspotCollectingCPUTime()) {
                corHeader.addHeader("hotspotcpu", Boolean.TRUE.toString());
            }
            corHeader.addHeader("guid", context.getRequestGUID());
            headerChain.setRoot(corHeader.getHeaderString());
            corHeader.addHeader("exitguid", this.getExitCallIdentificationHeader(context, context.getCorrelatedExitCallCounter()));
        }
        corHeader.addHeader("unresolvedexitid", this.getUnresolvedExitIdHeader(context));
        this.addComponentLinkHeader(context, corHeader, currentExitCall.getExitType(), currentExitCall.getExitSubtype(), currentExitCall.getExitComponent().getExitComponentAsStr(), headerChain, skipDupChains, String.valueOf(context.getComponentID()), context.getCallerComponentList());
        if (debugEnabled) {
            corHeader.addHeader("debug", Boolean.TRUE.toString());
        }
        this.addAsync2IndicatorToCorrelHeader(corHeader, context.isAsync2ContinuingTransaction());
        if (this.logger.isDebugEnabled()) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s => %s", "Header chain in context", headerChain != null ? headerChain.toString() : null);
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s => %s", "Correlation Header generated", corHeader.toString());
        }
        return corHeader.getHeaderString();
    }

    private void addAsync2IndicatorToCorrelHeader(CorrelationHeader corHeader, boolean forceAsync) throws CorrelationHeaderOverSizedException {
        if (forceAsync) {
            corHeader.addHeader("async", Boolean.TRUE.toString());
        }
    }

    private void addControllerAndAccountGUIDsToCorrHeader(CorrelationHeader corHeader, CurrentTransactionContext context) throws CorrelationHeaderOverSizedException {
        String accountGUID;
        String ctrlGUID = context.getControllerGUID();
        if (ctrlGUID != null) {
            corHeader.addHeader("ctrlguid", ctrlGUID);
        }
        if ((accountGUID = context.getAccountGUID()) != null) {
            corHeader.addHeader("acctguid", accountGUID);
        }
    }

    private String getUnresolvedExitIdHeader(CurrentTransactionContext context) {
        CurrentExitCall currentExitCall = context.getCurrentExitCall();
        return String.valueOf(currentExitCall.getExitId());
    }

    private void addComponentLinkHeader(CurrentTransactionContext context, CorrelationHeader corHeader, String exitType, String exitSubtype, String backendComponentID, HeaderChain headerChain, boolean skipDupChains, String componentIDString, List<ComponentLink> componentLinks) throws CorrelationHeaderOverSizedException {
        int size = context.isContinuingTransaction() ? componentLinks.size() + 1 : 1;
        ArrayList<String> componentFromIDs = new ArrayList<String>(size);
        ArrayList<String> exitTypes = new ArrayList<String>(size);
        ArrayList<String> exitSubTypes = new ArrayList<String>(size);
        ArrayList<String> componentToIDs = new ArrayList<String>(size);
        HashMap<Integer, String> exitCallPositionVsLatestThreadAddId = null;
        if (componentLinks != null) {
            for (int i = 0; i < componentLinks.size(); ++i) {
                ComponentLink link = componentLinks.get(i);
                componentFromIDs.add(link.getFromComponentID());
                String exitPointName = link.getExitPointType().name();
                exitTypes.add(exitPointName);
                String linkExitSubtype = link.getExitPointSubType();
                exitSubTypes.add(linkExitSubtype);
                componentToIDs.add(link.getToComponentID());
                if (link.getLatestThreadAddId() == null) continue;
                if (exitCallPositionVsLatestThreadAddId == null) {
                    exitCallPositionVsLatestThreadAddId = new HashMap<Integer, String>(4);
                }
                exitCallPositionVsLatestThreadAddId.put(i + 1, link.getLatestThreadAddId());
            }
        }
        componentFromIDs.add(componentIDString);
        String fromCompChain = ArrayEncoder.stringArrayToString(componentFromIDs, ',');
        String exitTypeCallChain = ArrayEncoder.stringArrayToString(exitTypes, ',');
        String exitSubTypeCallChain = ArrayEncoder.stringArrayToString(exitSubTypes, ',');
        String toCompChain = ArrayEncoder.stringArrayToString(componentToIDs, ',');
        if (exitCallPositionVsLatestThreadAddId != null && !exitCallPositionVsLatestThreadAddId.isEmpty()) {
            String threadChain = ThreadChainParserUtil.encodeThreadChain((Map<Integer, String>)exitCallPositionVsLatestThreadAddId);
            corHeader.addHeader("tcop", threadChain);
            if (null != headerChain) {
                headerChain.setThreadCallChainForOutOfProcess(threadChain);
            }
        }
        if (headerChain != null) {
            headerChain.setFromCompChain(componentFromIDs, fromCompChain);
            headerChain.setExitTypeCallChain(exitTypeCallChain);
            headerChain.setExitSubTypeCallChain(exitSubTypeCallChain);
            headerChain.setToCompChain(toCompChain);
        }
        String threadCallChainForOutOfProcess = null != headerChain ? headerChain.getThreadCallChainForOutOfProcess() : null;
        this.addComponentLinkHeaderChain(exitType, exitSubtype, backendComponentID, componentFromIDs, fromCompChain, exitTypeCallChain, exitSubTypeCallChain, toCompChain, corHeader, threadCallChainForOutOfProcess);
    }

    private void addComponentLinkHeaderChain(String exitType, String exitSubtype, String backendComponentID, List<String> fromCompIds, String fromChain, String exitTypeChain, String exitSubTypeChain, String toChain, CorrelationHeader corHeader, String threadChain) throws CorrelationHeaderOverSizedException {
        String exitTypeName = exitType;
        corHeader.addHeader("cidfrom", fromChain);
        StringBuilder exitCallChain = new StringBuilder(exitTypeChain);
        if (exitCallChain.length() > 0) {
            exitCallChain.append(',');
        }
        exitCallChain.append(exitTypeName);
        corHeader.addHeader("etypeorder", exitCallChain);
        StringBuilder exitSubTypeCallChain = new StringBuilder(exitSubTypeChain);
        if (exitSubTypeCallChain.length() > 0) {
            exitSubTypeCallChain.append(',');
        }
        exitSubTypeCallChain.append(exitSubtype);
        corHeader.addHeader("esubtype", exitSubTypeCallChain);
        StringBuilder toComp = new StringBuilder(toChain);
        if (toComp.length() > 0) {
            toComp.append(',');
        }
        toComp.append(backendComponentID);
        corHeader.addHeader("cidto", toComp);
        if (StringOperations.isNotEmpty(threadChain)) {
            corHeader.addHeader("tcop", threadChain);
        }
    }

    private String getExitCallIdentificationHeader(CurrentTransactionContext context, int exitCallCounter) {
        String previousString = context.getCorrelatedSequenceString();
        return previousString == null ? String.valueOf(exitCallCounter) : previousString + "|" + exitCallCounter;
    }

    private boolean isCallerChainTooLong(List<ComponentLink> componentLinks, TransactionMonitoringContext transactionMonitoringContext) {
        int len = 0;
        for (ComponentLink componentLink : componentLinks) {
            len += componentLink.getMetricSegmentLength();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s %s length[%s]", "componentLinks", componentLinks, len);
        }
        return len + 51 > transactionMonitoringContext.getMaxMetricNameLength();
    }

    public CurrentTransactionContext createTransactionContext(String correlationHeader, TransactionMonitoringContext transactionMonitoringContext) {
        if (StringOperations.isNotEmpty(correlationHeader)) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Creating transaction for header [%s]", correlationHeader);
            return this.createContinuingTransactionContext(correlationHeader, transactionMonitoringContext);
        }
        String btName = StringOperations.isNotEmpty(transactionMonitoringContext.getBtName()) ? transactionMonitoringContext.getBtName() : transactionMonitoringContext.getDefaultBtName();
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Correlation header is empty. Will create a transaction with bt name = %s", btName);
        return this.createOriginatingTransaction(transactionMonitoringContext);
    }

    private CurrentTransactionContext createCurrentTransactionContext(TransactionMonitoringContext transactionMonitoringContext) {
        String btName = transactionMonitoringContext.getBtName();
        if (btName == null || btName.isEmpty()) {
            btName = transactionMonitoringContext.getDefaultBtName();
        }
        CurrentTransactionContext ctc = new CurrentTransactionContext(UUID.randomUUID().toString(), transactionMonitoringContext.getBtId(), btName, transactionMonitoringContext.getApplicationId());
        ctc.setControllerGUID(transactionMonitoringContext.getControllerGUID());
        ctc.setAccountGUID(transactionMonitoringContext.getAccountGUID());
        ctc.setComponentID(transactionMonitoringContext.getTierId());
        return ctc;
    }

    private CurrentTransactionContext createContinuingTransactionContext(String correlationHeader, TransactionMonitoringContext transactionMonitoringContext) {
        String async2;
        CorrelationHeader ch;
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s => %s", "Processing continuing transaction", correlationHeader);
        CorrelationHeader corHeader = new CorrelationHeader(correlationHeader);
        if (this.checkIfTransactionIsDisabled(corHeader)) {
            return null;
        }
        List<ComponentLink> componentLinks = this.readCallerChain(corHeader, transactionMonitoringContext);
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Caller chains read => %s", componentLinks);
        if (componentLinks == null || componentLinks.isEmpty()) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Not correlating transaction due to potentially malformed header [%s]", correlationHeader);
            return this.createOriginatingTransaction(transactionMonitoringContext);
        }
        if (this.isCallerChainTooLong(componentLinks, transactionMonitoringContext)) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Caller chain too long. Will not correlate transaction. Will not send any caller chain in the event payloads", new Object[0]);
            return this.createOriginatingTransaction(transactionMonitoringContext);
        }
        String upstreamAcctGuid = corHeader.getHeader("acctguid");
        String upstreamAppId = corHeader.getHeader("appId");
        String localAppId = String.valueOf(transactionMonitoringContext.getApplicationId());
        String localAcctGuid = transactionMonitoringContext.getAccountGUID();
        String registeredIDHeader = corHeader.getHeader("btid");
        List<String> registeredIDs = this.parseHeader(registeredIDHeader);
        boolean doNotResolve = StringOperations.safeParseBoolean(corHeader.getHeader("donotresolve"));
        try {
            ch = new CorrelationHeader();
            ch.addHeader("appId", upstreamAppId);
            ch.addHeader("acctguid", upstreamAcctGuid);
            ch.addHeader("donotresolve", Boolean.toString(doNotResolve));
            ch.addHeader("cidfrom", corHeader.getHeader("cidfrom"));
            ch.addHeader("etypeorder", corHeader.getHeader("etypeorder"));
            ch.addHeader("esubtype", corHeader.getHeader("esubtype"));
            ch.addHeader("cidto", corHeader.getHeader("cidto"));
            ch.addHeader("unresolvedexitid", corHeader.getHeader("unresolvedexitid"));
            ch.addHeader("tcop", corHeader.getHeader("tcop"));
        }
        catch (CorrelationHeaderOverSizedException e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Caller chain too long. Will not correlate transaction. Will not send any caller chain in the event payloads", new Object[0]);
            ch = null;
        }
        if (StringOperations.isNotEmpty(upstreamAcctGuid) && !StringOperations.eqOrNull(upstreamAcctGuid, localAcctGuid) || StringOperations.isNotEmpty(upstreamAppId) && !StringOperations.eqOrNull(upstreamAppId, localAppId)) {
            CurrentTransactionContext ctc = this.createOriginatingTransaction(transactionMonitoringContext);
            if (null != ch && null != ctc) {
                ctc.setCallerChainAsString(ch.getHeaderString());
            }
            return ctc;
        }
        String debugEnabled = corHeader.getHeader("debug");
        String reqGUID = corHeader.getHeader("guid");
        String btName = transactionMonitoringContext.getBtName();
        if (btName == null) {
            btName = transactionMonitoringContext.getDefaultBtName();
        }
        CurrentTransactionContext context = new CurrentTransactionContext(reqGUID, Long.valueOf(registeredIDs.iterator().next()), btName, transactionMonitoringContext.getApplicationId());
        context.setCallerComponentList(componentLinks);
        if (null != ch) {
            context.setCallerChainAsString(ch.getHeaderString());
        }
        context.setContinuingTransaction(true);
        context.setComponentID(transactionMonitoringContext.getTierId());
        context.setAccountGUID(transactionMonitoringContext.getAccountGUID());
        context.setDoNotResolve(doNotResolve);
        if (debugEnabled != null && Boolean.TRUE.toString().equals(debugEnabled)) {
            context.setDebugRequired(true);
        }
        if ((async2 = corHeader.getHeader("async")) != null) {
            context.setIsAsync2ContinuingTransaction(StringOperations.safeParseBoolean(async2));
        }
        String requestGUID = corHeader.getHeader("guid");
        String snapEnableHeader = corHeader.getHeader("snapenable");
        boolean snapshotEnabled = Boolean.parseBoolean(snapEnableHeader);
        String devModeEnableHeader = corHeader.getHeader("devmodeenabled");
        boolean devModeEnabled = Boolean.parseBoolean(devModeEnableHeader);
        String forceHotspotHeader = corHeader.getHeader("hotspotenable");
        boolean forceHotspot = Boolean.parseBoolean(forceHotspotHeader);
        String hotspotCollectCPUHeader = corHeader.getHeader("hotspotcpu");
        boolean hotspotCollectCPU = Boolean.parseBoolean(hotspotCollectCPUHeader);
        String skewAdjustedBeginTimeStamp = corHeader.getHeader("ts");
        if (skewAdjustedBeginTimeStamp != null) {
            context.setSkewAdjustedBeginTimestamp(skewAdjustedBeginTimeStamp);
        }
        context.setRequestGUID(requestGUID);
        String snapshotSequenceIdentifier = corHeader.getHeader("exitguid");
        context.setCorrelatedSequenceString(snapshotSequenceIdentifier);
        context.setCorrelationHeader(correlationHeader);
        context.setSnapshotEnabled(snapshotEnabled);
        context.setDevModeEnabled(devModeEnabled);
        context.setForceHotspotSnapshot(forceHotspot);
        context.setHotspotCollectingCPUTime(hotspotCollectCPU);
        String ctrlGuid = corHeader.getHeader("ctrlguid");
        if (null != ctrlGuid) {
            context.setControllerGUID(ctrlGuid);
        }
        return context;
    }

    private CurrentTransactionContext createOriginatingTransaction(TransactionMonitoringContext transactionMonitoringContext) {
        try {
            Map<BTIdentifyingInfo, RegisteredBT> cache;
            RegisteredBT bt;
            String btName = transactionMonitoringContext.getBtName();
            if (btName == null || btName.isEmpty()) {
                btName = transactionMonitoringContext.getDefaultBtName();
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "BtName empty/null in the current transaction context. Will be using the default BT name => %s , to create the transaction.", btName);
            }
            if (null != (bt = (cache = transactionMonitoringContext.getBtInfoToRegisteredInfoCache()).get(new BTIdentifyingInfo(btName, "POJO")))) {
                transactionMonitoringContext.setBtId(bt.getId());
                transactionMonitoringContext.setBtName(bt.getName());
                return this.createCurrentTransactionContext(transactionMonitoringContext);
            }
            Optional<BTIdentifyingInfo> overflowBt = cache.keySet().stream().filter(btii -> OVERFLOW_TRANSACTION_NAME.equals(btii.getName())).findFirst();
            if (overflowBt.isPresent()) {
                bt = cache.get(overflowBt.get());
                this.logger.log(AWSLambdaLogger.LogLevel.WARN, "Using overflow-registered BT: %s", bt);
                transactionMonitoringContext.setBtId(bt.getId());
                transactionMonitoringContext.setBtName(bt.getName());
            } else {
                BTRegistrationEvent btRegistrationEvent = new BTRegistrationEvent(Event.Type.REGISTRATION_BT.name(), btName, "POJO", "1");
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Sending registration request => %s", btRegistrationEvent);
                transactionMonitoringContext.getEventManager().offer(btRegistrationEvent);
            }
            return this.createCurrentTransactionContext(transactionMonitoringContext);
        }
        catch (Exception e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Error converting to originating transaction [%s]", e.getMessage());
            return null;
        }
    }

    private boolean checkIfTransactionIsDisabled(CorrelationHeader corHeader) {
        String disableTxDetectHeader = corHeader.getHeader("notxdetect");
        boolean disableTxDetectHeaderParsed = Boolean.parseBoolean(disableTxDetectHeader);
        if (disableTxDetectHeaderParsed) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "%s", "Not correlating transaction, disabled from the originating tier, setting request context");
            return true;
        }
        return false;
    }

    private List<ComponentLink> readCallerChain(CorrelationHeader corHeader, TransactionMonitoringContext transactionMonitoringContext) {
        ArrayList<ComponentLink> componentLinks = new ArrayList<ComponentLink>();
        List<String> fromComponentIDs = this.parseHeader(corHeader.getHeader("cidfrom"));
        List<String> exitTypes = this.parseHeader(corHeader.getHeader("etypeorder"));
        List<String> exitSubtypes = this.parseHeader(corHeader.getHeader("esubtype"));
        List<String> toComponentIDs = this.parseHeader(corHeader.getHeader("cidto"));
        Map<Integer, String> threadAddIds = null;
        boolean useNewAsyncCorrelation = transactionMonitoringContext.isUseNewAsyncCorrelation();
        if (useNewAsyncCorrelation) {
            threadAddIds = this.parseThreadChain(corHeader.getHeader("tcop"));
        }
        if (fromComponentIDs.size() != toComponentIDs.size()) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Malformed header fromChain %s , toChain %s", fromComponentIDs, toComponentIDs);
            return componentLinks;
        }
        if (exitSubtypes.size() == 0) {
            exitSubtypes = new ArrayList<String>();
            exitSubtypes.addAll(exitTypes);
        }
        if (exitTypes.size() != exitSubtypes.size()) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "Malformed header exitTypes %s , exitSubTypes %s", exitTypes, exitSubtypes);
            return componentLinks;
        }
        for (int i = 0; i < fromComponentIDs.size(); ++i) {
            TransactionExitPointType exitType = Enum.valueOf(TransactionExitPointType.class, exitTypes.get(i));
            String exitSubType = exitSubtypes.get(i);
            ComponentLink cl = new ComponentLink(fromComponentIDs.get(i), toComponentIDs.get(i), exitType, exitSubType);
            if (useNewAsyncCorrelation && threadAddIds != null) {
                cl.setLatestThreadAddId(threadAddIds.get(i + 1));
            }
            componentLinks.add(cl);
        }
        return componentLinks;
    }

    private Map<Integer, String> parseThreadChain(String header) {
        return ThreadChainParserUtil.parseThreadChain(header);
    }

    private List<String> parseHeader(String header) {
        return StringOperations.parseCommaSeparatedString(header);
    }
}

