/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.correlation;

import com.appdynamics.serverless.tracers.aws.correlation.CorrelationHeaderOverSizedException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CorrelationHeader {
    public static final String DEV_MODE_ENABLED = "devmodeenabled";
    public static final String APPLICATION_ID = "appId";
    public static final String BUSINESS_TRANSACTION_ID_HEADER = "btid";
    public static final String SNAPSHOT_ENABLE_HEADER = "snapenable";
    public static final String REQUEST_GUID_HEADER = "guid";
    public static final String EXIT_POINT_GUID_HEADER = "exitguid";
    public static final String COMPONENT_ID_FROM_HEADER = "cidfrom";
    public static final String COMPONENT_ID_TO_HEADER = "cidto";
    public static final String EXIT_CALL_TYPE_ORDER = "etypeorder";
    public static final String EXIT_CALL_SUBTYPE = "esubtype";
    public static final String CID_IS_APPID_PREFIX = "A";
    public static final String CID_IS_FEDERATED_APPID_PREFIX = "Ex";
    public static final String ASYNC_CALL = "async";
    public static final String UNRESOLVED_EXIT_ID_HEADER = "unresolvedexitid";
    public static final String FORCE_HOTSPOT_COLLECT = "hotspotenable";
    public static final String HOTSPOT_COLLECTING_CPU_TIME = "hotspotcpu";
    public static final String DEBUG_ENABLED_HEADER = "debug";
    public static final String ORIGIN_TIMESTAMP = "ts";
    public static final String DISABLE_TRANSACTION_DETECTION_HEADER = "notxdetect";
    public static final char VALUE_DELIMITER = ',';
    public static final String THREAD_CALL_CHAIN_FOR_OUT_OF_PROCESS = "tcop";
    public static final String DONOTRESOLVE = "donotresolve";
    public static final String ACCOUNT_GUID = "acctguid";
    public static final String CONTROLLER_GUID = "ctrlguid";
    private static final String HEADER_SEPARATOR = "*";
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "=";
    private static final int INITIAL_CAPACITY = 100;
    private static final int DEFAULT_MAX_CORRELATION_HEADER_SIZE = 4096;
    private StringBuilder stringBuilder;
    private Map<String, String> headers;

    CorrelationHeader() {
        this(new StringBuilder(100));
    }

    CorrelationHeader(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    CorrelationHeader(String header) {
        this.headers = new HashMap<String, String>();
        this.parseHeaders(header);
    }

    private void parseHeaders(String aggregateHeader) {
        aggregateHeader = this.sanitizeHeader(aggregateHeader);
        StringTokenizer headerTokenizer = new StringTokenizer(aggregateHeader, HEADER_SEPARATOR);
        while (headerTokenizer.hasMoreTokens()) {
            String header = headerTokenizer.nextToken();
            StringTokenizer valueTokenizer = new StringTokenizer(header, ATTRIBUTE_VALUE_SEPARATOR);
            String attribute = valueTokenizer.nextToken();
            if (valueTokenizer.hasMoreTokens()) {
                this.headers.put(attribute, valueTokenizer.nextToken());
                continue;
            }
            this.headers.put(attribute, "");
        }
    }

    private String sanitizeHeader(String aggregateHeader) {
        if (this.isCorrelationSplitDisabled()) {
            return aggregateHeader;
        }
        String[] _headers = aggregateHeader.split(", ");
        if (_headers.length > 0) {
            aggregateHeader = _headers[_headers.length - 1];
        }
        return aggregateHeader;
    }

    private boolean isCorrelationSplitDisabled() {
        return false;
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public String getHeader(String attribute) {
        return this.headers.get(attribute);
    }

    public void addHeader(String headerAttribute, String headerValue) throws CorrelationHeaderOverSizedException {
        if (null == headerValue) {
            return;
        }
        int previousLength = this.stringBuilder.length();
        String headerSeparator = HEADER_SEPARATOR;
        int expectedSizeAfterAppend = previousLength + (previousLength != 0 ? headerSeparator.length() : 0) + headerAttribute.length() + ATTRIBUTE_VALUE_SEPARATOR.length() + headerValue.length();
        if (expectedSizeAfterAppend > 4096) {
            throw new CorrelationHeaderOverSizedException();
        }
        if (previousLength != 0) {
            this.stringBuilder.append(headerSeparator);
        }
        this.stringBuilder.append(headerAttribute).append(ATTRIBUTE_VALUE_SEPARATOR).append(headerValue);
    }

    public void addHeader(String headerAttribute, StringBuilder headerValue) throws CorrelationHeaderOverSizedException {
        this.addHeader(headerAttribute, headerValue.toString());
    }

    public String getHeaderString() {
        return this.stringBuilder.toString();
    }
}

