/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.api;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.appdynamics.serverless.tracers.aws.api.AppDynamics;
import com.appdynamics.serverless.tracers.aws.api.Tracer;
import com.appdynamics.serverless.tracers.aws.api.Transaction;
import com.appdynamics.serverless.tracers.aws.impl.NoOpTransaction;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.logging.SysOutLogger;
import com.appdynamics.serverless.tracers.aws.utils.InputStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class MonitoredRequestStreamHandler
implements RequestStreamHandler {
    private Transaction transaction;

    @Override
    public final void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        AppDynamics.Config.Builder builder = this.getConfigBuilder(context);
        Tracer tracer = builder != null ? AppDynamics.getTracer(builder.build()) : AppDynamics.getTracer(context);
        inputStream = InputStreamConverter.convertToMarkSupportedInputStream(inputStream);
        inputStream.mark(6000000);
        String correlationHeader = this.getCorrelationHeader(inputStream, context);
        try {
            inputStream.reset();
        }
        catch (IOException e) {
            System.out.println("[ERROR]: exception trying to reset input stream in MonitoredRequestStreamHandler: " + e.getMessage());
        }
        this.transaction = correlationHeader != null ? tracer.createTransaction(correlationHeader) : tracer.createTransaction(inputStream, context);
        if (this.transaction == null) {
            this.transaction = new NoOpTransaction(new SysOutLogger(AWSLambdaLogger.LogLevel.INFO));
        }
        try {
            this.transaction.start();
            this.handleMonitoredRequest(inputStream, outputStream, context);
        }
        catch (Throwable e) {
            this.transaction.reportError(e);
            throw e;
        }
        finally {
            this.transaction.stop();
            AppDynamics.cleanup();
        }
    }

    public AppDynamics.Config.Builder getConfigBuilder(Context context) {
        return null;
    }

    public String getCorrelationHeader(InputStream inputStream, Context context) {
        return null;
    }

    public final Transaction getTransaction() {
        return this.transaction;
    }

    public abstract void handleMonitoredRequest(InputStream var1, OutputStream var2, Context var3) throws IOException;
}

