/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.api;

import com.appdynamics.serverless.tracers.aws.api.AppDynamics;
import com.appdynamics.serverless.tracers.aws.correlation.TransactionCorrelator;
import com.appdynamics.serverless.tracers.aws.errors.ErrorHelper;
import com.appdynamics.serverless.tracers.aws.errors.ExceptionOperations;
import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.logging.AWSCloudWatchLogger;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.logging.CloudWatchLoggerFactory;
import com.appdynamics.serverless.tracers.aws.logging.LambdaLoggerWrapper;
import com.appdynamics.serverless.tracers.aws.logging.SysOutLogger;
import com.appdynamics.serverless.tracers.aws.publish.EventManager;
import com.appdynamics.serverless.tracers.aws.publish.EventService;
import com.appdynamics.serverless.tracers.aws.registration.RegistrationService;
import com.appdynamics.serverless.tracers.aws.utils.EnvironmentVariableUtil;
import com.appdynamics.serverless.tracers.aws.utils.ServiceProvider;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.xml.bind.DatatypeConverter;

class AppDynamicsBuilder {
    static AWSLambdaLogger logger = new SysOutLogger(AWSLambdaLogger.LogLevel.INFO);
    static final int AGENT_CONFIG_CONNECT_TIMEOUT_MILLIS = 5000;
    static final int AGENT_CONFIG_READ_TIMEOUT_MILLIS = 10000;
    final CloudWatchLoggerFactory cloudWatchLoggerFactory;

    AppDynamicsBuilder(CloudWatchLoggerFactory cloudWatchLoggerFactory) {
        this.cloudWatchLoggerFactory = cloudWatchLoggerFactory;
    }

    AppDynamics build(AppDynamics.Config config) throws NoSuchAlgorithmException {
        ServiceProvider<RegistrationService> registrationServiceProvider = new ServiceProvider<RegistrationService>();
        ServiceProvider<EventService> eventServiceProvider = new ServiceProvider<EventService>();
        logger = this.initLogger(config.getLambdaLogger());
        logger.log(AWSLambdaLogger.LogLevel.INFO, "Initializing AppDynamics Agent.", new Object[0]);
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("x-api-key", this.calculateAPIKey(config));
        headers.put("x-appd-routing-key", this.generateRoutingKey(config));
        headers.put("Content-Type", "application/json");
        RegistrationService registrationService = this.initRegistrationService(registrationServiceProvider, headers);
        EventService eventService = this.initEventService(eventServiceProvider, headers);
        int eventQueueSize = EnvironmentVariableUtil.getEnvInt("APPDYNAMICS_EVENTS_QUEUE_SIZE", 5000);
        ArrayBlockingQueue<Event> queue = new ArrayBlockingQueue<Event>(eventQueueSize);
        long eventFlushPeriodMs = EnvironmentVariableUtil.getEnvLong("APPDYNAMICS_EVENTS_FLUSH_PERIOD_MS", 5000L);
        EventManager eventManager = new EventManager(queue, logger, eventService, eventFlushPeriodMs);
        TransactionCorrelator txCorrelator = new TransactionCorrelator(logger);
        ExceptionOperations exceptionOperations = new ExceptionOperations(logger);
        int stackTraceLineLimit = StringOperations.safeParseInt(System.getenv("ENV_ERROR_STACKTRACE_LINE_LIMIT_PER_THROWABLE"), 200);
        int totalStackTraceCharCountLimit = 4500;
        ErrorHelper errorHelper = new ErrorHelper(logger, exceptionOperations, stackTraceLineLimit, totalStackTraceCharCountLimit);
        return new AppDynamics(registrationService, eventManager, txCorrelator, errorHelper, config, logger);
    }

    AWSLambdaLogger initLogger(Object lambdaLogger) {
        AWSLambdaLogger newLogger = logger;
        if (null != lambdaLogger) {
            try {
                newLogger = new LambdaLoggerWrapper(lambdaLogger);
                logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Setting logger to LambdaLogger.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                logger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR creating logger => %s", e.getMessage());
            }
        } else {
            try {
                AWSCloudWatchLogger cloudWatchLogger = this.cloudWatchLoggerFactory.build();
                if (cloudWatchLogger != null) {
                    newLogger = cloudWatchLogger;
                    logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Setting logger to CloudWatchLogger.", new Object[0]);
                }
            }
            catch (Exception e) {
                logger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR creating logger => %s", e.getMessage());
            }
        }
        AWSLambdaLogger.LogLevel level = this.getLogLevel();
        newLogger.log(AWSLambdaLogger.LogLevel.INFO, "%s => [%s]", new Object[]{"Setting log level to", level});
        newLogger.setCurrentLogLevel(level);
        this.logVersion();
        return newLogger;
    }

    AWSLambdaLogger.LogLevel getLogLevel() {
        String logLevel = System.getenv("APPDYNAMICS_LOG_LEVEL");
        if (logLevel == null) {
            logger.log(AWSLambdaLogger.LogLevel.INFO, "%s %s", "APPDYNAMICS_LOG_LEVEL", " environment property is empty. Will set log level to [INFO]");
            return AWSLambdaLogger.LogLevel.INFO;
        }
        logLevel = logLevel.trim();
        logger.log(AWSLambdaLogger.LogLevel.INFO, "Found environment property [%s = %s]", "APPDYNAMICS_LOG_LEVEL", logLevel);
        AWSLambdaLogger.LogLevel level = AWSLambdaLogger.LogLevel.valueOf(logLevel);
        return level;
    }

    void logVersion() {
        logger.log(AWSLambdaLogger.LogLevel.INFO, "Version Info: [%s]", AppDynamics.getVersion());
    }

    String calculateAPIKey(AppDynamics.Config config) {
        String payload = config.getControllerAccessKey() + "-" + config.getAccountName();
        try {
            return this.calculateHash("SHA-256", payload);
        }
        catch (NoSuchAlgorithmException e) {
            String err = "Failed to generate API key with error: '%s'. Please verify that you have configured the %s and %s variables correctly.";
            logger.log(AWSLambdaLogger.LogLevel.ERROR, err, e.getMessage(), "APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY", "APPDYNAMICS_ACCOUNT_NAME");
            throw new RuntimeException(e);
        }
    }

    RegistrationService initRegistrationService(ServiceProvider<RegistrationService> registrationServiceProvider, Map<String, String> headers) {
        String registrationServiceUrl = this.getServiceUrl("ENV_REGISTRATION_SERVICE_URL", "/v1/agentconfig", "https://7uwanm08gk.execute-api.us-west-2.amazonaws.com/Stage/agentconfig");
        return registrationServiceProvider.get(registrationServiceUrl, RegistrationService.class, logger, headers, 5000, 10000);
    }

    EventService initEventService(ServiceProvider<EventService> eventServiceProvider, Map<String, String> headers) {
        headers.put("x-appd-request-type", "AGENT_CONFIG");
        String eventServiceUrl = this.getServiceUrl("ENV_EVENT_SERVICE_URL", "/v1/events", "https://7uwanm08gk.execute-api.us-west-2.amazonaws.com/Stage/events");
        return eventServiceProvider.get(eventServiceUrl, EventService.class, logger, headers);
    }

    String getServiceUrl(String envName, String defaultPath, String defaultUrl) {
        String url = System.getenv(envName);
        if (url == null) {
            String serverlessApiEndpoint = System.getenv("APPDYNAMICS_SERVERLESS_API_ENDPOINT");
            if (serverlessApiEndpoint != null) {
                if ((serverlessApiEndpoint = serverlessApiEndpoint.trim()).endsWith("/")) {
                    serverlessApiEndpoint = serverlessApiEndpoint.substring(0, serverlessApiEndpoint.length() - 1);
                }
                url = serverlessApiEndpoint + defaultPath;
            } else {
                logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Could not find serverless API endpoint for '" + envName + "'. Defaulting to '" + defaultUrl + "'.", new Object[0]);
                url = defaultUrl;
            }
        }
        if (url != null) {
            url = url.trim();
            String httpPrefix = "http://";
            String httpsPrefix = "https://";
            if (url.startsWith("http://")) {
                url = url.substring("http://".length());
                url = "https://" + url;
            }
            if (!url.startsWith("https://")) {
                url = "https://" + url;
            }
        }
        return url;
    }

    String generateRoutingKey(AppDynamics.Config config) throws NoSuchAlgorithmException {
        String key = String.join((CharSequence)"|", config.getControllerHost(), Integer.toString(config.getControllerPort()), config.getAccountName(), config.getApplicationName(), config.getTierName(), AppDynamics.getVersion());
        String routingKey = this.calculateHash("SHA-1", key);
        logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Generated hash [%s] for key [%s]", routingKey, key);
        return routingKey;
    }

    String calculateHash(String algorithm, String key) throws NoSuchAlgorithmException {
        byte[] hash = MessageDigest.getInstance(algorithm).digest(key.getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printHexBinary((byte[])hash).toLowerCase();
    }
}

