/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.content.Context;
import com.appdynamics.eumagent.runtime.CollectorChannel;
import com.appdynamics.eumagent.runtime.CollectorChannelFactory;
import com.appdynamics.eumagent.runtime.CrashReportCallback;
import com.appdynamics.eumagent.runtime.DontObfuscate;
import com.appdynamics.eumagent.runtime.NetworkRequestCallback;
import com.appdynamics.eumagent.runtime.private.n;
import java.util.Set;

@DontObfuscate
public class AgentConfiguration {
    public final String appKey;
    public final String applicationName;
    public final Context context;
    public final String collectorURL;
    public final String screenshotURL;
    public final int loggingLevel;
    public final CollectorChannelFactory collectorChannelFactory;
    public final Set<String> excludedUrlPatterns;
    public final boolean compileTimeInstrumentationCheck;
    public final boolean autoInstrument;
    public final CrashReportCallback crashCallback;
    public final NetworkRequestCallback networkRequestCallback;
    public final int interactionCaptureMode;
    public final boolean screenshotsEnabled;
    public final boolean jsAgentInjectionEnabled;
    public final boolean jsAgentAjaxEnabled;

    AgentConfiguration(String string, Context context, String string2, String string3, int n2, CollectorChannelFactory collectorChannelFactory, String string4, Set<String> set, boolean bl2, boolean bl3, CrashReportCallback crashReportCallback, NetworkRequestCallback networkRequestCallback, int n3, boolean bl4, boolean bl5, boolean bl6) {
        this.appKey = string;
        this.context = context;
        this.collectorURL = string2;
        this.screenshotURL = string3;
        this.loggingLevel = n2;
        this.collectorChannelFactory = collectorChannelFactory;
        this.applicationName = string4;
        this.excludedUrlPatterns = set;
        this.compileTimeInstrumentationCheck = bl2;
        this.autoInstrument = bl3;
        this.crashCallback = crashReportCallback;
        this.networkRequestCallback = networkRequestCallback;
        this.interactionCaptureMode = n3;
        this.screenshotsEnabled = bl4;
        this.jsAgentInjectionEnabled = bl5;
        this.jsAgentAjaxEnabled = bl6;
    }

    public String toString() {
        return "AgentConfiguration{appKey='" + this.appKey + '\'' + ", context=" + this.context + ", collectorURL='" + this.collectorURL + '\'' + ", loggingLevel=" + this.loggingLevel + ", collectorChannelFactory=" + this.collectorChannelFactory + ", applicationName='" + this.applicationName + '\'' + ", urlFilterPatterns=" + (this.excludedUrlPatterns == null ? null : "[" + this.excludedUrlPatterns.toString() + "]") + ", compileTimeInstrumentationCheck=" + this.compileTimeInstrumentationCheck + ", autoInstrument=" + this.autoInstrument + ", crashCallback=" + this.crashCallback + ", networkRequestCallback=" + this.networkRequestCallback + ", interactionCaptureMode=" + this.interactionCaptureMode + ", screenshotsEnabled=" + this.screenshotsEnabled + ", jsAgentEnabled=" + this.jsAgentInjectionEnabled + ", jsAgentAjaxEnabled=" + this.jsAgentAjaxEnabled + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    @DontObfuscate
    public static class Builder {
        private static final String DEFAULT_COLLECTOR_HOST = "https://mobile.eum-appdynamics.com";
        private static final String DEFAULT_SCREENSHOT_HOST = "https://image.eum-appdynamics.com";
        private String appKey;
        private String applicationName;
        private Context context;
        private String collectorURL;
        private String screenshotURL;
        private int loggingLevel = 3;
        private int interactionCaptureMode;
        private CollectorChannelFactory collectorChannelFactory;
        private Set<String> excludedUrlPatterns;
        private boolean compileTimeInstrumentationCheck = true;
        private boolean autoInstrument = true;
        private CrashReportCallback crashCallback = null;
        private NetworkRequestCallback networkRequestCallback = null;
        private boolean screenshotsEnabled = true;
        private boolean jsAgentInjectionEnabled = true;
        private boolean jsAgentAjaxEnabled = false;

        private Builder() {
        }

        public Builder withAppKey(String string) {
            this.appKey = string;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withCollectorURL(String string) {
            this.collectorURL = string;
            return this;
        }

        public Builder withScreenshotURL(String string) {
            this.screenshotURL = string;
            return this;
        }

        public Builder withApplicationName(String string) {
            this.applicationName = string;
            return this;
        }

        public Builder withExcludedUrlPatterns(Set<String> set) {
            this.excludedUrlPatterns = set;
            return this;
        }

        public Builder withLoggingEnabled(boolean bl2) {
            return this.withLoggingLevel(bl2 ? 2 : 3);
        }

        public Builder withLoggingLevel(int n2) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Logging Level: " + n2);
                }
            }
            this.loggingLevel = n2;
            return this;
        }

        public Builder withCompileTimeInstrumentationCheck(boolean bl2) {
            this.compileTimeInstrumentationCheck = bl2;
            return this;
        }

        public Builder withAutoInstrument(boolean bl2) {
            this.autoInstrument = bl2;
            return this;
        }

        public Builder withInteractionCaptureMode(int n2) {
            this.interactionCaptureMode = n2;
            return this;
        }

        public Builder withCollectorChannelFactory(CollectorChannelFactory collectorChannelFactory) {
            this.collectorChannelFactory = collectorChannelFactory;
            return this;
        }

        public Builder withCrashCallback(CrashReportCallback crashReportCallback) {
            this.crashCallback = crashReportCallback;
            return this;
        }

        public Builder withNetworkRequestCallback(NetworkRequestCallback networkRequestCallback) {
            this.networkRequestCallback = networkRequestCallback;
            return this;
        }

        public Builder withScreenshotsEnabled(boolean bl2) {
            this.screenshotsEnabled = bl2;
            return this;
        }

        public Builder withJSAgentInjectionEnabled(boolean bl2) {
            this.jsAgentInjectionEnabled = bl2;
            return this;
        }

        public Builder withJSAgentAjaxEnabled(boolean bl2) {
            this.jsAgentAjaxEnabled = bl2;
            return this;
        }

        public AgentConfiguration build() {
            if (!this.autoInstrument) {
                this.interactionCaptureMode = 0;
            }
            if (this.screenshotURL == null && this.collectorURL != null) {
                this.screenshotURL = this.collectorURL;
            }
            if (this.screenshotURL == null) {
                this.screenshotURL = DEFAULT_SCREENSHOT_HOST;
            }
            if (this.collectorURL == null) {
                this.collectorURL = DEFAULT_COLLECTOR_HOST;
            }
            if (this.collectorChannelFactory == null) {
                this.collectorChannelFactory = new CollectorChannelFactory(){

                    @Override
                    public final CollectorChannel newCollectorChannel() {
                        return new n();
                    }
                };
            }
            return new AgentConfiguration(this.appKey, this.context, this.collectorURL, this.screenshotURL, this.loggingLevel, this.collectorChannelFactory, this.applicationName, this.excludedUrlPatterns, this.compileTimeInstrumentationCheck, this.autoInstrument, this.crashCallback, this.networkRequestCallback, this.interactionCaptureMode, this.screenshotsEnabled, this.jsAgentInjectionEnabled, this.jsAgentAjaxEnabled);
        }
    }
}

