/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.content.Context;
import com.appdynamics.eumagent.runtime.CollectorChannel;
import com.appdynamics.eumagent.runtime.CollectorChannelFactory;
import com.appdynamics.eumagent.runtime.CrashReportCallback;
import com.appdynamics.eumagent.runtime.DontObfuscate;
import com.appdynamics.eumagent.runtime.private.n;
import java.util.Set;

@DontObfuscate
public class AgentConfiguration {
    final String appKey;
    final String applicationName;
    final Context context;
    final String collectorURL;
    final int loggingLevel;
    final CollectorChannelFactory collectorChannelFactory;
    final Set<String> excludedUrlPatterns;
    final boolean compileTimeInstrumentationCheck;
    final boolean autoInstrument;
    final CrashReportCallback crashCallback;
    final int interactionCaptureMode;

    AgentConfiguration(String string, Context context, String string2, int n2, CollectorChannelFactory collectorChannelFactory, String string3, Set<String> set, boolean bl2, boolean bl3, CrashReportCallback crashReportCallback, int n3) {
        this.appKey = string;
        this.context = context;
        this.collectorURL = string2;
        this.loggingLevel = n2;
        this.collectorChannelFactory = collectorChannelFactory;
        this.applicationName = string3;
        this.excludedUrlPatterns = set;
        this.compileTimeInstrumentationCheck = bl2;
        this.autoInstrument = bl3;
        this.crashCallback = crashReportCallback;
        this.interactionCaptureMode = n3;
    }

    public String toString() {
        return "AgentConfiguration{appKey='" + this.appKey + '\'' + ", context=" + this.context + ", collectorURL='" + this.collectorURL + '\'' + ", loggingLevel=" + this.loggingLevel + ", collectorChannelFactory=" + this.collectorChannelFactory + ", applicationName='" + this.applicationName + '\'' + ", urlFilterPatterns=" + (this.excludedUrlPatterns == null ? null : "[" + this.excludedUrlPatterns.toString() + "]") + ", compileTimeInstrumentationCheck=" + this.compileTimeInstrumentationCheck + ", autoInstrument=" + this.autoInstrument + ", crashCallback=" + this.crashCallback + ", interactionCaptureMode=" + this.interactionCaptureMode + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    @DontObfuscate
    public static class Builder {
        private static final String DEFAULT_COLLECTOR_HOST = "https://mobile.eum-appdynamics.com";
        private String appKey;
        private String applicationName;
        private Context context;
        private String collectorURL = "https://mobile.eum-appdynamics.com";
        private int loggingLevel = 3;
        private int interactionCaptureMode;
        private CollectorChannelFactory collectorChannelFactory = new CollectorChannelFactory(){

            @Override
            public final CollectorChannel newCollectorChannel() {
                return new n();
            }
        };
        private Set<String> excludedUrlPatterns;
        private boolean compileTimeInstrumentationCheck = true;
        private boolean autoInstrument = true;
        private CrashReportCallback crashCallback = null;

        private Builder() {
        }

        public Builder withAppKey(String string) {
            this.appKey = string;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withCollectorURL(String string) {
            this.collectorURL = string;
            return this;
        }

        @Deprecated
        public Builder withDynamicInfoPointURL(String string) {
            return this;
        }

        public Builder withApplicationName(String string) {
            this.applicationName = string;
            return this;
        }

        public Builder withExcludedUrlPatterns(Set<String> set) {
            this.excludedUrlPatterns = set;
            return this;
        }

        public Builder withLoggingEnabled(boolean bl2) {
            return this.withLoggingLevel(bl2 ? 2 : 3);
        }

        public Builder withLoggingLevel(int n2) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Logging Level: " + n2);
                }
            }
            this.loggingLevel = n2;
            return this;
        }

        public Builder withCompileTimeInstrumentationCheck(boolean bl2) {
            this.compileTimeInstrumentationCheck = bl2;
            return this;
        }

        public Builder withAutoInstrument(boolean bl2) {
            this.autoInstrument = bl2;
            return this;
        }

        public Builder withInteractionCaptureMode(int n2) {
            this.interactionCaptureMode = n2;
            return this;
        }

        public Builder withCollectorChannelFactory(CollectorChannelFactory collectorChannelFactory) {
            this.collectorChannelFactory = collectorChannelFactory;
            return this;
        }

        public Builder withCrashCallback(CrashReportCallback crashReportCallback) {
            this.crashCallback = crashReportCallback;
            return this;
        }

        public AgentConfiguration build() {
            if (this.collectorChannelFactory == null) {
                throw new NullPointerException("collectorChannelFactory must not be null");
            }
            if (!this.autoInstrument) {
                this.interactionCaptureMode = 0;
            }
            return new AgentConfiguration(this.appKey, this.context, this.collectorURL, this.loggingLevel, this.collectorChannelFactory, this.applicationName, this.excludedUrlPatterns, this.compileTimeInstrumentationCheck, this.autoInstrument, this.crashCallback, this.interactionCaptureMode);
        }
    }
}

