/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.content.Context;
import com.appdynamics.eumagent.runtime.CollectorChannel;
import com.appdynamics.eumagent.runtime.CollectorChannelFactory;
import com.appdynamics.eumagent.runtime.CrashReportCallback;
import com.appdynamics.eumagent.runtime.a;
import com.appdynamics.eumagent.runtime.m;
import java.util.Set;

public class AgentConfiguration {
    final String appKey;
    final String applicationName;
    final Context context;
    final String collectorURL;
    final String dynInfoPointURL;
    final int loggingLevel;
    final CollectorChannelFactory collectorChannelFactory;
    final Set<String> excludedUrlPatterns;
    final boolean compileTimeInstrumentationCheck;
    final CrashReportCallback crashCallback;
    final int interactionCaptureMode;

    AgentConfiguration(String string, Context context, String string2, String string3, int n2, CollectorChannelFactory collectorChannelFactory, String string4, Set<String> set, boolean bl, CrashReportCallback crashReportCallback, int n3) {
        this.appKey = string;
        this.context = context;
        this.collectorURL = string2;
        this.dynInfoPointURL = string3;
        this.loggingLevel = n2;
        this.collectorChannelFactory = collectorChannelFactory;
        this.applicationName = string4;
        this.excludedUrlPatterns = set;
        this.compileTimeInstrumentationCheck = bl;
        this.crashCallback = crashReportCallback;
        this.interactionCaptureMode = n3;
    }

    public String toString() {
        return "AgentConfiguration{appKey='" + this.appKey + '\'' + ", context=" + this.context + ", collectorURL='" + this.collectorURL + '\'' + ", dynInfoPointURL='" + this.dynInfoPointURL + '\'' + ", loggingLevel=" + this.loggingLevel + ", collectorChannelFactory=" + this.collectorChannelFactory + ", applicationName='" + this.applicationName + '\'' + ", urlFilterPatterns=" + (this.excludedUrlPatterns == null ? null : "[" + this.excludedUrlPatterns.toString() + "]") + ", compileTimeInstrumentationCheck=" + this.compileTimeInstrumentationCheck + ", crashCallback=" + this.crashCallback + ", interactionCaptureMode=" + this.interactionCaptureMode + '}';
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static class Builder {
        private static final String DEFAULT_COLLECTOR_HOST = "https://mobile.eum-appdynamics.com";
        private static final String DEFAULT_DYN_INFOPOINT_HOST = "https://mobile-config.eum-appdynamics.com";
        private String appKey;
        private String applicationName;
        private Context context;
        private String collectorURL = "https://mobile.eum-appdynamics.com";
        private String dynInfoPointURL = "https://mobile-config.eum-appdynamics.com";
        private int loggingLevel = 3;
        private int interactionCaptureMode;
        private CollectorChannelFactory collectorChannelFactory = new CollectorChannelFactory(this){

            @Override
            public final CollectorChannel newCollectorChannel() {
                return new m();
            }
        };
        private Set<String> excludedUrlPatterns;
        private boolean compileTimeInstrumentationCheck = true;
        private CrashReportCallback crashCallback = null;

        private Builder() {
        }

        public Builder withAppKey(String string) {
            this.appKey = string;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withCollectorURL(String string) {
            this.collectorURL = string;
            return this;
        }

        public Builder withDynamicInfoPointURL(String string) {
            this.dynInfoPointURL = string;
            return this;
        }

        public Builder withApplicationName(String string) {
            this.applicationName = string;
            return this;
        }

        public Builder withExcludedUrlPatterns(Set<String> set) {
            this.excludedUrlPatterns = set;
            return this;
        }

        public Builder withLoggingEnabled(boolean bl) {
            return this.withLoggingLevel(bl ? 2 : 3);
        }

        public Builder withLoggingLevel(int n2) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Logging Level: " + n2);
                }
            }
            this.loggingLevel = n2;
            return this;
        }

        public Builder withCompileTimeInstrumentationCheck(boolean bl) {
            this.compileTimeInstrumentationCheck = bl;
            return this;
        }

        public Builder withInteractionCaptureMode(int n2) {
            this.interactionCaptureMode = n2;
            return this;
        }

        public Builder withCollectorChannelFactory(CollectorChannelFactory collectorChannelFactory) {
            this.collectorChannelFactory = collectorChannelFactory;
            return this;
        }

        public Builder withCrashCallback(CrashReportCallback crashReportCallback) {
            this.crashCallback = crashReportCallback;
            return this;
        }

        public AgentConfiguration build() {
            if (this.collectorChannelFactory == null) {
                throw new NullPointerException("collectorChannelFactory must not be null");
            }
            return new AgentConfiguration(this.appKey, this.context, this.collectorURL, this.dynInfoPointURL, this.loggingLevel, this.collectorChannelFactory, this.applicationName, this.excludedUrlPatterns, this.compileTimeInstrumentationCheck, this.crashCallback, this.interactionCaptureMode);
        }

        /* synthetic */ Builder(a a2) {
            this();
        }
    }
}

