/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.features;

import com.appdynamics.android.bci.bytecodeinjectors.ReplaceMethodCallInjector;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.ArrayList;
import java.util.List;

public class HttpClientTracking
implements ClassVisitorFactory {
    private static final String HTTP_CLIENT = "org/apache/http/client/HttpClient";
    private static final String ABSTRACT_HTTP_CLIENT = "org/apache/http/impl/client/AbstractHttpClient";
    private static final String ANDROID_HTTP_CLIENT = "android/net/http/AndroidHttpClient";
    private static final String DEFAULT_HTTP_CLIENT = "org/apache/http/impl/client/DefaultHttpClient";
    private static final List<String> HTTP_CLIENTS = new ArrayList<String>();
    private static Method EXECUTE_REQUEST;
    private static Method EXECUTE_REQUEST_CONTEXT;
    private static Method EXECUTE_HOST_REQUEST;
    private static Method EXECUTE_HOST_REQUEST_CONTEXT;
    private static Method EXECUTE_REQUEST_HANDLER;
    private static Method EXECUTE_REQUEST_CONTEXT_HANDLER;
    private static Method EXECUTE_HOST_REQUEST_HANDLER;
    private static Method EXECUTE_HOST_REQUEST_CONTEXT_HANDLER;
    private static Method EXECUTE_REQUEST_CALLBACK;
    private static Method EXECUTE_REQUEST_CONTEXT_CALLBACK;
    private static Method EXECUTE_HOST_REQUEST_CALLBACK;
    private static Method EXECUTE_HOST_REQUEST_CONTEXT_CALLBACK;
    private static Method EXECUTE_REQUEST_HANDLER_CALLBACK;
    private static Method EXECUTE_REQUEST_CONTEXT_HANDLER_CALLBACK;
    private static Method EXECUTE_HOST_REQUEST_HANDLER_CALLBACK;
    private static Method EXECUTE_HOST_REQUEST_CONTEXT_HANDLER_CALLBACK;
    private final ClassUtil classUtil;

    public HttpClientTracking(ClassUtil classUtil) {
        this.classUtil = classUtil;
    }

    @Override
    public ClassVisitor createClassVisitor(ClassVisitor delegate) {
        for (String targetClass : HTTP_CLIENTS) {
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_REQUEST, EXECUTE_REQUEST_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_REQUEST_CONTEXT, EXECUTE_REQUEST_CONTEXT_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_HOST_REQUEST, EXECUTE_HOST_REQUEST_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_HOST_REQUEST_CONTEXT, EXECUTE_HOST_REQUEST_CONTEXT_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_REQUEST_HANDLER, EXECUTE_REQUEST_HANDLER_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_REQUEST_CONTEXT_HANDLER, EXECUTE_REQUEST_CONTEXT_HANDLER_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_HOST_REQUEST_HANDLER, EXECUTE_HOST_REQUEST_HANDLER_CALLBACK);
            delegate = this.createReplacer(delegate, targetClass, EXECUTE_HOST_REQUEST_CONTEXT_HANDLER, EXECUTE_HOST_REQUEST_CONTEXT_HANDLER_CALLBACK);
        }
        return delegate;
    }

    private ClassVisitor createReplacer(ClassVisitor delegate, String targetClass, Method targetMethod, Method replaceMethod) {
        return new ReplaceMethodCallInjector(delegate, new MethodCallMatcher(targetClass, targetMethod, false, this.classUtil), replaceMethod, "APACHE_HTTP");
    }

    static {
        HTTP_CLIENTS.add(HTTP_CLIENT);
        HTTP_CLIENTS.add(ABSTRACT_HTTP_CLIENT);
        HTTP_CLIENTS.add(ANDROID_HTTP_CLIENT);
        HTTP_CLIENTS.add(DEFAULT_HTTP_CLIENT);
        EXECUTE_REQUEST = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.methods.HttpUriRequest)");
        EXECUTE_REQUEST_CONTEXT = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.methods.HttpUriRequest, org.apache.http.protocol.HttpContext)");
        EXECUTE_HOST_REQUEST = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.HttpHost, org.apache.http.HttpRequest)");
        EXECUTE_HOST_REQUEST_CONTEXT = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.protocol.HttpContext)");
        EXECUTE_REQUEST_HANDLER = Method.getMethod("java.lang.Object execute(org.apache.http.client.methods.HttpUriRequest, org.apache.http.client.ResponseHandler)");
        EXECUTE_REQUEST_CONTEXT_HANDLER = Method.getMethod("java.lang.Object execute(org.apache.http.client.methods.HttpUriRequest, org.apache.http.client.ResponseHandler, org.apache.http.protocol.HttpContext)");
        EXECUTE_HOST_REQUEST_HANDLER = Method.getMethod("java.lang.Object execute(org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.client.ResponseHandler)");
        EXECUTE_HOST_REQUEST_CONTEXT_HANDLER = Method.getMethod("java.lang.Object execute(org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.client.ResponseHandler, org.apache.http.protocol.HttpContext)");
        EXECUTE_REQUEST_CALLBACK = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.HttpClient, org.apache.http.client.methods.HttpUriRequest)");
        EXECUTE_REQUEST_CONTEXT_CALLBACK = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.HttpClient, org.apache.http.client.methods.HttpUriRequest, org.apache.http.protocol.HttpContext)");
        EXECUTE_HOST_REQUEST_CALLBACK = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.HttpClient, org.apache.http.HttpHost, org.apache.http.HttpRequest)");
        EXECUTE_HOST_REQUEST_CONTEXT_CALLBACK = Method.getMethod("org.apache.http.HttpResponse execute(org.apache.http.client.HttpClient, org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.protocol.HttpContext)");
        EXECUTE_REQUEST_HANDLER_CALLBACK = Method.getMethod("java.lang.Object execute(org.apache.http.client.HttpClient, org.apache.http.client.methods.HttpUriRequest, org.apache.http.client.ResponseHandler)");
        EXECUTE_REQUEST_CONTEXT_HANDLER_CALLBACK = Method.getMethod("java.lang.Object execute(org.apache.http.client.HttpClient, org.apache.http.client.methods.HttpUriRequest, org.apache.http.client.ResponseHandler, org.apache.http.protocol.HttpContext)");
        EXECUTE_HOST_REQUEST_HANDLER_CALLBACK = Method.getMethod("java.lang.Object execute(org.apache.http.client.HttpClient, org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.client.ResponseHandler)");
        EXECUTE_HOST_REQUEST_CONTEXT_HANDLER_CALLBACK = Method.getMethod("java.lang.Object execute(org.apache.http.client.HttpClient, org.apache.http.HttpHost, org.apache.http.HttpRequest, org.apache.http.client.ResponseHandler, org.apache.http.protocol.HttpContext)");
    }
}

