/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors.config;

import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.repackaged.asm.commons.Method;

public class MethodCallMatcher {
    public final String targetClass;
    public final Method[] targetMethods;
    public final boolean matchSubclasses;
    public final ClassUtil classUtil;

    public MethodCallMatcher(String targetClass, Method targetMethod, boolean matchSubclasses, ClassUtil classUtil) {
        this(targetClass, new Method[]{targetMethod}, matchSubclasses, classUtil);
    }

    public MethodCallMatcher(String targetClass, Method[] targetMethods, boolean matchSubclasses, ClassUtil classUtil) {
        this.targetClass = targetClass;
        this.matchSubclasses = matchSubclasses;
        this.targetMethods = targetMethods;
        this.classUtil = classUtil;
    }

    public boolean isMethodCallMatched(int opcode, String owner, String methodName, String methodDesc) {
        if (opcode != 182 && opcode != 185) {
            return false;
        }
        for (Method targetMethod : this.targetMethods) {
            boolean hasCommonSuperClass;
            if (!targetMethod.getName().equals(methodName) || !targetMethod.getDescriptor().equals(methodDesc)) continue;
            if (this.matchSubclasses) {
                try {
                    hasCommonSuperClass = this.targetClass.equals(this.classUtil.getCommonSuperClass(this.targetClass, owner));
                }
                catch (RuntimeException e) {
                    BCILogger.getBciLogger().warn("Unable to find common super class. owner: %s, matcher: %s. Exception: ", owner, this.targetClass, e);
                    hasCommonSuperClass = false;
                }
            } else {
                hasCommonSuperClass = owner.equals(this.targetClass);
            }
            if (!hasCommonSuperClass) continue;
            return true;
        }
        return false;
    }
}

