/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ActivityLifecycleAdapter
extends BaseClassVisitor {
    private static final String ACTIVITY_CLASS_NAME = "android/app/Activity";
    private static final String INSTRUMENTATION_CLASS_NAME = "com/appdynamics/eumagent/runtime/InstrumentationCallbacks";
    private final BCIRunSummary bciSummary = BCIRunSummary.getDefaultInstance();
    private boolean isActivityClass;
    private EnumSet<Lifecycle> methodPresent;
    private final ClassUtil classUtil;
    private String superName;
    private static final String VOID_RETURN_NO_PARAM = "()V";
    private static final Map<String, Lifecycle> LIFECYCLE_MAP = new HashMap<String, Lifecycle>(Lifecycle.values().length);

    public ActivityLifecycleAdapter(ClassVisitor classVisitor, ClassUtil classUtil) {
        super(classVisitor);
        this.classUtil = classUtil;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isActivityClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(ACTIVITY_CLASS_NAME, name).equals(ACTIVITY_CLASS_NAME);
        if (this.isActivityClass) {
            this.logInjectedWithLineNumber("Found a descendant of android.app.Activity class: %s", this.className);
            this.methodPresent = EnumSet.noneOf(Lifecycle.class);
            this.superName = superName;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Lifecycle lifecycle;
        MethodVisitor nextVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (nextVisitor != null && this.isActivityClass && (lifecycle = LIFECYCLE_MAP.get(name)) != null && lifecycle.methodDesc.equals(desc)) {
            this.bciSummary.featureInjected("ANR", this.className);
            this.methodPresent.add(lifecycle);
            return new ActivityMethodVisitor(access, name, nextVisitor, desc, lifecycle);
        }
        return new BaseClassVisitor.BaseMethodVisitor(this, nextVisitor, access, name, desc);
    }

    @Override
    public void visitEnd() {
        EnumSet<Lifecycle> methodsNotImplemented;
        if (this.isActivityClass && !(methodsNotImplemented = EnumSet.complementOf(this.methodPresent)).isEmpty()) {
            this.bciSummary.featureInjected("ANR", this.className);
            for (Lifecycle toAdd : methodsNotImplemented) {
                MethodVisitor mv = super.visitMethod(toAdd.access, toAdd.methodName, toAdd.methodDesc, null, null);
                mv.visitCode();
                this.injectCallback(mv, toAdd);
                mv.visitVarInsn(25, 0);
                Type[] originalArguments = Type.getArgumentTypes(toAdd.methodDesc);
                for (int i = 0; i < originalArguments.length; ++i) {
                    mv.visitVarInsn(25, i + 1);
                }
                mv.visitMethodInsn(183, this.superName, toAdd.methodName, toAdd.methodDesc, false);
                Type returnType = Type.getReturnType(toAdd.methodDesc);
                int returnOpCode = this.opcodeForReturnOfType(returnType);
                this.logger.info("returnOpCode: " + returnOpCode, new Object[0]);
                mv.visitInsn(returnOpCode);
                mv.visitEnd();
                this.logInjectedWithLineNumber("Finished injecting method: %s into class %s", toAdd.methodName, this.className);
            }
        }
        super.visitEnd();
    }

    private int opcodeForReturnOfType(Type t) {
        if (t.equals(Type.VOID_TYPE)) {
            return 177;
        }
        return t.getOpcode(172);
    }

    private void injectCallback(MethodVisitor mv, Lifecycle lifecycle) {
        Type[] originalArguments = Type.getArgumentTypes(lifecycle.methodDesc);
        Type[] arguments = new Type[originalArguments.length + 1];
        int argi = 0;
        arguments[argi++] = Type.getObjectType(ACTIVITY_CLASS_NAME);
        for (Type t : originalArguments) {
            arguments[argi++] = t;
        }
        String methodDescription = Type.getMethodDescriptor(Type.VOID_TYPE, arguments);
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < originalArguments.length; ++i) {
            mv.visitVarInsn(25, i + 1);
        }
        mv.visitMethodInsn(184, INSTRUMENTATION_CLASS_NAME, lifecycle.instrumentationMethodName, methodDescription, false);
        this.logInjectedWithOnlySourceInfo("Finished injecting call to %s.%s at %s.%s", INSTRUMENTATION_CLASS_NAME, lifecycle.instrumentationMethodName, this.className, lifecycle.methodName);
    }

    static {
        for (Lifecycle lifecycle : Lifecycle.values()) {
            LIFECYCLE_MAP.put(lifecycle.methodName, lifecycle);
        }
    }

    public static enum Lifecycle {
        ON_CREATE(4, "onCreate", "(Landroid/os/Bundle;)V"),
        ON_START(4, "onStart", "()V"),
        ON_RESTART(4, "onRestart", "()V"),
        ON_RESUME(4, "onResume", "()V"),
        ON_PAUSE(4, "onPause", "()V"),
        ON_STOP(4, "onStop", "()V"),
        ON_DESTROY(4, "onDestroy", "()V"),
        ON_CONFIGURATION_CHANGED(1, "onConfigurationChanged", "(Landroid/content/res/Configuration;)V"),
        DISPATCH_TOUCH_EVENT(1, "dispatchTouchEvent", "(Landroid/view/MotionEvent;)Z");

        public final int access;
        public final String methodName;
        public final String methodDesc;
        public final String instrumentationMethodName;

        private Lifecycle(int access, String methodName, String methodDesc) {
            this.access = access;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.instrumentationMethodName = methodName + "Called";
        }
    }

    public static class Factory
    implements IAdapterFactory {
        private final ClassUtil classUtil;

        public Factory(ClassUtil classUtil) {
            this.classUtil = classUtil;
        }

        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            return new ActivityLifecycleAdapter(delegate, this.classUtil);
        }
    }

    private class ActivityMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        final Lifecycle lifecycle;

        public ActivityMethodVisitor(int access, String name, MethodVisitor methodVisitor, String desc, Lifecycle lifecycle) {
            super(ActivityLifecycleAdapter.this, methodVisitor, access, name, desc);
            this.lifecycle = lifecycle;
        }

        @Override
        public void visitCode() {
            this.mv.visitCode();
            ActivityLifecycleAdapter.this.injectCallback(this.mv, this.lifecycle);
        }
    }
}

