/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.StopInstrumentationException;
import com.appdynamics.android.bci.ActivityLifecycleAdapter;
import com.appdynamics.android.bci.BCILifecycleListenerWrapper;
import com.appdynamics.android.bci.BuildFinalizer;
import com.appdynamics.android.bci.BuildIdInjector;
import com.appdynamics.android.bci.BuildInfoInjector;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.CompositeAdapterFactory;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.bci.InstrumentationConfig;
import com.appdynamics.android.bci.LoadingClassWriter;
import com.appdynamics.android.bci.ManualInfoPointAdapter;
import com.appdynamics.android.bci.NetworkConnectionHarvestMarker;
import com.appdynamics.android.bci.OpaqueCallbackInjector;
import com.appdynamics.android.bci.OpaqueClassVisitor;
import com.appdynamics.android.bci.OpaqueInterceptor;
import com.appdynamics.android.bci.PreprocessAdapter;
import com.appdynamics.android.bci.QName;
import com.appdynamics.android.bci.ReplaceMethodCallAdapter;
import com.appdynamics.android.bci.SetOnClickListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnFocusChangeListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnHierarchyChangeListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnItemClickListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.TimeMethodAdapter;
import com.appdynamics.android.bci.VersionLoader;
import com.appdynamics.android.bci.WebChromeClientAdapterFactory;
import com.appdynamics.android.bci.WebViewClientAdapterFactory;
import com.appdynamics.android.bci.signature.AMethodSignatureChangePolicy;
import com.appdynamics.android.bci.signature.MethodSignatureBuilder;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassReader;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.ClassWriter;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.util.CheckClassAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public class ClassStreamRewriter
extends BCILifecycleListenerWrapper {
    private static final String UNABLE_TO_DETERMINE_CLASS_NAME = "Unable to determine class name";
    private static final BCILogger logger = BCILogger.getLoggerFor(ClassStreamRewriter.class);
    private ClassWriter cw;
    private final ClassUtil classUtil;
    private boolean failed = false;
    private boolean isRuntimeClass = false;
    private boolean isExcludedClass = false;
    private final CompositeAdapterFactory adapterFactory;
    private final InstrumentationConfig config;
    private final BuildInfoInjector buildIdGenerator;
    private final OpaqueCallbackInjector opaqueCallbackInjector;
    private final String injectorVersion = new VersionLoader().loadVersion();
    private byte[] inputCopy;
    private final String buildId;
    private static final String URL_CONNECTION = "java/net/URLConnection";
    private static final String HTTP_URL_CONNECTION = "java/net/HttpURLConnection";
    private static final String HTTPS_URL_CONNECTION = "javax/net/ssl/HttpsURLConnection";
    private static final String IO_EXCEPTION = "java/io/IOException";
    private static final List<MethodInterceptionInfo> METHODS_TO_INTERCEPT = new ArrayList<MethodInterceptionInfo>();
    private static final String URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE = "()Ljava/io/InputStream;";
    private static final String URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE = "(Ljava/net/URLConnection;)Ljava/io/InputStream;";
    private static final String HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE = "(Ljava/net/HttpURLConnection;)Ljava/io/InputStream;";
    private static final String EUMAGENT_INSTRUMENTATION = "com/appdynamics/eumagent/runtime/InstrumentationCallbacks";
    private static final String HTTP_CLIENT = "org/apache/http/client/HttpClient";
    private static final String ABSTRACT_HTTP_CLIENT = "org/apache/http/impl/client/AbstractHttpClient";
    private static final String ANDROID_HTTP_CLIENT = "android/net/http/AndroidHttpClient";
    private static final String DEFAULT_HTTP_CLIENT = "org/apache/http/impl/client/DefaultHttpClient";
    private static final String HTTP_URI_REQUEST = "org/apache/http/client/methods/HttpUriRequest";
    private static final String HTTP_REQUEST = "org/apache/http/HttpRequest";
    private static final String HTTP_CONTEXT = "org/apache/http/protocol/HttpContext";
    private static final String HTTP_RESPONSE_HANDLER = "org/apache/http/client/ResponseHandler";
    private static final String HTTP_HOST = "org/apache/http/HttpHost";
    private static final String HTTP_RESPONSE = "org/apache/http/HttpResponse";
    private static final String OBJECT = "java/lang/Object";
    private static final List<String> HTTP_CLIENTS;
    private static final List<MethodSignatureBuilder> HTTP_CLIENT_SIGNATURES;
    private static final AMethodSignatureChangePolicy HTTP_CLIENT_SIGNATURE_POLICY;
    private static final List<MethodSubstitutionInfo> METHODS_TO_REPLACE;

    public ClassStreamRewriter(ClassUtil classUtil, InstrumentationConfig config) {
        if (config == null) {
            config = new InstrumentationConfig();
        }
        this.config = config;
        logger.debug("Initializing ClassStreamRewriter.", new Object[0]);
        logger.info("Injector version = " + this.injectorVersion, new Object[0]);
        logger.debug("Using config = %s", config);
        this.buildId = UUID.randomUUID().toString();
        this.classUtil = classUtil;
        this.buildIdGenerator = new BuildInfoInjector(this.buildId);
        this.opaqueCallbackInjector = new OpaqueCallbackInjector();
        this.adapterFactory = new CompositeAdapterFactory();
        this.adapterFactory.addAdapter(new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new PreprocessAdapter(delegate);
            }
        });
        for (MethodInterceptionInfo methodInterceptionInfo : METHODS_TO_INTERCEPT) {
            this.adapterFactory.addAdapter(this.timeMethodAdapterFactory(methodInterceptionInfo.method, methodInterceptionInfo.exceptionToCatch));
        }
        for (MethodSubstitutionInfo methodSubstitutionInfo : METHODS_TO_REPLACE) {
            this.adapterFactory.addAdapter(this.replaceMethodCallAdapterFactory(methodSubstitutionInfo.methodToReplace, methodSubstitutionInfo.originalSignature, methodSubstitutionInfo.methodToCall, methodSubstitutionInfo.newSignature, methodSubstitutionInfo.featureInjected));
        }
        for (String string : config.getInterceptorFiles()) {
            for (OpaqueClassVisitor.ClassInfo i : OpaqueInterceptor.getInterceptors(string)) {
                this.adapterFactory.addAdapter(this.opaqueMethodVistor(i));
            }
        }
        this.adapterFactory.addAdapter(new ActivityLifecycleAdapter.Factory(classUtil));
        this.adapterFactory.addAdapter(new NetworkConnectionHarvestMarker.Factory());
        this.adapterFactory.addAdapter(new SetOnHierarchyChangeListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnClickListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnFocusChangeListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnItemClickListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new ManualInfoPointAdapter.Factory());
        if (config.isWebViewCallbackCrashReportingEnabled()) {
            this.adapterFactory.addAdapter(new WebViewClientAdapterFactory(classUtil));
            this.adapterFactory.addAdapter(new WebChromeClientAdapterFactory(classUtil));
        }
        this.adapterFactory.addAdapter(new BuildIdInjector.Factory(classUtil, this.buildId));
        this.addLifecycleListener(new BuildFinalizer(this.buildIdGenerator, this.opaqueCallbackInjector), BCIRunSummary.getDefaultInstance());
    }

    public ClassStreamRewriter(ClassUtil classUtil) {
        this(classUtil, null);
    }

    public void readInput(InputStream in) throws IOException {
        this.failed = false;
        this.inputCopy = BuildUtils.copyStream(in).toByteArray();
        try {
            ClassReader cr = new ClassReader(this.inputCopy);
            String className = cr.getClassName();
            boolean bl = this.isRuntimeClass = className.startsWith("com/appdynamics/eumagent/runtime") || className.startsWith("com/appdynamics/repacked");
            if (this.isRuntimeClass) {
                logger.info("Skipping %s because its part of runtime agent", cr.getClassName());
                return;
            }
            this.isExcludedClass = false;
            for (Pattern pat : this.config.getExclusionPatterns()) {
                if (!pat.matcher(className).matches()) continue;
                this.isExcludedClass = true;
                logger.info("Skipping %s because it is in the exclusion list", className);
                return;
            }
            logger.debug("Processing: %s", cr.getClassName());
            BCIRunSummary.getDefaultInstance().incrementClassCount();
            this.cw = new LoadingClassWriter(this.classUtil);
            ClassVisitor cv = this.adapterFactory.createAdapter(this.cw);
            CheckClassAdapter cca = new CheckClassAdapter(cv);
            cr.accept(cca, 8);
        }
        catch (StopInstrumentationException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            String className = this.getClassName();
            if (!UNABLE_TO_DETERMINE_CLASS_NAME.equals(className)) {
                BCIRunSummary.getDefaultInstance().failedToInstrumentClass(className);
            }
            this.failed = true;
            logger.error(throwable, "Unable to process [%s] for instrumentation.", className);
        }
    }

    private String getClassName() {
        try {
            return new ClassReader(this.inputCopy).getClassName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return UNABLE_TO_DETERMINE_CLASS_NAME;
        }
    }

    public void writeOutput(OutputStream out) throws IOException {
        if (this.failed || this.isRuntimeClass || this.isExcludedClass) {
            try {
                out.write(this.inputCopy);
            }
            finally {
                this.inputCopy = null;
            }
        } else {
            out.write(this.cw.toByteArray());
        }
        this.cw = null;
    }

    public String getBuildId() {
        return this.buildId;
    }

    private static MethodSignatureBuilder getSignature(String returnType, String ... args) {
        ArrayList<Type> argTypes = new ArrayList<Type>();
        for (String arg : args) {
            argTypes.add(Type.getObjectType(arg));
        }
        return new MethodSignatureBuilder(argTypes, Type.getObjectType(returnType));
    }

    private static void addAllMethods(String src, String dest) {
        LinkedList<MethodInterceptionInfo> toAdd = new LinkedList<MethodInterceptionInfo>();
        for (MethodInterceptionInfo info : METHODS_TO_INTERCEPT) {
            if (!info.method.owner.equals(src)) continue;
            toAdd.add(new MethodInterceptionInfo(dest, info.method.name, info.exceptionToCatch));
        }
        METHODS_TO_INTERCEPT.addAll(toAdd);
    }

    private IAdapterFactory timeMethodAdapterFactory(final QName method, final String exceptionToCatch) {
        return new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new TimeMethodAdapter(method, exceptionToCatch, delegate);
            }
        };
    }

    private IAdapterFactory replaceMethodCallAdapterFactory(final QName method, final String origSig, final QName methodToCall, final String sig, final String feature) {
        return new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new ReplaceMethodCallAdapter(method, origSig, methodToCall, sig, delegate, feature);
            }
        };
    }

    private IAdapterFactory opaqueMethodVistor(final OpaqueClassVisitor.ClassInfo ci) {
        return new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new OpaqueClassVisitor(ci, delegate, ClassStreamRewriter.this.opaqueCallbackInjector);
            }
        };
    }

    static {
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "connect", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContent", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentEncoding"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentLength"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentType"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getDate"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getExpiration"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getLastModified"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldDate"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFields"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldKey"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderField"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldInt"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getOutputStream", IO_EXCEPTION));
        ClassStreamRewriter.addAllMethods(URL_CONNECTION, HTTP_URL_CONNECTION);
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(HTTP_URL_CONNECTION, "getResponseMessage", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(HTTP_URL_CONNECTION, "getResponseCode", IO_EXCEPTION));
        ClassStreamRewriter.addAllMethods(HTTP_URL_CONNECTION, HTTPS_URL_CONNECTION);
        HTTP_CLIENTS = new ArrayList<String>();
        HTTP_CLIENTS.add(HTTP_CLIENT);
        HTTP_CLIENTS.add(ABSTRACT_HTTP_CLIENT);
        HTTP_CLIENTS.add(ANDROID_HTTP_CLIENT);
        HTTP_CLIENTS.add(DEFAULT_HTTP_CLIENT);
        HTTP_CLIENT_SIGNATURES = new ArrayList<MethodSignatureBuilder>();
        HTTP_CLIENT_SIGNATURE_POLICY = AMethodSignatureChangePolicy.prependArgumentOfType(Type.getObjectType(HTTP_CLIENT));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(HTTP_RESPONSE, HTTP_URI_REQUEST));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(HTTP_RESPONSE, HTTP_URI_REQUEST, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(HTTP_RESPONSE, HTTP_HOST, HTTP_REQUEST));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(HTTP_RESPONSE, HTTP_HOST, HTTP_REQUEST, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(OBJECT, HTTP_URI_REQUEST, HTTP_RESPONSE_HANDLER));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(OBJECT, HTTP_URI_REQUEST, HTTP_RESPONSE_HANDLER, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(OBJECT, HTTP_HOST, HTTP_REQUEST, HTTP_RESPONSE_HANDLER));
        HTTP_CLIENT_SIGNATURES.add(ClassStreamRewriter.getSignature(OBJECT, HTTP_HOST, HTTP_REQUEST, HTTP_RESPONSE_HANDLER, HTTP_CONTEXT));
        METHODS_TO_REPLACE = new ArrayList<MethodSubstitutionInfo>();
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTP_URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTPS_URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTP_URL_CONNECTION, "getErrorStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getErrorStream"), HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTPS_URL_CONNECTION, "getErrorStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getErrorStream"), HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE, "URL_HTTP"));
        for (String client : HTTP_CLIENTS) {
            for (MethodSignatureBuilder origSig : HTTP_CLIENT_SIGNATURES) {
                METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(client, "execute"), origSig.toString(), new QName(EUMAGENT_INSTRUMENTATION, "execute"), HTTP_CLIENT_SIGNATURE_POLICY.apply(origSig).toString(), "APACHE_HTTP"));
            }
        }
    }

    private static class MethodSubstitutionInfo {
        final QName methodToReplace;
        final String originalSignature;
        final QName methodToCall;
        final String newSignature;
        final String featureInjected;

        MethodSubstitutionInfo(QName methodToReplace, String originalSignature, QName methodToCall, String newSignature, String featureInjected) {
            this.methodToReplace = methodToReplace;
            this.originalSignature = originalSignature;
            this.methodToCall = methodToCall;
            this.newSignature = newSignature;
            this.featureInjected = featureInjected;
        }
    }

    private static class MethodInterceptionInfo {
        final QName method;
        final String exceptionToCatch;

        MethodInterceptionInfo(String clazz, String method, String exceptionToCatch) {
            this.method = new QName(clazz, method);
            this.exceptionToCatch = exceptionToCatch;
        }

        MethodInterceptionInfo(String clazz, String method) {
            this(clazz, method, null);
        }
    }
}

