/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.adapters;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.HashSet;

public class TryCatchReportCrashClassAdapter
extends BaseClassVisitor {
    private static final String RUNTIME_EXCEPTION = "java/lang/RuntimeException";
    private final ClassUtil classUtil;
    private final String className;
    private final HashSet<String> methods;
    private boolean isTargetClass = false;

    public TryCatchReportCrashClassAdapter(ClassVisitor cv, ClassUtil classUtil, String className, String[] humanReadableMethods) {
        super(cv);
        this.classUtil = classUtil;
        this.className = className;
        this.methods = new HashSet();
        for (String methodString : humanReadableMethods) {
            Method method = Method.getMethod(methodString);
            this.methods.add(method.getName() + method.getDescriptor());
        }
    }

    private boolean shouldInstrumentMethod(String methodName, String methodDesc) {
        return this.methods.contains(methodName + methodDesc);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isTargetClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(this.className, name).equals(this.className);
        if (this.isTargetClass) {
            this.logger.debug("Found a descendant of %s class: %s", this.className, this.className);
            BCIRunSummary.getDefaultInstance().featureInjected("CRASH_REPORTING", this.className);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        if (this.isTargetClass && this.shouldInstrumentMethod(methodName, methodDesc)) {
            this.logger.debug("Instrumenting method: %s%s", methodName, methodDesc);
            return new TryCatchReportMethodVisitor(baseMV, access, methodName, methodDesc);
        }
        return baseMV;
    }

    private class TryCatchReportMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private final Label tryStartLabel;
        private final Label tryEndLabel;

        TryCatchReportMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.tryStartLabel = new Label();
            this.tryEndLabel = new Label();
        }

        @Override
        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitLabel(this.tryStartLabel);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitLabel(this.tryEndLabel);
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "reportCrash", "(Ljava/lang/Throwable;)V", false);
            this.mv.visitInsn(191);
            this.mv.visitMaxs(maxStack, maxLocals);
        }

        @Override
        public void visitEnd() {
            this.mv.visitTryCatchBlock(this.tryStartLabel, this.tryEndLabel, this.tryEndLabel, TryCatchReportCrashClassAdapter.RUNTIME_EXCEPTION);
            super.visitEnd();
        }
    }
}

