/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.ClassStreamRewriter;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.InstrumentationConfig;
import com.appdynamics.android.bci.io.ClassFileRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.logging.BCILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Injector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: java -jar injector.jar <path> <optional libraries>");
        } else {
            File logFileDir = new File(System.getProperty("java.io.tmpdir"), "Appd-androidbci_" + System.currentTimeMillis());
            logFileDir.mkdirs();
            BCILogger.setBciLogger(new BCILogger.MultiLogger(logFileDir){

                @Override
                protected void _log(BCILogger.Level level, String msg, Object ... args) {
                    if (level == BCILogger.Level.INFO) {
                        System.out.println("[INFO] " + String.format(msg, args));
                    }
                }
            });
            InstrumentationConfig config = new InstrumentationConfig();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--enableWebViewCrashReporting")) {
                    config.setWebViewCallbackCrashReportingEnabled(true);
                    continue;
                }
                urls.add(new File(args[i]).toURI().toURL());
            }
            ClassUtil classUtil = ClassUtil.Factory.createClassUtil(urls.toArray(new URL[0]));
            ClassStreamRewriter streamRewriter = new ClassStreamRewriter(classUtil, config);
            streamRewriter.beginInstrumentation();
            File rootFolder = new File(args[0]);
            ClassFileRewriter cfr = new ClassFileRewriter(rootFolder, streamRewriter, new IStreamFactory(){

                @Override
                public InputStream getInputStream(File f) throws IOException {
                    return new FileInputStream(f);
                }

                @Override
                public OutputStream getOutputStream(File f) throws IOException {
                    return new FileOutputStream(f);
                }

                @Override
                public JarInputStream getJarInputStream(InputStream is) throws IOException {
                    throw new UnsupportedOperationException("This entry point does not support jar instrumentation; use the ant task instead");
                }

                @Override
                public JarOutputStream getJarOutputStream(OutputStream os, Manifest manifest) throws IOException {
                    throw new UnsupportedOperationException("This entry point does not support jar instrumentation; use the ant task instead");
                }
            });
            try {
                cfr.rewrite();
            }
            finally {
                System.out.println("Logs are available at: " + logFileDir);
                streamRewriter.endInstrumentation(rootFolder);
            }
        }
    }
}

