/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.util;

import java.util.HashSet;
import java.util.Set;

public class ClassInfo {
    public static final ClassInfo JAVA_LANG_OBJECT = new ClassInfo("java.lang.Object", null, new HashSet<ClassInfo>(), false);
    public final String name;
    public final ClassInfo superClassInfo;
    public final Set<ClassInfo> interfaces;
    public final boolean isInterface;
    public final Set<ClassInfo> allSuperClassInfos;

    public ClassInfo(String name, ClassInfo superClassInfo, Set<ClassInfo> interfaces, boolean isInterface) {
        this.name = name;
        this.superClassInfo = superClassInfo;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
        this.allSuperClassInfos = new HashSet<ClassInfo>(1);
        for (ClassInfo implementedInterface : this.interfaces) {
            this.allSuperClassInfos.add(implementedInterface);
            this.allSuperClassInfos.addAll(implementedInterface.allSuperClassInfos);
        }
        if (superClassInfo != null) {
            this.allSuperClassInfos.add(superClassInfo);
            this.allSuperClassInfos.addAll(superClassInfo.allSuperClassInfos);
        }
    }

    public ClassInfo getCommonSuperClass(ClassInfo that) {
        if (that == this || that.name.equals(this.name)) {
            return this;
        }
        if (this.allSuperClassInfos.contains(that)) {
            return that;
        }
        if (that.allSuperClassInfos.contains(this)) {
            return this;
        }
        if (this.isInterface || that.isInterface) {
            return JAVA_LANG_OBJECT;
        }
        ClassInfo parentClassInfo = this;
        while (!that.allSuperClassInfos.contains(parentClassInfo = parentClassInfo.superClassInfo)) {
        }
        return parentClassInfo;
    }

    public String toBytecodeStyle() {
        return this.name.replace(".", "/");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClassInfo)) {
            return false;
        }
        return this.name.equals(((ClassInfo)other).name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.superClassInfo != null) {
            sb.append(" extends ").append(this.superClassInfo.name);
        }
        if (this.interfaces.size() > 0) {
            sb.append(" implements ").append(this.interfacesAsString());
        }
        return sb.toString();
    }

    private String interfacesAsString() {
        StringBuilder bldr = new StringBuilder();
        for (ClassInfo klazz : this.interfaces) {
            bldr.append(klazz.name).append(", ");
        }
        bldr.setLength(bldr.length() - 2);
        return bldr.toString();
    }
}

