/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.app.infideap.stylishwidget.view.ATextView;

public class TransparentTextView
extends ATextView {
    private Bitmap mMaskBitmap;
    private Canvas mMaskCanvas;
    private Paint mPaint;
    private Drawable mBackground;
    private Bitmap mBackgroundBitmap;
    private Canvas mBackgroundCanvas;

    public TransparentTextView(Context context) {
        super(context);
        this.init();
    }

    public TransparentTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        super.setTextColor(-16777216);
        super.setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable bg) {
        if (this.mBackground == bg) {
            return;
        }
        this.mBackground = bg;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.mBackground != null && w != 0 && h != 0) {
            this.mBackground.setBounds(0, 0, w, h);
        }
        this.requestLayout();
        this.invalidate();
    }

    public void setBackgroundColor(int color2) {
        this.setBackgroundDrawable((Drawable)new ColorDrawable(color2));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w == 0 || h == 0) {
            this.freeBitmaps();
            return;
        }
        this.createBitmaps(w, h);
        if (this.mBackground != null) {
            this.mBackground.setBounds(0, 0, w, h);
        }
    }

    private void createBitmaps(int w, int h) {
        this.mBackgroundBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mBackgroundCanvas = new Canvas(this.mBackgroundBitmap);
        this.mMaskBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        this.mMaskCanvas = new Canvas(this.mMaskBitmap);
    }

    private void freeBitmaps() {
        this.mBackgroundBitmap = null;
        this.mBackgroundCanvas = null;
        this.mMaskBitmap = null;
        this.mMaskCanvas = null;
    }

    protected void onDraw(Canvas canvas) {
        if (this.isNothingToDraw()) {
            return;
        }
        this.drawMask();
        this.drawBackground();
        canvas.drawBitmap(this.mBackgroundBitmap, 0.0f, 0.0f, null);
    }

    private boolean isNothingToDraw() {
        return this.mBackground == null || this.getWidth() == 0 || this.getHeight() == 0;
    }

    @SuppressLint(value={"WrongCall"})
    private void drawMask() {
        TransparentTextView.clear(this.mMaskCanvas);
        super.onDraw(this.mMaskCanvas);
    }

    private void drawBackground() {
        TransparentTextView.clear(this.mBackgroundCanvas);
        this.mBackground.draw(this.mBackgroundCanvas);
        this.mBackgroundCanvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mPaint);
    }

    private static void clear(Canvas canvas) {
        canvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
    }
}

