/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import com.app.infideap.stylishwidget.view.MessageBox;

public class MessageBoxDialog {

    public static class Builder {
        private final Context context;
        private String message;
        private String text;
        private View.OnClickListener listener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setMessage(int message) {
            return this.setMessage(this.context.getResources().getString(message));
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setActionButton(int text, View.OnClickListener listener) {
            return this.setActionButton(this.context.getResources().getString(text), listener);
        }

        public Builder setActionButton(String text, View.OnClickListener listener) {
            this.text = text;
            this.listener = listener;
            return this;
        }

        public Builder setCloseButton(View.OnClickListener listener) {
            this.text = null;
            this.listener = listener;
            return this;
        }

        public BottomSheetDialog create() {
            MessageBox messageBox = new MessageBox(this.context);
            messageBox.setMessage(this.message);
            final BottomSheetDialog dialog = new BottomSheetDialog(this.context);
            dialog.setContentView((View)messageBox);
            if (this.listener == null) {
                this.listener = new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog.hide();
                    }
                };
            }
            if (this.text == null) {
                messageBox.setCloseButton(this.listener);
            } else {
                messageBox.setActionButton(this.text, this.listener);
            }
            return dialog;
        }
    }
}

