/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.view.ATextView;

public class MessageBox
extends FrameLayout {
    private static final String TAG = MessageBox.class.getSimpleName();
    private ATextView textView;
    private ImageView imageView;
    private Button button;

    public MessageBox(Context context) {
        super(context);
        this.init(null);
    }

    public MessageBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MessageBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public MessageBox(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public void init(AttributeSet attrs) {
        int textStyle;
        Drawable drawable;
        int drawablePadding;
        int bottomPadding;
        int topPadding;
        int rightPadding;
        int leftPadding;
        int padding;
        String message;
        int background;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.propertiesAttr);
        RelativeLayout layout2 = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_messagebox, null);
        try {
            background = a.getColor(R.styleable.propertiesAttr_sw_boxBackground, this.getResources().getColor(R.color.colorAccent));
        }
        catch (Exception e) {
            background = this.getResources().getColor(R.color.colorAccent);
        }
        this.setBackgroundColor(background);
        try {
            message = a.getString(R.styleable.propertiesAttr_sw_message);
        }
        catch (Exception e) {
            message = "";
        }
        try {
            padding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerPadding, layout2.getPaddingBottom());
        }
        catch (Exception e) {
            padding = layout2.getPaddingBottom();
        }
        try {
            leftPadding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerLeftPadding, padding);
        }
        catch (Exception e) {
            leftPadding = padding;
        }
        try {
            rightPadding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerRightPadding, padding);
        }
        catch (Exception e) {
            rightPadding = padding;
        }
        try {
            topPadding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerTopPadding, padding);
        }
        catch (Exception e) {
            topPadding = padding;
        }
        try {
            bottomPadding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerBottomPadding, padding);
        }
        catch (Exception e) {
            bottomPadding = padding;
        }
        try {
            drawablePadding = a.getDimensionPixelSize(R.styleable.propertiesAttr_sw_innerBottomPadding, padding);
        }
        catch (Exception e) {
            drawablePadding = padding;
        }
        try {
            drawable = a.getDrawable(R.styleable.propertiesAttr_sw_drawable);
        }
        catch (Exception e) {
            drawable = null;
        }
        a.recycle();
        layout2.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.textAttr);
        try {
            textStyle = a.getInt(R.styleable.textAttr_sw_textStyle, 0);
        }
        catch (Exception e) {
            textStyle = 0;
        }
        a.recycle();
        try {
            this.textView = (ATextView)layout2.findViewById(R.id.textView_message);
            this.textView.setText(message);
            this.textView.setTextStyle(textStyle);
            if (drawable != null) {
                this.textView.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);
                this.textView.setCompoundDrawablePadding(drawablePadding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.button = (Button)layout2.findViewById(R.id.button_action);
        this.imageView = (ImageView)layout2.findViewById(R.id.imageView_close);
        this.addView((View)layout2);
        this.setCloseButton(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
    }

    public void setMessage(int resId) {
        this.textView.setText(resId);
    }

    public void setMessage(String message) {
        this.textView.setText(message);
    }

    public void setCloseButton(final View.OnClickListener listener) {
        this.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick(view);
                MessageBox.this.setVisibility(8);
            }
        });
        this.imageView.setVisibility(0);
        this.button.setVisibility(8);
    }

    public void setActionButton(int text, View.OnClickListener listener) {
        this.setActionButton(this.getResources().getString(text), listener);
    }

    public void setActionButton(String text, View.OnClickListener listener) {
        this.button.setText((CharSequence)text);
        this.button.setOnClickListener(listener);
        this.imageView.setVisibility(8);
        this.button.setVisibility(0);
    }
}

