/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.support.annotation.Px;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.util.Utils;
import java.util.Locale;

public class AMeter
extends LinearLayout {
    private static final String TAG = AMeter.class.getSimpleName();
    private float value;
    private int meterColor;
    private View view;
    private float startAngle = 130.0f;
    private float sweepAngle = 280.0f;
    private float maxValue;
    private View needle1View;
    private View needle2View;
    private int textStyle;
    private float textSize;
    private int gapBottom = (int)Utils.convertDpToPixel(30.0f);
    private int minimumSize = (int)Utils.convertDpToPixel(250.0f);
    private boolean showText;
    Paint paint = new Paint();

    @RequiresApi(api=11)
    public AMeter(Context context) {
        super(context);
        this.setCustomAttr(context, null);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCustomAttr(context, attrs);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setCustomAttr(context, attrs);
    }

    @RequiresApi(api=11)
    private void setCustomAttr(Context context, AttributeSet attrs) {
        int textStyle;
        this.initView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.meterAttr);
        this.setMeterColor(a.getColor(R.styleable.meterAttr_sw_meterColor, -1));
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.textAttr);
        this.setTextSize(a.getDimension(R.styleable.textAttr_sw_textSize, this.getResources().getDimension(R.dimen.meterTextSize)));
        try {
            textStyle = a.getInt(R.styleable.textAttr_sw_textStyle, 1);
        }
        catch (Exception e) {
            textStyle = 1;
        }
        this.setTextStyle(textStyle);
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.constraintAttr);
        this.setShowText(a.getBoolean(R.styleable.constraintAttr_sw_showText, true));
        this.setValue(a.getFloat(R.styleable.constraintAttr_sw_value, 0.0f));
        this.setMaxValue(a.getFloat(R.styleable.constraintAttr_sw_maxValue, 1.0f));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getLayoutParams().width != this.getLayoutParams().height) {
            if (this.getLayoutParams().width != -1 && widthMeasureSpec < this.minimumSize) {
                this.getLayoutParams().width = this.minimumSize;
            }
            if (this.getLayoutParams().height != -1 && heightMeasureSpec < this.minimumSize) {
                this.getLayoutParams().height = this.minimumSize;
            }
            if (this.getHeight() < this.getWidth()) {
                this.getLayoutParams().height = this.getWidth();
            }
        }
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setGravity(17);
        this.setPadding(0, 0, 0, 0);
        this.view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_needle, (ViewGroup)this, false);
        this.addView(this.view);
        this.needle1View = this.view.findViewById(R.id.view_needle_1);
        this.needle2View = this.view.findViewById(R.id.view_needle_2);
    }

    @RequiresApi(api=11)
    protected void onDraw(Canvas canvas) {
        this.requestLayout();
        super.onDraw(canvas);
        this.paint.setColor(Utils.adjustAlpha(this.meterColor, 70));
        float width = (float)this.getWidth() - (float)super.getPaddingRight() - (float)super.getPaddingLeft();
        float height = (float)this.getHeight() - (float)super.getPaddingTop() - (float)super.getPaddingBottom();
        float radius = width / 2.0f;
        Path path = new Path();
        path.addCircle(width / 2.0f, height / 2.0f, radius, Path.Direction.CW);
        float strokeSize = Utils.convertDpToPixel(10.0f);
        this.paint.setStrokeWidth(strokeSize);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStyle(Paint.Style.STROKE);
        float center_x = width / 2.0f + (float)super.getPaddingLeft();
        float center_y = height / 2.0f + (float)super.getPaddingTop();
        RectF oval = new RectF();
        oval.set(center_x - (radius -= strokeSize / 2.0f), center_y - radius, center_x + radius, center_y + radius);
        canvas.drawArc(oval, this.startAngle, this.sweepAngle, false, this.paint);
        if (this.showText) {
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.paint.setColor(this.meterColor);
            this.paint.setTextSize(this.textSize);
            canvas.drawText(String.format(Locale.getDefault(), "%.0f", Float.valueOf(this.value * 100.0f / this.maxValue)), center_x, center_y + radius + (float)(this.gapBottom / 2), this.paint);
        }
    }

    @RequiresApi(api=11)
    private void rotateNeedle() {
        if (this.view != null) {
            float progress = this.value * this.sweepAngle / this.maxValue;
            progress = progress > this.sweepAngle ? this.sweepAngle : progress;
            this.view.setRotation(-90.0f + (this.startAngle - 90.0f) + progress);
        }
    }

    @RequiresApi(api=11)
    public void setValue(float value) {
        this.value = value;
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        this.invalidate();
        this.rotateNeedle();
    }

    public void setMeterColor(int meterColor) {
        this.meterColor = meterColor;
        this.needle1View.getBackground().setColorFilter(meterColor, PorterDuff.Mode.SRC_ATOP);
        this.needle2View.getBackground().setColorFilter(meterColor, PorterDuff.Mode.SRC_ATOP);
        this.invalidate();
    }

    @RequiresApi(api=11)
    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.invalidate();
        this.rotateNeedle();
    }

    public float getValue() {
        return this.value;
    }

    public int getMeterColor() {
        return this.meterColor;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setTextStyle(int textStyle) {
        this.textStyle = textStyle;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setPadding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        super.setPadding(left + this.gapBottom, top + this.gapBottom, right + this.gapBottom, bottom + this.gapBottom);
    }

    public int getPaddingBottom() {
        return super.getPaddingBottom() - this.gapBottom;
    }

    public int getPaddingTop() {
        return super.getPaddingTop() - this.gapBottom;
    }

    public int getPaddingLeft() {
        return super.getPaddingLeft() - this.gapBottom;
    }

    public int getPaddingRight() {
        return super.getPaddingRight() - this.gapBottom;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public boolean isShowText() {
        return this.showText;
    }
}

