/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.util.Utils;
import java.util.Locale;

public class AMeter
extends LinearLayout {
    private static final String TAG = AMeter.class.getSimpleName();
    private float progressValue;
    private int progressColor;
    private LinearLayout view;
    private float startAngle = 130.0f;
    private float sweepAngle = 280.0f;
    private float maxValue;
    private View needle1View;
    private View needle2View;
    private int textStyle;
    private float progressTextSize;
    Paint paint = new Paint();

    @RequiresApi(api=11)
    public AMeter(Context context) {
        super(context);
        this.setCustomTypeface(context, null);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCustomTypeface(context, attrs);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setCustomTypeface(context, attrs);
    }

    @RequiresApi(api=11)
    private void setCustomTypeface(Context context, AttributeSet attrs) {
        int textStyle;
        if (this.isInEditMode()) {
            return;
        }
        this.initView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.progressBar);
        this.setProgressValue(a.getFloat(R.styleable.progressBar_sw_progressValue, 0.0f));
        this.setMaxValue(a.getFloat(R.styleable.progressBar_sw_maxValue, 0.0f));
        this.setProgressColor(a.getColor(R.styleable.progressBar_sw_progressColor, -1));
        this.setProgressTextSize(a.getDimension(R.styleable.progressBar_sw_progressTextSize, this.getResources().getDimension(R.dimen.meterTextSize)));
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.messageBox);
        try {
            textStyle = a.getInt(R.styleable.messageBox_sw_textStyle, 1);
        }
        catch (Exception e) {
            textStyle = 1;
        }
        this.setTextStyle(textStyle);
        a.recycle();
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setGravity(17);
        this.view = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_needle, (ViewGroup)this, false);
        this.addView((View)this.view);
        this.needle1View = this.view.findViewById(R.id.view_needle_1);
        this.needle2View = this.view.findViewById(R.id.view_needle_2);
    }

    @RequiresApi(api=11)
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setColor(Utils.adjustAlpha(this.progressColor, 70));
        float width = (float)this.getWidth() - (float)this.getPaddingRight() - (float)this.getPaddingLeft();
        float height = (float)this.getHeight() - (float)this.getPaddingTop() - (float)this.getPaddingBottom();
        float radius = width > height ? height / 2.0f : width / 2.0f;
        Path path = new Path();
        path.addCircle(width / 2.0f, height / 2.0f, radius, Path.Direction.CW);
        float strokeSize = Utils.convertDpToPixel(10.0f);
        this.paint.setStrokeWidth(strokeSize);
        this.paint.setStyle(Paint.Style.FILL);
        RectF oval = new RectF();
        this.paint.setStyle(Paint.Style.STROKE);
        float center_x = width / 2.0f + (float)this.getPaddingLeft();
        float center_y = height / 2.0f + (float)this.getPaddingTop();
        oval.set(center_x - (radius -= strokeSize / 2.0f), center_y - radius, center_x + radius, center_y + radius);
        canvas.drawArc(oval, this.startAngle, this.sweepAngle, false, this.paint);
        this.rotateNeedle();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setColor(this.progressColor);
        this.paint.setTextSize(this.progressTextSize);
        canvas.drawText(String.format(Locale.getDefault(), "%.0f", Float.valueOf(this.progressValue * 100.0f / this.maxValue)), center_x, center_y + radius + this.progressTextSize / 2.0f, this.paint);
    }

    @RequiresApi(api=11)
    private void rotateNeedle() {
        if (this.view != null) {
            this.view.setRotation(-90.0f + (this.startAngle - 90.0f) + this.progressValue * this.sweepAngle / this.maxValue);
        }
    }

    @RequiresApi(api=11)
    public void setProgressValue(float progressValue) {
        this.progressValue = progressValue;
        if (progressValue > this.maxValue) {
            this.maxValue = progressValue;
        }
        this.invalidate();
        this.rotateNeedle();
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
        this.needle1View.getBackground().setColorFilter(progressColor, PorterDuff.Mode.SRC_ATOP);
        this.needle2View.getBackground().setColorFilter(progressColor, PorterDuff.Mode.SRC_ATOP);
        this.invalidate();
    }

    @RequiresApi(api=11)
    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.invalidate();
        this.rotateNeedle();
    }

    public float getProgressValue() {
        return this.progressValue;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setTextStyle(int textStyle) {
        this.textStyle = textStyle;
        this.invalidate();
    }

    public void setProgressTextSize(float progressTextSize) {
        this.progressTextSize = progressTextSize;
        this.invalidate();
    }
}

