package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.util.Utils;

import java.util.Locale;


/**
 * Created by Zariman on 13/4/2016.
 */
public class AMeter extends LinearLayout {
    private static final String TAG = AMeter.class.getSimpleName();
    private float progressValue;
    private int progressColor;
    private LinearLayout view;
    private float startAngle = 130;
    private float sweepAngle = 280;
    private float maxValue;
    private View needle1View;
    private View needle2View;
    private int textStyle;
    private float progressTextSize;

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    public AMeter(Context context) {
        super(context);
        setCustomTypeface(context, null);

    }

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    public AMeter(Context context, AttributeSet attrs) {
        super(context, attrs);
        setCustomTypeface(context, attrs);

    }

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    public AMeter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setCustomTypeface(context, attrs);

    }


    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    private void setCustomTypeface(Context context, AttributeSet attrs) {
        if (isInEditMode())
            return;

        initView();

        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.progressBar);
        setProgressValue(a.getFloat(R.styleable.progressBar_sw_progressValue, 0f));
        setMaxValue(a.getFloat(R.styleable.progressBar_sw_maxValue, 0f));
        setProgressColor(a.getColor(R.styleable.progressBar_sw_progressColor, Color.WHITE));
        setProgressTextSize(a.getDimension(R.styleable.progressBar_sw_progressTextSize,
                getResources().getDimension(R.dimen.meterTextSize)));
        a.recycle();

        a = getContext().obtainStyledAttributes(attrs, R.styleable.messageBox);

        int textStyle;
        try {
            textStyle = a.getInt(R.styleable.messageBox_sw_textStyle, Typeface.BOLD);
        } catch (Exception e) {
            textStyle = Typeface.BOLD;
        }

        setTextStyle(textStyle);

        a.recycle();

    }

    private void initView() {
        setWillNotDraw(false);
        setGravity(Gravity.CENTER);
        view = (LinearLayout) LayoutInflater.from(getContext()).inflate(R.layout.layout_needle, this, false);
//        view.setLayoutParams(new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));

        addView(view);

        needle1View = view.findViewById(R.id.view_needle_1);
        needle2View = view.findViewById(R.id.view_needle_2);

    }

    Paint paint = new Paint();

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        paint.setColor(Utils.adjustAlpha(progressColor, 70));

        float width = (float) getWidth() - getPaddingRight() - getPaddingLeft();
        float height = (float) getHeight() - getPaddingTop() - getPaddingBottom();
        float radius;

        if (width > height) {
            radius = height / 2;
        } else {
            radius = width / 2;
        }

        Path path = new Path();
        path.addCircle(width / 2,
                height / 2, radius,
                Path.Direction.CW);
        float strokeSize = Utils.convertDpToPixel(10);
        paint.setStrokeWidth(strokeSize);
        paint.setStyle(Paint.Style.FILL);

        float center_x, center_y;
        final RectF oval = new RectF();
        paint.setStyle(Paint.Style.STROKE);
        radius -= (strokeSize / 2);

        center_x = width / 2 + getPaddingLeft();
        center_y = height / 2 + getPaddingTop();


        oval.set(center_x - radius,
                center_y - radius,
                center_x + radius,
                center_y + radius);
        canvas.drawArc(oval, startAngle, sweepAngle, false, paint);

        rotateNeedle();

        paint.setStyle(Paint.Style.FILL);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setColor(progressColor);
        paint.setTextSize(progressTextSize);

        canvas.drawText(String.format(Locale.getDefault(), "%.0f", progressValue * 100 / maxValue),
                center_x,
                center_y+radius+progressTextSize/2, paint);

    }

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    private void rotateNeedle() {

        if (view != null)
            view.setRotation(-90 + (startAngle - 90) +
                    progressValue * sweepAngle / maxValue);


    }

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    public void setProgressValue(float progressValue) {
        this.progressValue = progressValue;
        if (progressValue > maxValue) {
            maxValue = progressValue;
        }

        invalidate();
        rotateNeedle();
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;

        needle1View.getBackground().setColorFilter(progressColor, PorterDuff.Mode.SRC_ATOP);
        needle2View.getBackground().setColorFilter(progressColor, PorterDuff.Mode.SRC_ATOP);

        invalidate();
//        requestLayout();
    }

    @RequiresApi(api = Build.VERSION_CODES.HONEYCOMB)
    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        invalidate();
        rotateNeedle();
    }

    public float getProgressValue() {
        return progressValue;
    }

    public int getProgressColor() {
        return progressColor;
    }

    public float getMaxValue() {
        return maxValue;
    }

    public void setTextStyle(int textStyle) {
        this.textStyle = textStyle;
        invalidate();
    }

    public void setProgressTextSize(float progressTextSize) {
        this.progressTextSize = progressTextSize;
        invalidate();
    }
}
