/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.widget.TextView;
import com.app.infideap.stylishwidget.view.Stylish;

public class ATextView
extends TextView {
    public ATextView(Context context) {
        super(context);
        this.setCustomTypeface(context, null);
    }

    public ATextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCustomTypeface(context, attrs);
    }

    public ATextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setCustomTypeface(context, attrs);
    }

    @TargetApi(value=21)
    public ATextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setCustomTypeface(context, attrs);
    }

    private void setCustomTypeface(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextAppearance);
        int style = a.getInt(R.styleable.TextAppearance_android_textStyle, 0);
        this.setTextStyle(style);
        a.recycle();
    }

    public void setTextStyle(int style) {
        String font;
        if (this.isInEditMode()) {
            return;
        }
        switch (style) {
            case 1: {
                font = Stylish.FONT_BOLD;
                break;
            }
            case 2: {
                font = Stylish.FONT_ITALIC;
                break;
            }
            case 0: {
                font = Stylish.FONT_REGULAR;
                break;
            }
            default: {
                font = Stylish.FONT_REGULAR;
            }
        }
        try {
            this.setTypeface(Stylish.getInstance().getTypeface(this.getContext(), font, this.getTypeface()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSupportTextAppearance(int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.setTextAppearance(resId);
        } else {
            this.setTextAppearance(this.getContext(), resId);
        }
    }
}

