/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Stylish {
    static final Map<String, Typeface> TYPEFACE = new HashMap<String, Typeface>();
    private static final String TAG = Stylish.class.getSimpleName();
    static String FONT_REGULAR = "";
    static String FONT_BOLD = "";
    static String FONT_ITALIC = "";
    private static final Stylish instance = new Stylish();
    private float fontScale = 1.0f;

    private Stylish() {
    }

    public void set(String regular, String bold, String italic) {
        FONT_REGULAR = regular;
        FONT_BOLD = bold;
        FONT_ITALIC = italic;
    }

    public void setFontRegular(String fontRegular) {
        FONT_REGULAR = fontRegular;
    }

    public void setFontBold(String fontBold) {
        FONT_BOLD = fontBold;
    }

    public void setFontItalic(String fontItalic) {
        FONT_ITALIC = fontItalic;
    }

    public static Stylish getInstance() {
        return instance;
    }

    Typeface getTypeface(Context context, String font, Typeface typeface) {
        if (!TYPEFACE.containsKey(font)) {
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
                TYPEFACE.put(font, typeface);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)String.format(Locale.getDefault(), "Unable to load '%s'. Please make sure the path of the font is correct.", font));
            }
        } else {
            typeface = TYPEFACE.get(font);
        }
        return typeface;
    }

    public Typeface reqular(Context context) {
        return this.getTypeface(context, FONT_REGULAR, null);
    }

    public Typeface bold(Context context) {
        return this.getTypeface(context, FONT_BOLD, null);
    }

    public Typeface italic(Context context) {
        return this.getTypeface(context, FONT_ITALIC, null);
    }

    boolean isExist(Context context, String font) {
        try {
            return Arrays.asList(context.getResources().getAssets().list("")).contains(font);
        }
        catch (IOException e) {
            return false;
        }
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
    }

    public Typeface getRegular() {
        return TYPEFACE.get(FONT_REGULAR);
    }

    public Typeface getBold() {
        return TYPEFACE.get(FONT_BOLD);
    }

    public Typeface getItalic() {
        return TYPEFACE.get(FONT_ITALIC);
    }
}

