/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.util.Utils;
import com.app.infideap.stylishwidget.view.ATextView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AProgressBar
extends LinearLayout {
    private static final String TAG = AProgressBar.class.getSimpleName();
    private static final Object TEXTVIEW_TAG = "TEXTVIEW";
    private int id = 1;
    private int radius;
    private int padding;
    private boolean isReverse;
    private float max;
    private List<LinearLayout> progressLayouts;
    private List<Progress> progress;
    private int gravity;
    private int textStyle;
    private float textSize;
    private int textAppearance;
    private ArrayList<Progress> sortProgress;
    private int iconPadding;

    public AProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public AProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=11)
    public AProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public AProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.progress = new ArrayList<Progress>();
        this.progressLayouts = new ArrayList<LinearLayout>();
        this.sortProgress = new ArrayList();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.progressBar);
        this.setMaxValue(a.getFloat(R.styleable.progressBar_sw_maxValue, 0.0f));
        this.setProgressValue(a.getFloat(R.styleable.progressBar_sw_progressValue, 0.0f));
        this.setProgressText(a.getString(R.styleable.progressBar_sw_progressText));
        this.setProgressTextStyle(a.getInt(R.styleable.progressBar_sw_progressTextStyle, 0));
        this.setProgressTextAppearance(a.getInt(R.styleable.progressBar_sw_progressTextAppearance, 0));
        this.setProgressTextSize(a.getDimension(R.styleable.progressBar_sw_progressTextSize, this.getResources().getDimension(R.dimen.progressTextSize)));
        this.setProgressIcon(a.getDrawable(R.styleable.progressBar_sw_progressIcon));
        this.setRadius(a.getDimensionPixelSize(R.styleable.progressBar_sw_radius, 0));
        this.setPadding(a.getDimensionPixelSize(R.styleable.progressBar_sw_progressPadding, 0));
        this.setProgressIconPadding(a.getDimensionPixelSize(R.styleable.progressBar_sw_progressIconPadding, 0));
        this.setProgressColor(a.getColor(R.styleable.progressBar_sw_progressColor, Color.rgb((int)255, (int)255, (int)255)));
        this.setProgressBackground(a.getColor(R.styleable.progressBar_sw_progressBackground, Color.argb((int)0, (int)0, (int)0, (int)0)));
        this.refresh();
        if (!this.isInEditMode() && a.getBoolean(R.styleable.progressBar_sw_withAnimation, false)) {
            this.withAnimation(a.getInteger(R.styleable.progressBar_sw_duration, 1000));
        }
        a.recycle();
    }

    private void setProgressTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setProgressBackground(int color) {
        this.createGradientDrawableWithCorner(this, color);
    }

    private void refresh() {
        if (this.progressLayouts != null) {
            if (this.progressLayouts.size() != this.sortProgress.size()) {
                this.addView(this.getContext());
            }
        } else {
            this.addView(this.getContext());
        }
        if (this.progressLayouts != null && this.progress != null) {
            float previousValue = 0.0f;
            for (int i = 0; i < this.progressLayouts.size(); ++i) {
                this.progressLayouts.get(i).setGravity(this.gravity);
                this.progressLayouts.get(i).setWeightSum(this.sortProgress.get((int)i).value);
                this.setProgress(this.progressLayouts.get(i), this.sortProgress.get(i), previousValue, i);
                previousValue = this.sortProgress.get((int)i).value;
            }
        }
    }

    public float getProgressValue() {
        return this.getProgressValue(0);
    }

    public float getProgressValue(int index) {
        if (index < 0 || index >= this.progress.size()) {
            return 0.0f;
        }
        return this.progress.get((int)index).value;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    private void addView(Context context) {
        if (this.progress == null) {
            return;
        }
        this.removeAllViews();
        this.setOrientation(0);
        LinearLayout progressLayout = null;
        boolean isRightAlign = this.isRightAlign();
        if (this.progressLayouts.size() > 0) {
            progressLayout = this.progressLayouts.get(this.progressLayouts.size() - 1);
        }
        for (int i = this.progressLayouts.size(); i < this.progress.size(); ++i) {
            this.progressLayouts.add(new LinearLayout(context));
            this.progressLayouts.get(i).setOrientation(0);
            ATextView textView = new ATextView(this.getContext());
            textView.setId(i);
            int padding = (int)Utils.convertDpToPixel(16.0f);
            textView.setPadding(padding, 0, padding, 0);
            textView.setGravity(17);
            textView.setTextColor(-1);
            LinearLayout linearLayout = new LinearLayout(this.getContext());
            linearLayout.setId(100 + i);
            linearLayout.setGravity(17);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1));
            linearLayout.addView((View)textView);
            if (isRightAlign) {
                this.progressLayouts.get(i).addView((View)linearLayout);
            }
            if (progressLayout != null) {
                this.progressLayouts.get(i).addView((View)progressLayout);
            }
            if (!isRightAlign) {
                this.progressLayouts.get(i).addView((View)linearLayout);
            }
            progressLayout = this.progressLayouts.get(i);
        }
        if (progressLayout != null) {
            this.addView((View)progressLayout);
        }
        this.progressLayouts = this.progressLayouts.subList(0, this.progress.size());
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    private void setRadius(int dimension) {
        this.radius = dimension;
        this.refresh();
    }

    private void setMax(float maxValue) {
        this.max = maxValue;
        this.setWeightSum(this.max);
    }

    public void setMaxValue(float maxValue) {
        if (this.progress.size() > 0 && this.sortProgress.get((int)(this.progress.size() - 1)).value > maxValue) {
            maxValue = this.sortProgress.get((int)(this.progress.size() - 1)).value;
        }
        this.setMax(maxValue);
        this.refresh();
    }

    public void setProgressValue(float progressValue) {
        if (progressValue > this.max) {
            this.setMax(progressValue);
        }
        if (this.progress.size() == 0) {
            this.progress.add(new Progress(progressValue));
        } else {
            this.progress.get((int)0).value = progressValue;
            this.progress = this.progress.subList(0, 1);
        }
        this.sort();
        this.refresh();
    }

    private void setProgress(LinearLayout progressLayout, Progress progress, float previousValue, int i) {
        this.createGradientDrawableWithCorner(progressLayout, progress.color);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1, progress.value);
        progressLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        progressLayout.setWeightSum(progress.value);
        ATextView textView = (ATextView)progressLayout.findViewById(i);
        LinearLayout layout2 = (LinearLayout)progressLayout.findViewById(100 + i);
        if (textView != null) {
            textView.setText(progress.text);
            textView.setCompoundDrawablesWithIntrinsicBounds(progress.drawable, null, null, null);
            textView.setCompoundDrawablePadding(this.iconPadding);
            textView.setTextStyle(this.textStyle);
            textView.setTextSize(this.textSize);
            textView.setSupportTextAppearance(this.textAppearance);
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, progress.value - previousValue));
        }
    }

    public void setProgressValues(float ... progressValues) {
        int i;
        this.progress.clear();
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).value = progressValues[i];
        }
        for (i = this.progress.size(); i < progressValues.length; ++i) {
            this.progress.add(new Progress(progressValues[i]));
        }
        this.progress = this.progress.subList(0, progressValues.length);
        if (this.progress.get((int)(this.progress.size() - 1)).value > this.max) {
            this.setMax(this.progress.get((int)(this.progress.size() - 1)).value);
        }
        this.sort();
        this.refresh();
    }

    public void addProgressValue(float progressValue) {
        this.progress.add(new Progress(progressValue));
        this.sort();
        this.refresh();
    }

    public void addProgressValue(float progressValue, int color) {
        this.progress.add(new Progress(progressValue, color));
        this.sort();
        this.refresh();
    }

    public boolean removeProgressValue(int index) {
        if (index < 0 || index >= this.progress.size()) {
            return false;
        }
        this.progress.remove(index);
        this.sort();
        this.refresh();
        return true;
    }

    public void setProgressValue(int index, float progressValue) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).value = progressValue;
        this.sort();
        this.refresh();
    }

    public void setProgressColor(int progressColor) {
        if (this.progress.size() == 0) {
            this.progress.add(new Progress(progressColor));
        } else {
            this.progress.get((int)0).color = progressColor;
            this.progress = this.progress.subList(0, 1);
        }
        this.refresh();
    }

    public void setProgressColor(int index, int color) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).color = color;
        this.refresh();
    }

    public void setProgressColors(int ... colors) {
        int i;
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).color = colors[i];
        }
        for (i = this.progress.size(); i < colors.length; ++i) {
            this.progress.add(new Progress(colors[i]));
        }
        this.refresh();
    }

    public void setProgressValueWithColor(int index, int progressValue, int color) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).value = progressValue;
        this.progress.get((int)index).color = color;
        this.sort();
        this.refresh();
    }

    public void setProgressText(int resId) {
        this.setProgressText(this.getResources().getString(resId));
    }

    public void setProgressText(String text) {
        if (this.progress.size() == 0) {
            this.progress.add(new Progress(text));
        } else {
            this.progress.get((int)0).text = text;
            this.progress = this.progress.subList(0, 1);
        }
        this.refresh();
    }

    public void setProgressTexts(int ... resIds) {
        int i;
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).text = this.getResources().getString(resIds[i]);
        }
        for (i = this.progress.size(); i < resIds.length; ++i) {
            this.progress.add(new Progress(this.getResources().getString(resIds[i])));
        }
        this.refresh();
    }

    public void setProgressTexts(String ... texts) {
        int i;
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).text = texts[i];
        }
        for (i = this.progress.size(); i < texts.length; ++i) {
            this.progress.add(new Progress(texts[i]));
        }
        this.refresh();
    }

    public void setProgressText(int index, int resId) {
        this.setProgressText(index, this.getResources().getString(resId));
    }

    public void setProgressText(int index, String text) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).text = text;
        this.refresh();
    }

    public void setProgressValueAndText(int index, float progressValue, int resId) {
        this.setProgressValueAndText(index, progressValue, resId);
    }

    public void setProgressValueAndText(int index, float progressValue, String text) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).value = progressValue;
        this.progress.get((int)index).text = text;
        this.sort();
        this.refresh();
    }

    public void setProgressIcon(int resId) {
        this.setProgressIcon(this.getResources().getDrawable(resId));
    }

    public void setProgressIcon(Drawable drawable) {
        if (this.progress.size() == 0) {
            this.progress.add(new Progress(drawable));
        } else {
            this.progress.get((int)0).drawable = drawable;
            this.progress = this.progress.subList(0, 1);
        }
        this.refresh();
    }

    public void setProgressIcons(Drawable ... drawables) {
        int i;
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).drawable = drawables[i];
        }
        for (i = this.progress.size(); i < drawables.length; ++i) {
            this.progress.add(new Progress(drawables[i]));
        }
        this.refresh();
    }

    public void setProgressIcons(int ... resIds) {
        int i;
        for (i = 0; i < this.progress.size(); ++i) {
            this.progress.get((int)i).drawable = this.getResources().getDrawable(resIds[i]);
        }
        for (i = this.progress.size(); i < resIds.length; ++i) {
            this.progress.add(new Progress(this.getResources().getDrawable(resIds[i])));
        }
        this.refresh();
    }

    public void setProgressIcon(int index, int resId) {
        this.setProgressIcon(index, this.getResources().getDrawable(resId));
    }

    public void setProgressIcon(int index, Drawable drawable) {
        if (index < 0 || index >= this.progress.size()) {
            return;
        }
        this.progress.get((int)index).drawable = drawable;
        this.refresh();
    }

    private void sort() {
        this.sortProgress.clear();
        this.sortProgress.addAll(this.progress);
        this.sort(this.sortProgress);
        if (this.sortProgress.size() > 0 && this.sortProgress.get((int)(this.sortProgress.size() - 1)).value > this.max) {
            this.max = this.sortProgress.get((int)(this.sortProgress.size() - 1)).value;
            this.setWeightSum(this.max);
        }
    }

    private void sort(List<Progress> progress) {
        Collections.sort(progress, new Comparator<Progress>(){

            @Override
            public int compare(Progress lhs, Progress rhs) {
                return lhs.value < rhs.value ? -1 : (lhs.value < rhs.value ? 1 : 0);
            }
        });
    }

    public void setGravity(int gravity) {
        super.setGravity(gravity);
        this.gravity = gravity;
        this.refresh();
    }

    public void withAnimation(final long duration) {
        if (this.progressLayouts == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ObjectAnimator[] animators = new ObjectAnimator[AProgressBar.this.progressLayouts.size() * 2];
                int i = 0;
                for (LinearLayout layout2 : AProgressBar.this.progressLayouts) {
                    int start = AProgressBar.this.isRightAlign() ? layout2.getWidth() / 2 : -layout2.getWidth() / 2;
                    animators[i++] = ObjectAnimator.ofFloat((Object)layout2, (String)"translationX", (float[])new float[]{start, 0.0f});
                    animators[i++] = ObjectAnimator.ofFloat((Object)layout2, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
                }
                if (animators.length == 0) {
                    return;
                }
                AnimatorSet set = new AnimatorSet();
                set.playTogether((Animator[])animators);
                set.setDuration(duration).start();
            }
        });
    }

    private boolean isRightAlign() {
        return Gravity.isHorizontal((int)this.gravity) && (this.gravity & 7) == 5;
    }

    private GradientDrawable createGradientDrawableWithCorner(LinearLayout layout2, int color) {
        GradientDrawable backgroundDrawable = this.createGradientDrawable(color);
        int newRadius = this.radius;
        backgroundDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        if (Build.VERSION.SDK_INT >= 16) {
            layout2.setBackground((Drawable)backgroundDrawable);
        } else {
            layout2.setBackgroundDrawable((Drawable)backgroundDrawable);
        }
        return backgroundDrawable;
    }

    protected GradientDrawable createGradientDrawable(int color) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setColor(color);
        return gradientDrawable;
    }

    public void setProgressTextStyle(int progressTextStyle) {
        this.textStyle = progressTextStyle;
        this.refresh();
    }

    public void setProgressTextAppearance(int progressTextAppearance) {
        this.textAppearance = progressTextAppearance;
    }

    public void setProgressIconPadding(int progressIconPadding) {
        this.iconPadding = progressIconPadding;
    }

    private class Progress {
        float value;
        int color;
        String text;
        Drawable drawable;

        public Progress(float progressValue) {
            this.value = progressValue;
            this.color = Color.rgb((int)((int)(255.0 * Math.random())), (int)((int)(255.0 * Math.random())), (int)((int)(255.0 * Math.random())));
        }

        public Progress(int color) {
            this.color = color;
        }

        public Progress(float progressValue, int color) {
            this.value = progressValue;
            this.color = color;
        }

        public Progress(String text) {
            this.text = text;
        }

        public Progress(Drawable drawable) {
            this.drawable = drawable;
        }
    }
}

