/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.app.infideap.stylishwidget.R;

public class IndicatorTabLayout
extends TabLayout {
    public IndicatorTabLayout(Context context) {
        super(context);
    }

    public IndicatorTabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IndicatorTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void addOnTabSelectedListener(@NonNull TabLayout.OnTabSelectedListener listener) {
        super.addOnTabSelectedListener(listener);
    }

    @RequiresApi(api=8)
    public void addTab(@NonNull TabLayout.Tab tab, int position, boolean setSelected) {
        IndicatorTab indicatorTab = new IndicatorTab(this.getContext(), tab, this);
        super.addTab(indicatorTab.tab, position, setSelected);
    }

    public void setIndicatorTextColor(int color2) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.parse(this.getTabAt(i)).countTextView.setTextColor(color2);
        }
    }

    public IndicatorTab getIndicatorTabAt(int index) {
        return this.parse(this.getTabAt(index));
    }

    private IndicatorTab parse(TabLayout.Tab tab) {
        return IndicatorTab.from(tab);
    }

    public static class IndicatorTab {
        private Context context;
        private TabLayout.Tab tab;
        private TextView titleTextView;
        private ImageView countImageView;
        private View countLayout;
        private TextView countTextView;

        @RequiresApi(api=8)
        private IndicatorTab(Context context, TabLayout.Tab tab, TabLayout tabLayout) {
            this.tab = tab;
            this.context = context;
            View customView = View.inflate((Context)context, (int)R.layout.tablayout_tab_view, null);
            this.init(customView);
            this.countLayout.setVisibility(8);
            this.countImageView.setColorFilter(ContextCompat.getColor((Context)context, (int)R.color.colorWhite));
            this.titleTextView.setTextColor(tabLayout.getTabTextColors());
            this.titleTextView.setText(tab.getText());
            tab.setCustomView(customView);
        }

        private void init(View customView) {
            this.titleTextView = (TextView)customView.findViewById(R.id.textView_title);
            this.countTextView = (TextView)customView.findViewById(R.id.textView_count);
            this.countImageView = (ImageView)customView.findViewById(R.id.imageView_count);
            this.countLayout = customView.findViewById(R.id.layout_count);
        }

        private IndicatorTab() {
        }

        public IndicatorTab setText(CharSequence text) {
            this.tab.setText(text);
            this.setText();
            return this;
        }

        public IndicatorTab setText(int text) {
            this.tab.setText(text);
            this.setText();
            return this;
        }

        private void setText() {
            this.titleTextView.setText(this.tab.getText());
        }

        public IndicatorTab setIndicatorText(CharSequence text) {
            this.countLayout.setVisibility(0);
            this.countTextView.setText(text);
            return this;
        }

        public IndicatorTab setIndicatorVisible(boolean visible) {
            this.countLayout.setVisibility(visible ? 0 : 8);
            return this;
        }

        public IndicatorTab setIcon(Drawable icon) {
            this.tab.setIcon(icon);
            return this;
        }

        public IndicatorTab setIcon(int icon) {
            this.tab.setIcon(icon);
            return this;
        }

        public void select() {
            this.tab.select();
        }

        public int getPosition() {
            return this.tab.getPosition();
        }

        public TabLayout.Tab getTab() {
            return this.tab;
        }

        public static IndicatorTab from(TabLayout.Tab tab) {
            IndicatorTab indicatorTab = new IndicatorTab();
            indicatorTab.tab = tab;
            if (tab.getCustomView() != null) {
                indicatorTab.init(tab.getCustomView());
            }
            return indicatorTab;
        }
    }
}

