/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.subscription.webmvc;

import com.apollographql.subscription.callback.SubscriptionCallback;
import com.apollographql.subscription.callback.SubscriptionCallbackHandler;
import graphql.ExecutionResult;
import jakarta.servlet.ServletException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.webmvc.GraphQlHttpHandler;
import org.springframework.http.MediaType;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.IdGenerator;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public class CallbackGraphQlHttpHandler
extends GraphQlHttpHandler {
    private static final Log logger = LogFactory.getLog(GraphQlHttpHandler.class);
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_PARAMETERIZED_TYPE_REF = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final MediaType APPLICATION_GRAPHQL_RESPONSE = MediaType.APPLICATION_GRAPHQL_RESPONSE;
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();
    private final WebGraphQlHandler graphQlHandler;
    private final SubscriptionCallbackHandler subscriptionCallbackHandler;

    public CallbackGraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        this(graphQlHandler, new SubscriptionCallbackHandler(graphQlHandler));
    }

    public CallbackGraphQlHttpHandler(WebGraphQlHandler graphQlHandler, SubscriptionCallbackHandler subscriptionCallbackHandler) {
        super(graphQlHandler);
        this.graphQlHandler = graphQlHandler;
        this.subscriptionCallbackHandler = subscriptionCallbackHandler;
    }

    @NotNull
    public ServerResponse handleRequest(@NotNull ServerRequest serverRequest) throws ServletException {
        WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(serverRequest.uri(), serverRequest.headers().asHttpHeaders(), CallbackGraphQlHttpHandler.initCookies((ServerRequest)serverRequest), (InetSocketAddress)serverRequest.remoteAddress().orElse(null), serverRequest.attributes(), this.readBody(serverRequest), this.idGenerator.generateId().toString(), LocaleContextHolder.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing: " + graphQlRequest));
        }
        if (graphQlRequest.getDocument().startsWith("subscription")) {
            Mono responseMono = SubscriptionCallback.parseSubscriptionCallbackExtension(graphQlRequest.getExtensions()).flatMap(callback -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Starting subscription using callback: " + callback));
                }
                return this.subscriptionCallbackHandler.handleSubscriptionUsingCallback(graphQlRequest, (SubscriptionCallback)callback).map(success -> {
                    if (success.booleanValue()) {
                        ExecutionResult emptyResponse = ExecutionResult.newExecutionResult().data(null).build();
                        ServerResponse.BodyBuilder builder = ServerResponse.ok();
                        builder.header("subscription-protocol", new String[]{"callback/1.0"});
                        builder.contentType(CallbackGraphQlHttpHandler.selectResponseMediaType(serverRequest));
                        return builder.body((Object)emptyResponse.toSpecification());
                    }
                    return ServerResponse.badRequest().build();
                });
            }).onErrorResume(error -> {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Unable to start subscription using callback protocol", error);
                }
                return Mono.just((Object)ServerResponse.badRequest().build());
            });
            return ServerResponse.async((Object)responseMono);
        }
        Mono responseMono = this.graphQlHandler.handleRequest(graphQlRequest).map(response -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Execution complete");
            }
            ServerResponse.BodyBuilder builder = ServerResponse.ok();
            builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
            builder.contentType(CallbackGraphQlHttpHandler.selectResponseMediaType(serverRequest));
            return builder.body((Object)response.toMap());
        });
        return ServerResponse.async((Object)responseMono);
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }
}

