/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.printer;

import com.apollographql.federation.graphqljava.FederationDirectives;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ServiceSDLPrinter {
    private static final Set<String> STANDARD_DIRECTIVES = new HashSet<String>(Arrays.asList("deprecated", "include", "oneOf", "skip", "specifiedBy"));

    private ServiceSDLPrinter() {
    }

    public static String generateServiceSDL(GraphQLSchema schema, final boolean queryTypeShouldBeEmpty) {
        HashSet<String> hiddenDirectiveDefinitions = new HashSet<String>();
        hiddenDirectiveDefinitions.addAll(STANDARD_DIRECTIVES);
        hiddenDirectiveDefinitions.addAll(FederationDirectives.allNames);
        HashSet<String> hiddenTypeDefinitions = new HashSet<String>();
        hiddenTypeDefinitions.add("_Any");
        hiddenTypeDefinitions.add("_Entity");
        hiddenTypeDefinitions.add("_FieldSet");
        hiddenTypeDefinitions.add("_Service");
        final String queryTypeName = schema.getQueryType().getName();
        final GraphqlFieldVisibility oldFieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        GraphqlFieldVisibility newFieldVisibility = new GraphqlFieldVisibility(){

            public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
                if (fieldsContainer.getName().equals(queryTypeName)) {
                    if (queryTypeShouldBeEmpty) {
                        return Collections.emptyList();
                    }
                    return fieldsContainer.getFieldDefinitions().stream().filter(field -> !"_service".equals(field.getName()) && !"_entities".equals(field.getName())).collect(Collectors.toList());
                }
                return oldFieldVisibility.getFieldDefinitions(fieldsContainer);
            }

            public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
                if (fieldsContainer.getName().equals(queryTypeName) && (queryTypeShouldBeEmpty || "_service".equals(fieldName) || "_entities".equals(fieldName))) {
                    return null;
                }
                return oldFieldVisibility.getFieldDefinition(fieldsContainer, fieldName);
            }
        };
        GraphQLCodeRegistry newCodeRegistry = schema.getCodeRegistry().transform(codeRegistryBuilder -> codeRegistryBuilder.fieldVisibility(newFieldVisibility));
        GraphQLSchema federatedSchema = schema.transform(schemaBuilder -> schemaBuilder.codeRegistry(newCodeRegistry));
        Predicate<GraphQLSchemaElement> excludeFedTypeDefinitions = element -> !(element instanceof GraphQLNamedSchemaElement) || !hiddenTypeDefinitions.contains(((GraphQLNamedSchemaElement)element).getName());
        Predicate<GraphQLSchemaElement> excludeFedDirectiveDefinitions = element -> !(element instanceof GraphQLDirective) || !hiddenDirectiveDefinitions.contains(((GraphQLDirective)element).getName());
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeScalarTypes(true).includeSchemaDefinition(true).includeDirectives(FederationDirectives.allNames::contains).includeSchemaElement(element -> excludeFedTypeDefinitions.test((GraphQLSchemaElement)element) && excludeFedDirectiveDefinitions.test((GraphQLSchemaElement)element));
        return new SchemaPrinter(options).print(federatedSchema).trim();
    }

    public static String generateServiceSDLV2(GraphQLSchema schema) {
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeSchemaDefinition(true).includeScalarTypes(true).includeDirectives(def -> !STANDARD_DIRECTIVES.contains(def))).print(schema).trim();
    }
}

