/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.tracing;

import com.apollographql.federation.graphqljava.tracing.HTTPRequestHeaders;
import com.google.protobuf.Timestamp;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.parser.InvalidSyntaxException;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.ValidationError;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mdg.engine.proto.Reports;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedTracingInstrumentation
extends SimplePerformantInstrumentation {
    public static final String FEDERATED_TRACING_HEADER_NAME = "apollo-federation-include-trace";
    public static final String FEDERATED_TRACING_HEADER_VALUE = "ftv1";
    private static final String EXTENSION_KEY = "ftv1";
    private final Options options;
    private static final Logger logger = LoggerFactory.getLogger(FederatedTracingInstrumentation.class);

    public FederatedTracingInstrumentation() {
        this.options = Options.newOptions();
    }

    public FederatedTracingInstrumentation(Options options) {
        this.options = options;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        if (this.options.shouldTrace(parameters.getExecutionInput())) {
            return new FederatedTracingState();
        }
        return null;
    }

    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        @Nullable FederatedTracingState federatedTracingState = (FederatedTracingState)state;
        if (federatedTracingState == null) {
            return super.instrumentExecutionResult(executionResult, parameters, null);
        }
        Reports.Trace trace = federatedTracingState.toProto();
        if (this.options.isDebuggingEnabled()) {
            logger.debug(trace.toString());
        }
        return CompletableFuture.completedFuture(ExecutionResultImpl.newExecutionResult().from(executionResult).addExtension("ftv1", (Object)Base64.getEncoder().encodeToString(trace.toByteArray())).build());
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        @Nullable FederatedTracingState federatedTracingState = (FederatedTracingState)state;
        if (federatedTracingState == null) {
            return super.beginFieldFetch(parameters, null);
        }
        SourceLocation fieldLocation = parameters.getEnvironment().getField().getSourceLocation();
        long startNanos = System.nanoTime();
        return SimpleInstrumentationContext.whenCompleted((result, throwable) -> {
            long endNanos = System.nanoTime();
            ExecutionStepInfo executionStepInfo = parameters.getEnvironment().getExecutionStepInfo();
            federatedTracingState.addFieldFetchData(executionStepInfo, startNanos - federatedTracingState.getStartRequestNanos(), endNanos - federatedTracingState.getStartRequestNanos(), this.convertErrors((Throwable)throwable, result), fieldLocation);
        });
    }

    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        @Nullable FederatedTracingState federatedTracingState = (FederatedTracingState)state;
        if (federatedTracingState == null) {
            return super.beginParse(parameters, null);
        }
        return SimpleInstrumentationContext.whenCompleted((document, throwable) -> {
            for (GraphQLError error : this.convertErrors((Throwable)throwable, null)) {
                federatedTracingState.addRootError(error);
            }
        });
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        @Nullable FederatedTracingState federatedTracingState = (FederatedTracingState)state;
        if (federatedTracingState == null) {
            return super.beginValidation(parameters, null);
        }
        return SimpleInstrumentationContext.whenCompleted((validationErrors, throwable) -> {
            for (GraphQLError error : this.convertErrors((Throwable)throwable, null)) {
                federatedTracingState.addRootError(error);
            }
            for (GraphQLError error : validationErrors) {
                federatedTracingState.addRootError(error);
            }
        });
    }

    @NotNull
    private List<GraphQLError> convertErrors(Throwable throwable, Object result) {
        DataFetcherResult theResult;
        ArrayList<GraphQLError> graphQLErrors = new ArrayList<GraphQLError>();
        if (throwable != null) {
            if (throwable instanceof GraphQLError) {
                graphQLErrors.add((GraphQLError)throwable);
            } else {
                String message = throwable.getMessage();
                if (message == null) {
                    message = "(null)";
                }
                GraphqlErrorBuilder errorBuilder = GraphqlErrorBuilder.newError().message(message, new Object[0]);
                if (throwable instanceof InvalidSyntaxException) {
                    errorBuilder.location(((InvalidSyntaxException)throwable).getLocation());
                }
                graphQLErrors.add(errorBuilder.build());
            }
        }
        if (result instanceof DataFetcherResult && (theResult = (DataFetcherResult)result).hasErrors()) {
            graphQLErrors.addAll(theResult.getErrors());
        }
        return graphQLErrors;
    }

    public static class Options {
        private final boolean debuggingEnabled;
        @Nullable
        private final Predicate<ExecutionInput> shouldTracePredicate;

        public Options(boolean debuggingEnabled, @Nullable Predicate<ExecutionInput> shouldTracePredicate) {
            this.debuggingEnabled = debuggingEnabled;
            this.shouldTracePredicate = shouldTracePredicate;
        }

        public Options(boolean debuggingEnabled) {
            this(debuggingEnabled, null);
        }

        @NotNull
        public static Options newOptions() {
            return new Options(false);
        }

        public boolean isDebuggingEnabled() {
            return this.debuggingEnabled;
        }

        public boolean shouldTrace(ExecutionInput executionInput) {
            if (this.shouldTracePredicate != null) {
                return this.shouldTracePredicate.test(executionInput);
            }
            if (executionInput != null) {
                Object context;
                if (executionInput.getGraphQLContext().hasKey((Object)FederatedTracingInstrumentation.FEDERATED_TRACING_HEADER_NAME)) {
                    return "ftv1".equals(executionInput.getGraphQLContext().get((Object)FederatedTracingInstrumentation.FEDERATED_TRACING_HEADER_NAME));
                }
                if (executionInput.getContext() != null && (context = executionInput.getContext()) instanceof HTTPRequestHeaders) {
                    String header = ((HTTPRequestHeaders)context).getHTTPRequestHeader(FederatedTracingInstrumentation.FEDERATED_TRACING_HEADER_NAME);
                    return "ftv1".equals(header);
                }
            }
            return true;
        }
    }

    private static class FederatedTracingState
    implements InstrumentationState {
        private final Instant startRequestTime = Instant.now();
        private final long startRequestNanos = System.nanoTime();
        private final ProtoBuilderTree protoBuilderTree = new ProtoBuilderTree();

        private FederatedTracingState() {
        }

        @NotNull
        Reports.Trace toProto() {
            return Reports.Trace.newBuilder().setStartTime(this.getStartTimestamp()).setEndTime(this.getNowTimestamp()).setDurationNs(this.getDuration()).setRoot(this.protoBuilderTree.toProto()).build();
        }

        void addFieldFetchData(ExecutionStepInfo stepInfo, long startFieldNanos, long endFieldNanos, List<GraphQLError> errors, SourceLocation fieldLocation) {
            ResultPath path = stepInfo.getPath();
            this.protoBuilderTree.editBuilder(path, builder -> {
                builder.setStartTime(startFieldNanos).setEndTime(endFieldNanos).setParentType(GraphQLTypeUtil.simplePrint((GraphQLType)stepInfo.getParent().getUnwrappedNonNullType())).setType(stepInfo.simplePrint()).setResponseName(stepInfo.getResultKey());
                String originalFieldName = stepInfo.getField().getName();
                if (!originalFieldName.equals(stepInfo.getResultKey())) {
                    builder.setOriginalFieldName(originalFieldName);
                }
                errors.forEach(error -> {
                    Reports.Trace.Error.Builder errorBuilder = builder.addErrorBuilder().setMessage(error.getMessage());
                    List locations = error.getLocations();
                    if ((locations == null || locations.isEmpty()) && fieldLocation != null) {
                        errorBuilder.addLocationBuilder().setColumn(fieldLocation.getColumn()).setLine(fieldLocation.getLine());
                    } else if (locations != null) {
                        error.getLocations().forEach(location -> errorBuilder.addLocationBuilder().setColumn(location.getColumn()).setLine(location.getLine()));
                    }
                });
            });
        }

        void addRootError(GraphQLError error) {
            this.protoBuilderTree.editBuilder(ResultPath.rootPath(), builder -> {
                Reports.Trace.Error.Builder errorBuilder = builder.addErrorBuilder().setMessage(error.getMessage());
                if (error.getLocations() != null) {
                    error.getLocations().forEach(location -> errorBuilder.addLocationBuilder().setColumn(location.getColumn()).setLine(location.getLine()));
                }
            });
        }

        long getStartRequestNanos() {
            return this.startRequestNanos;
        }

        @NotNull
        private static Timestamp instantToTimestamp(@NotNull Instant startRequestTime2) {
            return Timestamp.newBuilder().setSeconds(startRequestTime2.getEpochSecond()).setNanos(startRequestTime2.getNano()).build();
        }

        @NotNull
        private Timestamp getStartTimestamp() {
            return FederatedTracingState.instantToTimestamp(this.startRequestTime);
        }

        @NotNull
        private Timestamp getNowTimestamp() {
            return FederatedTracingState.instantToTimestamp(Instant.now());
        }

        private long getDuration() {
            return System.nanoTime() - this.startRequestNanos;
        }

        private static class ProtoBuilderTree {
            private final Node root = new Node(Reports.Trace.Node.newBuilder());
            private final ConcurrentMap<ResultPath, Node> nodesByPath = new ConcurrentHashMap<ResultPath, Node>();
            private final ReadWriteLock treeLock;
            private boolean isFinalized;

            public ProtoBuilderTree() {
                this.nodesByPath.put(ResultPath.rootPath(), this.root);
                this.treeLock = new ReentrantReadWriteLock();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void editBuilder(ResultPath path, Consumer<Reports.Trace.Node.Builder> builderConsumer) {
                Lock l = this.treeLock.readLock();
                l.lock();
                try {
                    if (this.isFinalized) {
                        throw new RuntimeException("Cannot edit builder after protobuf conversion.");
                    }
                    Node node = this.getOrCreateNode(path);
                    Reports.Trace.Node.Builder builder = node.builder;
                    synchronized (builder) {
                        builderConsumer.accept(node.builder);
                    }
                }
                finally {
                    l.unlock();
                }
            }

            @NotNull
            private Node getOrCreateNode(ResultPath path) {
                Node current = (Node)this.nodesByPath.get(path);
                if (current != null) {
                    return current;
                }
                List pathSegments = path.toList();
                int currentSegmentIndex = pathSegments.size();
                while (current == null) {
                    if (currentSegmentIndex <= 0) {
                        throw new RuntimeException("root path missing from nodesByPath?");
                    }
                    ResultPath currentPath = ResultPath.fromList(pathSegments.subList(0, --currentSegmentIndex));
                    current = (Node)this.nodesByPath.get(currentPath);
                }
                while (currentSegmentIndex < pathSegments.size()) {
                    Node parent = current;
                    ResultPath childPath = ResultPath.fromList(pathSegments.subList(0, currentSegmentIndex + 1));
                    Object childSegment = pathSegments.get(currentSegmentIndex);
                    Reports.Trace.Node.Builder childBuilder = Reports.Trace.Node.newBuilder();
                    if (childSegment instanceof Integer) {
                        childBuilder.setIndex((Integer)childSegment);
                    } else if (currentSegmentIndex < pathSegments.size() - 1) {
                        throw new RuntimeException("Unexpected missing non-index " + childSegment);
                    }
                    Node childNode = new Node(childBuilder);
                    current = this.nodesByPath.putIfAbsent(childPath, childNode);
                    if (current == null) {
                        current = childNode;
                        parent.children.add(childNode);
                    }
                    ++currentSegmentIndex;
                }
                return current;
            }

            @NotNull
            public Reports.Trace.Node toProto() {
                Lock l = this.treeLock.writeLock();
                l.lock();
                try {
                    if (!this.isFinalized) {
                        this.buildDescendants(this.root);
                        this.isFinalized = true;
                    }
                    Reports.Trace.Node node = this.root.builder.build();
                    return node;
                }
                finally {
                    l.unlock();
                }
            }

            private void buildDescendants(Node node) {
                for (Node childNode : node.children) {
                    this.buildDescendants(childNode);
                    node.builder.addChild(childNode.builder.build());
                }
            }

            private static class Node {
                public final Reports.Trace.Node.Builder builder;
                public final ConcurrentLinkedQueue<Node> children;

                public Node(Reports.Trace.Node.Builder builder) {
                    this.builder = builder;
                    this.children = new ConcurrentLinkedQueue();
                }
            }
        }
    }
}

