/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.caching;

import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class CacheControlInstrumentation
extends SimpleInstrumentation {
    private final int defaultMaxAge;
    private static final Object CONTEXT_KEY = new Object();
    private static final String DIRECTIVE_NAME = "cacheControl";
    private static final String MAX_AGE = "maxAge";
    private static final String SCOPE = "scope";
    private static final String INHERIT_MAX_AGE = "inheritMaxAge";

    public CacheControlInstrumentation() {
        this(0);
    }

    public CacheControlInstrumentation(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    @Nullable
    public static String cacheControlHeaderFromGraphQLContext(GraphQLContext context) {
        return (String)context.get(CONTEXT_KEY);
    }

    public InstrumentationState createState() {
        return new CacheControlState();
    }

    public InstrumentationContext<ExecutionResult> beginExecution(final InstrumentationExecutionParameters parameters) {
        return new InstrumentationContext<ExecutionResult>(){

            public void onDispatched(CompletableFuture<ExecutionResult> completableFuture) {
            }

            public void onCompleted(ExecutionResult executionResult, Throwable throwable) {
                CacheControlState state = (CacheControlState)parameters.getInstrumentationState();
                state.overallPolicy.maybeAsString().ifPresent(s -> parameters.getGraphQLContext().put(CONTEXT_KEY, s));
            }
        };
    }

    public InstrumentationContext<ExecutionResult> beginField(InstrumentationFieldParameters parameters) {
        Optional<CacheControlDirective> directive2;
        CacheControlState state = (CacheControlState)parameters.getInstrumentationState();
        CacheControlPolicy fieldPolicy = new CacheControlPolicy();
        boolean inheritMaxAge = false;
        GraphQLUnmodifiedType unwrappedFieldType = GraphQLTypeUtil.unwrapAll((GraphQLType)parameters.getExecutionStepInfo().getType());
        if (unwrappedFieldType.getName().equals("_Entity")) {
            Object representations = parameters.getExecutionStepInfo().getArgument("representations");
            if (representations instanceof List) {
                CacheControlInstrumentation.typesFromEntitiesArgument(representations, parameters.getExecutionContext().getGraphQLSchema()).stream().map(type -> CacheControlDirective.fromDirectiveContainer((GraphQLDirectiveContainer)type)).filter(Optional::isPresent).forEach(directive -> fieldPolicy.restrict((CacheControlDirective)directive.get()));
            }
        } else if (unwrappedFieldType instanceof GraphQLCompositeType && unwrappedFieldType instanceof GraphQLDirectiveContainer && (directive2 = CacheControlDirective.fromDirectiveContainer((GraphQLDirectiveContainer)unwrappedFieldType)).isPresent()) {
            fieldPolicy.replace(directive2.get());
            inheritMaxAge = directive2.get().getInheritMaxAge();
        }
        Optional<CacheControlDirective> fieldDirective = CacheControlDirective.fromDirectiveContainer((GraphQLDirectiveContainer)parameters.getField());
        if (fieldDirective.isPresent()) {
            CacheControlDirective directive3 = fieldDirective.get();
            if (directive3.getInheritMaxAge().booleanValue() && !fieldPolicy.hasMaxAge()) {
                inheritMaxAge = true;
                fieldPolicy.replace(directive3.getScope());
            } else {
                fieldPolicy.replace(directive3);
            }
        }
        if (!fieldPolicy.hasMaxAge() && (unwrappedFieldType instanceof GraphQLCompositeType && !inheritMaxAge || parameters.getExecutionStepInfo().getPath().isRootPath())) {
            fieldPolicy.restrict(this.defaultMaxAge);
        }
        state.overallPolicy.restrict(fieldPolicy);
        return super.beginField(parameters);
    }

    static List<GraphQLType> typesFromEntitiesArgument(Object representations, GraphQLSchema schema) {
        if (representations instanceof List) {
            return ((List)representations).stream().filter(rep -> rep instanceof Map).map(rep -> ((Map)rep).get("__typename")).map(Object::toString).distinct().map(arg_0 -> ((GraphQLSchema)schema).getType(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<GraphQLType>();
    }

    private static class CacheControlState
    implements InstrumentationState {
        public final CacheControlPolicy overallPolicy = new CacheControlPolicy();

        private CacheControlState() {
        }
    }

    private static class CacheControlPolicy {
        @Nullable
        private Integer maxAge;
        @Nullable
        private CacheControlScope scope = CacheControlScope.PUBLIC;

        private CacheControlPolicy() {
        }

        void restrict(CacheControlPolicy policy) {
            if (policy.maxAge != null && (this.maxAge == null || policy.maxAge < this.maxAge)) {
                this.maxAge = policy.maxAge;
            }
            if (!(policy.scope == null || this.scope != null && this.scope.equals((Object)CacheControlScope.PRIVATE))) {
                this.scope = policy.scope;
            }
        }

        void restrict(CacheControlDirective directive) {
            if (directive.maxAge != null && (this.maxAge == null || directive.maxAge < this.maxAge)) {
                this.maxAge = directive.maxAge;
            }
            if (!(directive.scope == null || this.scope != null && this.scope.equals((Object)CacheControlScope.PRIVATE))) {
                this.scope = directive.scope;
            }
        }

        void restrict(Integer maxAge) {
            if (this.maxAge == null || maxAge < this.maxAge) {
                this.maxAge = maxAge;
            }
        }

        void replace(CacheControlDirective directive) {
            if (directive.maxAge != null) {
                this.maxAge = directive.maxAge;
            }
            if (directive.scope != null) {
                this.scope = directive.scope;
            }
        }

        void replace(@Nullable CacheControlScope scope) {
            if (scope != null) {
                this.scope = scope;
            }
        }

        public Optional<String> maybeAsString() {
            Integer maxAgeValue = this.maxAge == null ? 0 : this.maxAge;
            if (maxAgeValue.equals(0)) {
                return Optional.empty();
            }
            CacheControlScope scopeValue = this.scope == null ? CacheControlScope.PUBLIC : this.scope;
            return Optional.of(String.format("max-age=%d, %s", maxAgeValue, scopeValue.toString().toLowerCase()));
        }

        public boolean hasMaxAge() {
            return this.maxAge != null;
        }

        public boolean hasScope() {
            return this.scope != null;
        }
    }

    private static class CacheControlDirective {
        @Nullable
        private final Integer maxAge;
        @Nullable
        private final CacheControlScope scope;
        @Nullable
        private final Boolean inheritMaxAge;

        public static Optional<CacheControlDirective> fromDirectiveContainer(GraphQLDirectiveContainer container) {
            GraphQLDirective directive = container.getDirective(CacheControlInstrumentation.DIRECTIVE_NAME);
            if (directive == null) {
                return Optional.empty();
            }
            Integer maxAge = Optional.ofNullable(directive.getArgument(CacheControlInstrumentation.MAX_AGE)).map(a -> GraphQLArgument.getArgumentValue((GraphQLArgument)a)).filter(v -> v instanceof Integer).map(Integer.class::cast).orElse(null);
            CacheControlScope scope = Optional.ofNullable(directive.getArgument(CacheControlInstrumentation.SCOPE)).map(a -> GraphQLArgument.getArgumentValue((GraphQLArgument)a)).filter(v -> v instanceof String).map(s -> CacheControlScope.valueOf((String)s)).orElse(null);
            Boolean inheritMaxAge = Optional.ofNullable(directive.getArgument(CacheControlInstrumentation.INHERIT_MAX_AGE)).map(a -> GraphQLArgument.getArgumentValue((GraphQLArgument)a)).filter(v -> v instanceof Boolean).map(Boolean.class::cast).orElse(null);
            return Optional.of(new CacheControlDirective(maxAge, scope, inheritMaxAge));
        }

        public CacheControlDirective(@Nullable Integer maxAge, @Nullable CacheControlScope scope, @Nullable Boolean inheritMaxAge) {
            this.maxAge = maxAge;
            this.scope = scope;
            this.inheritMaxAge = inheritMaxAge;
        }

        public boolean isRestricted() {
            return this.maxAge != null || this.scope != null;
        }

        @Nullable
        public Integer getMaxAge() {
            return this.maxAge;
        }

        public boolean hasMaxAge() {
            return this.maxAge != null;
        }

        @Nullable
        public CacheControlScope getScope() {
            return this.scope;
        }

        public boolean hasScope() {
            return this.scope != null;
        }

        public Boolean getInheritMaxAge() {
            return this.inheritMaxAge != null && this.inheritMaxAge != false;
        }

        public boolean hasInheritMaxAge() {
            return this.inheritMaxAge != null;
        }

        public String toString() {
            return String.format("@cacheControl(maxAge: %s, scope: %s, inheritMaxAge: %s)", new Object[]{this.maxAge, this.scope, this.inheritMaxAge});
        }
    }

    static enum CacheControlScope {
        PUBLIC,
        PRIVATE;

    }
}

