/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.directives;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.directives.LinkImportsRenamingVisitor;
import com.apollographql.federation.graphqljava.exceptions.MultipleFederationLinksException;
import com.apollographql.federation.graphqljava.exceptions.UnsupportedLinkImportException;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.AstTransformer;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.SDLNamedDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class LinkDirectiveProcessor {
    private LinkDirectiveProcessor() {
    }

    @Nullable
    public static Stream<SDLNamedDefinition> loadFederationImportedDefinitions(TypeDefinitionRegistry typeDefinitionRegistry) {
        Stream extensionLinkDirectives;
        Stream schemaLinkDirectives = typeDefinitionRegistry.schemaDefinition().map(LinkDirectiveProcessor::getFederationLinkDirectives).orElse(Stream.empty());
        List<Directive> federationLinkDirectives = Stream.concat(schemaLinkDirectives, extensionLinkDirectives = typeDefinitionRegistry.getSchemaExtensionDefinitions().stream().flatMap(LinkDirectiveProcessor::getFederationLinkDirectives)).collect(Collectors.toList());
        if (federationLinkDirectives.isEmpty()) {
            return null;
        }
        if (federationLinkDirectives.size() > 1) {
            throw new MultipleFederationLinksException(federationLinkDirectives);
        }
        return LinkDirectiveProcessor.loadDefinitions((Directive)federationLinkDirectives.get(0));
    }

    private static Stream<SDLNamedDefinition> loadDefinitions(Directive linkDirective) {
        Map<String, String> imports = LinkDirectiveProcessor.parseLinkImports(linkDirective);
        Argument urlArgument = linkDirective.getArgument("url");
        String specLink = ((StringValue)urlArgument.getValue()).getValue();
        boolean allowComposeableDirective = "https://specs.apollo.dev/federation/v2.1".equals(specLink);
        boolean allowInterfaceObjectDirective = "https://specs.apollo.dev/federation/v2.3".equals(specLink);
        if (!allowComposeableDirective && imports.containsKey("@composeDirective")) {
            throw new UnsupportedLinkImportException("@composeDirective");
        }
        if (!allowInterfaceObjectDirective && imports.containsKey("@interfaceObject")) {
            throw new UnsupportedLinkImportException("@interfaceObject");
        }
        return FederationDirectives.loadFederationSpecDefinitions(specLink).stream().map(definition -> (SDLNamedDefinition)new AstTransformer().transform((Node)definition, (NodeVisitor)new LinkImportsRenamingVisitor(imports)));
    }

    private static Stream<Directive> getFederationLinkDirectives(SchemaDefinition schemaDefinition) {
        return schemaDefinition.getDirectives("link").stream().filter(directive -> {
            Argument urlArgument = directive.getArgument("url");
            if (urlArgument != null && urlArgument.getValue() instanceof StringValue) {
                StringValue value = (StringValue)urlArgument.getValue();
                return value.getValue().startsWith("https://specs.apollo.dev/federation/");
            }
            return false;
        });
    }

    private static Map<String, String> parseLinkImports(Directive linkDirective) {
        HashMap<String, String> imports = new HashMap<String, String>();
        Argument importArgument = linkDirective.getArgument("import");
        if (importArgument != null && importArgument.getValue() instanceof ArrayValue) {
            ArrayValue linkImports = (ArrayValue)importArgument.getValue();
            for (Value importedDefinition : linkImports.getValues()) {
                if (importedDefinition instanceof StringValue) {
                    String name = ((StringValue)importedDefinition).getValue();
                    imports.put(name, name);
                    continue;
                }
                if (importedDefinition instanceof ObjectValue) {
                    ObjectValue importedObjectValue = (ObjectValue)importedDefinition;
                    Optional<ObjectField> nameField = importedObjectValue.getObjectFields().stream().filter(field -> field.getName().equals("name")).findFirst();
                    Optional<ObjectField> renameAsField = importedObjectValue.getObjectFields().stream().filter(field -> field.getName().equals("as")).findFirst();
                    if (!nameField.isPresent() || !(nameField.get().getValue() instanceof StringValue)) {
                        throw new UnsupportedLinkImportException((Value)importedObjectValue);
                    }
                    String name = ((StringValue)nameField.get().getValue()).getValue();
                    if (!renameAsField.isPresent()) {
                        imports.put(name, name);
                        continue;
                    }
                    Value renamedAsValue = renameAsField.get().getValue();
                    if (!(renamedAsValue instanceof StringValue)) {
                        throw new UnsupportedLinkImportException((Value)importedObjectValue);
                    }
                    imports.put(name, ((StringValue)renamedAsValue).getValue());
                    continue;
                }
                throw new UnsupportedLinkImportException(importedDefinition);
            }
        }
        imports.put("@link", "@link");
        return imports;
    }
}

