/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.SchemaTransformer;
import com.apollographql.federation.graphqljava._FieldSet;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.File;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class Federation {
    private static final SchemaGenerator.Options generatorOptions = SchemaGenerator.Options.defaultOptions();

    private Federation() {
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema) {
        return new SchemaTransformer(schema, false);
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        return new SchemaTransformer(schema, queryTypeShouldBeEmpty);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        boolean queryTypeShouldBeEmpty = Federation.ensureQueryTypeExists(typeRegistry);
        RuntimeWiring newRuntimeWiring = Federation.ensureFederationDirectiveDefinitionsExist(typeRegistry, runtimeWiring);
        GraphQLSchema original = new SchemaGenerator().makeExecutableSchema(generatorOptions, typeRegistry, newRuntimeWiring);
        return Federation.transform(original, queryTypeShouldBeEmpty);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry) {
        return Federation.transform(typeRegistry, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(String sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(Reader sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(File sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(String sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(Reader sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(File sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    private static RuntimeWiring emptyWiring() {
        return RuntimeWiring.newRuntimeWiring().build();
    }

    private static boolean ensureQueryTypeExists(TypeDefinitionRegistry typeRegistry) {
        boolean addDummyField;
        String queryName = typeRegistry.schemaDefinition().flatMap(sdef -> sdef.getOperationTypeDefinitions().stream().filter(op -> "query".equals(op.getName())).findFirst().map(def -> def.getTypeName().getName())).orElse("Query");
        TypeDefinition newQueryType = (TypeDefinition)typeRegistry.getType(queryName).orElse(ObjectTypeDefinition.newObjectTypeDefinition().name(queryName).build());
        boolean bl = addDummyField = newQueryType instanceof ObjectTypeDefinition && ((ObjectTypeDefinition)newQueryType).getFieldDefinitions().isEmpty() && Optional.ofNullable((List)typeRegistry.objectTypeExtensions().get(queryName)).map(List::isEmpty).orElse(true) != false;
        if (addDummyField) {
            newQueryType = ((ObjectTypeDefinition)newQueryType).transform((T objectTypeDefinitionBuilder) -> objectTypeDefinitionBuilder.fieldDefinition(FieldDefinition.newFieldDefinition().name("_dummy").type((Type)new TypeName("String")).build()));
        }
        typeRegistry.remove((SDLDefinition)newQueryType);
        typeRegistry.add((SDLDefinition)newQueryType);
        return addDummyField;
    }

    private static RuntimeWiring ensureFederationDirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        FederationDirectives.allDefinitions.stream().filter(def -> !typeRegistry.getDirectiveDefinition(def.getName()).isPresent()).forEachOrdered(arg_0 -> ((TypeDefinitionRegistry)typeRegistry).add(arg_0));
        if (!typeRegistry.getType("_FieldSet").isPresent()) {
            typeRegistry.add((SDLDefinition)_FieldSet.definition);
        }
        if (!runtimeWiring.getScalars().containsKey("_FieldSet")) {
            return Federation.copyRuntimeWiring(runtimeWiring).scalar(_FieldSet.type).build();
        }
        return runtimeWiring;
    }

    private static RuntimeWiring.Builder copyRuntimeWiring(RuntimeWiring runtimeWiring) {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        runtimeWiring.getDataFetchers().entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            TypeRuntimeWiring.Builder typeWiring = TypeRuntimeWiring.newTypeWiring((String)name);
            typeWiring.dataFetchers((Map)entry.getValue());
            if (runtimeWiring.getDefaultDataFetcherForType(name) != null) {
                typeWiring.defaultDataFetcher(runtimeWiring.getDefaultDataFetcherForType(name));
            }
            if (runtimeWiring.getTypeResolvers().get(name) != null) {
                typeWiring.typeResolver((TypeResolver)runtimeWiring.getTypeResolvers().get(name));
            }
            if (runtimeWiring.getEnumValuesProviders().get(name) != null) {
                typeWiring.enumValues((EnumValuesProvider)runtimeWiring.getEnumValuesProviders().get(name));
            }
            return typeWiring.build();
        }).forEach(arg_0 -> ((RuntimeWiring.Builder)builder).type(arg_0));
        if (runtimeWiring.getWiringFactory() != null) {
            builder.wiringFactory(runtimeWiring.getWiringFactory());
        }
        if (runtimeWiring.getCodeRegistry() != null) {
            builder.codeRegistry(runtimeWiring.getCodeRegistry());
        }
        runtimeWiring.getScalars().forEach((name, scalar) -> builder.scalar(scalar));
        if (runtimeWiring.getFieldVisibility() != null) {
            builder.fieldVisibility(runtimeWiring.getFieldVisibility());
        }
        runtimeWiring.getRegisteredDirectiveWiring().forEach((arg_0, arg_1) -> ((RuntimeWiring.Builder)builder).directive(arg_0, arg_1));
        runtimeWiring.getDirectiveWiring().forEach(arg_0 -> ((RuntimeWiring.Builder)builder).directiveWiring(arg_0));
        builder.comparatorRegistry(runtimeWiring.getComparatorRegistry());
        runtimeWiring.getSchemaGeneratorPostProcessings().forEach(arg_0 -> ((RuntimeWiring.Builder)builder).transformer(arg_0));
        return builder;
    }
}

