/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.tooling;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloGraphQLException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.tooling.SchemaDownloaderKt;
import com.apollographql.apollo3.tooling.SchemaUploader;
import com.apollographql.apollo3.tooling.platformapi.public.PublishMonolithSchemaMutation;
import com.apollographql.apollo3.tooling.platformapi.public.PublishSubgraphSchemaMutation;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fH\u0002JN\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fH\u0002JX\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/tooling/SchemaUploader;", "", "()V", "publishMonolithSchema", "", "apolloClient", "Lcom/apollographql/apollo3/ApolloClient;", "graphID", "", "variant", "sdl", "headers", "", "publishSubgraphSchema", "subgraph", "revision", "uploadSchema", "key", "graph", "apollo-tooling"})
@ApolloExperimental
@SourceDebugExtension(value={"SMAP\nSchemaUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaUploader.kt\ncom/apollographql/apollo3/tooling/SchemaUploader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n125#2:147\n152#2,3:148\n125#2:152\n152#2,3:153\n1#3:151\n*S KotlinDebug\n*F\n+ 1 SchemaUploader.kt\ncom/apollographql/apollo3/tooling/SchemaUploader\n*L\n74#1:147\n74#1:148,3\n120#1:152\n120#1:153,3\n*E\n"})
public final class SchemaUploader {
    @NotNull
    public static final SchemaUploader INSTANCE = new SchemaUploader();

    private SchemaUploader() {
    }

    public final void uploadSchema(@NotNull String sdl, @NotNull String key, @Nullable String graph, @NotNull String variant, @Nullable String subgraph, @Nullable String revision, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)sdl, (String)"sdl");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (!(subgraph == null && revision == null || subgraph != null && revision != null)) {
            boolean $i$a$-check-SchemaUploader$uploadSchema$22 = false;
            String $i$a$-check-SchemaUploader$uploadSchema$22 = "subgraph and revision must be both null or both not null";
            throw new IllegalStateException($i$a$-check-SchemaUploader$uploadSchema$22.toString());
        }
        ApolloClient apolloClient = new ApolloClient.Builder().serverUrl("https://api.apollographql.com/graphql").httpExposeErrorBody(true).build();
        String string = graph;
        if (string == null && (string = SchemaDownloaderKt.getGraph(key)) == null) {
            throw new IllegalStateException("graph not found".toString());
        }
        String graphID = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"x-api-key", (Object)key), TuplesKt.to((Object)"apollographql-client-name", (Object)"apollo-tooling"), TuplesKt.to((Object)"apollographql-client-version", (Object)"4.0.0-alpha.2")};
        Map allHeaders = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), headers);
        if (subgraph == null) {
            this.publishMonolithSchema(apolloClient, graphID, variant, sdl, allHeaders);
        } else {
            this.publishSubgraphSchema(apolloClient, graphID, variant, sdl, subgraph, revision, allHeaders);
        }
    }

    public static /* synthetic */ void uploadSchema$default(SchemaUploader schemaUploader, String string, String string2, String string3, String string4, String string5, String string6, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "current";
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        schemaUploader.uploadSchema(string, string2, string3, string4, string5, string6, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void publishMonolithSchema(ApolloClient apolloClient, String graphID, String variant, String sdl, Map<String, String> headers) {
        Boolean success;
        PublishMonolithSchemaMutation.Data data;
        block10: {
            ApolloException e;
            block11: {
                Object object;
                block14: {
                    block12: {
                        String string;
                        Object object2;
                        Object item$iv$iv;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Map<String, String> map = headers;
                        ApolloCall apolloCall = apolloClient.mutation((Mutation)new PublishMonolithSchemaMutation(graphID, variant, sdl));
                        boolean $i$f$map = false;
                        void var9_10 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            object2 = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
                        }
                        ApolloCall call = apolloCall.httpHeaders((List)destination$iv$iv);
                        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<PublishMonolithSchemaMutation.Data>>, Object>((ApolloCall<PublishMonolithSchemaMutation.Data>)call, null){
                            int label;
                            final /* synthetic */ ApolloCall<PublishMonolithSchemaMutation.Data> $call;
                            {
                                this.$call = $call;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$call.execute((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ApolloResponse<PublishMonolithSchemaMutation.Data>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        data = (PublishMonolithSchemaMutation.Data)response2.data;
                        if (data != null) break block10;
                        ApolloException apolloException = response2.exception;
                        Intrinsics.checkNotNull((Object)apolloException);
                        e = apolloException;
                        if (!(e instanceof ApolloHttpException)) break block11;
                        object = ((ApolloHttpException)e).getBody();
                        if (object == null) break block12;
                        item$iv$iv = (Closeable)object;
                        object2 = null;
                        try {
                            BufferedSource it = (BufferedSource)item$iv$iv;
                            boolean bl = false;
                            string = it.readUtf8();
                        }
                        catch (Throwable throwable) {
                            try {
                                object2 = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                CloseableKt.closeFinally((Closeable)item$iv$iv, object2);
                                throw throwable2;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)item$iv$iv, (Throwable)object2);
                        String string2 = string;
                        object = string2;
                        if (string2 != null) break block14;
                    }
                    object = "";
                }
                Object body = object;
                throw new Exception("Cannot upload schema: (code: " + ((ApolloHttpException)e).getStatusCode() + ")\n" + (String)body, (Throwable)e);
            }
            if (e instanceof ApolloGraphQLException) {
                throw new Exception("Cannot upload schema: " + CollectionsKt.joinToString$default((Iterable)((ApolloGraphQLException)e).getErrors(), null, null, null, (int)0, null, (Function1)publishMonolithSchema.1.INSTANCE, (int)31, null));
            }
            throw new Exception("Cannot upload schema: " + e.getMessage(), (Throwable)e);
        }
        Object object = data.getGraph();
        String code = object != null && (object = ((PublishMonolithSchemaMutation.Graph)object).getUploadSchema()) != null ? ((PublishMonolithSchemaMutation.UploadSchema)object).getCode() : null;
        Object object3 = data.getGraph();
        String message = object3 != null && (object3 = ((PublishMonolithSchemaMutation.Graph)object3).getUploadSchema()) != null ? ((PublishMonolithSchemaMutation.UploadSchema)object3).getMessage() : null;
        Object object4 = data.getGraph();
        Boolean bl = object4 != null && (object4 = ((PublishMonolithSchemaMutation.Graph)object4).getUploadSchema()) != null ? Boolean.valueOf(((PublishMonolithSchemaMutation.UploadSchema)object4).getSuccess()) : (success = null);
        if (!Intrinsics.areEqual((Object)success, (Object)true)) {
            boolean bl2 = false;
            String string = "Cannot upload schema (code: " + code + "): " + message;
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void publishSubgraphSchema(ApolloClient apolloClient, String graphID, String variant, String sdl, String subgraph, String revision, Map<String, String> headers) {
        PublishSubgraphSchemaMutation.Data data;
        block10: {
            ApolloException e;
            block11: {
                Object object;
                block14: {
                    block12: {
                        String string;
                        Object object2;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String string2 = revision;
                        Intrinsics.checkNotNull((Object)string2);
                        Object object3 = string2;
                        PublishSubgraphSchemaMutation publishSubgraphSchemaMutation = new PublishSubgraphSchemaMutation(graphID, variant, subgraph, sdl, (String)object3);
                        object3 = headers;
                        ApolloCall apolloCall = apolloClient.mutation((Mutation)publishSubgraphSchemaMutation);
                        boolean $i$f$map = false;
                        void var11_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                            void it;
                            object2 = item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
                        }
                        ApolloCall call = apolloCall.httpHeaders((List)destination$iv$iv);
                        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<PublishSubgraphSchemaMutation.Data>>, Object>((ApolloCall<PublishSubgraphSchemaMutation.Data>)call, null){
                            int label;
                            final /* synthetic */ ApolloCall<PublishSubgraphSchemaMutation.Data> $call;
                            {
                                this.$call = $call;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$call.execute((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ApolloResponse<PublishSubgraphSchemaMutation.Data>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        data = (PublishSubgraphSchemaMutation.Data)response2.data;
                        if (data != null) break block10;
                        ApolloException apolloException = response2.exception;
                        Intrinsics.checkNotNull((Object)apolloException);
                        e = apolloException;
                        if (!(e instanceof ApolloHttpException)) break block11;
                        object = ((ApolloHttpException)e).getBody();
                        if (object == null) break block12;
                        Closeable closeable = (Closeable)object;
                        object2 = null;
                        try {
                            BufferedSource it = (BufferedSource)closeable;
                            boolean bl = false;
                            string = it.readUtf8();
                        }
                        catch (Throwable throwable) {
                            try {
                                object2 = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                CloseableKt.closeFinally((Closeable)closeable, object2);
                                throw throwable2;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                        String string3 = string;
                        object = string3;
                        if (string3 != null) break block14;
                    }
                    object = "";
                }
                Object body = object;
                throw new Exception("Cannot upload schema: (code: " + ((ApolloHttpException)e).getStatusCode() + ")\n" + (String)body, (Throwable)e);
            }
            if (e instanceof ApolloGraphQLException) {
                throw new Exception("Cannot upload schema: " + CollectionsKt.joinToString$default((Iterable)((ApolloGraphQLException)e).getErrors(), null, null, null, (int)0, null, (Function1)publishSubgraphSchema.1.INSTANCE, (int)31, null));
            }
            throw new Exception("Cannot upload schema: " + e.getMessage(), (Throwable)e);
        }
        Object object = data.getGraph();
        String errors2 = object != null && (object = ((PublishSubgraphSchemaMutation.Graph)object).getPublishSubgraph()) != null && (object = ((PublishSubgraphSchemaMutation.PublishSubgraph)object).getErrors()) != null && (object = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, (Function1)publishSubgraphSchema.errors.1.INSTANCE, (int)30, null) : null;
        CharSequence charSequence = errors2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            boolean bl = false;
            String string = "Cannot upload schema:\n" + errors2;
            throw new IllegalStateException(string.toString());
        }
    }
}

