/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.tooling;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.ast.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.ast.introspection.Schema_to_introspectionKt;
import com.apollographql.apollo3.network.OkHttpExtensionsKt;
import com.apollographql.apollo3.tooling.SchemaDownloader;
import com.apollographql.apollo3.tooling.SchemaDownloaderKt;
import com.apollographql.apollo3.tooling.SchemaHelper;
import com.apollographql.apollo3.tooling.graphql.draft.IntrospectionQuery;
import com.apollographql.apollo3.tooling.platformapi.public.DownloadSchemaQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.OkHttpClient;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0010J2\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013JD\u0010\u0014\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\u0006\b\u0000\u0010\u0017\u0018\u0001*\u0004\u0018\u00010\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/apollographql/apollo3/tooling/SchemaDownloader;", "", "()V", "download", "", "endpoint", "", "graph", "key", "graphVariant", "registryUrl", "schema", "Ljava/io/File;", "insecure", "", "headers", "", "downloadIntrospection", "specVersion", "Lcom/apollographql/apollo3/tooling/SchemaDownloader$SpecVersion;", "downloadRegistry", "variant", "cast", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "SpecVersion", "apollo-tooling"})
@ApolloExperimental
public final class SchemaDownloader {
    @NotNull
    public static final SchemaDownloader INSTANCE = new SchemaDownloader();

    private SchemaDownloader() {
    }

    public final void download(@Nullable String endpoint, @Nullable String graph, @Nullable String key, @NotNull String graphVariant, @NotNull String registryUrl, @NotNull File schema, boolean insecure, @NotNull Map<String, String> headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)graphVariant, (String)"graphVariant");
        Intrinsics.checkNotNullParameter((Object)registryUrl, (String)"registryUrl");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String introspectionSchemaJson = null;
        IntrospectionSchema introspectionSchema = null;
        String sdlSchema = null;
        if (endpoint != null) {
            Exception exception = null;
            object = ArraysKt.reversed((Object[])SpecVersion.values());
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                SpecVersion specVersion = (SpecVersion)((Object)object.get(i));
                try {
                    introspectionSchemaJson = this.downloadIntrospection(endpoint, headers, insecure, specVersion);
                    introspectionSchema = IntrospectionSchemaKt.toIntrospectionSchema((String)introspectionSchemaJson);
                    exception = null;
                    break;
                }
                catch (Exception e) {
                    exception = e;
                    continue;
                }
            }
            if (introspectionSchemaJson == null) {
                Exception exception2 = exception;
                Intrinsics.checkNotNull(exception2);
                throw exception2;
            }
        } else {
            String graph2;
            if (!(key != null)) {
                boolean bl = false;
                String string = "Apollo: either endpoint (for introspection) or key (for registry) is required";
                throw new IllegalStateException(string.toString());
            }
            String string = graph;
            if (string == null) {
                string = SchemaDownloaderKt.getGraph(key);
            }
            if (!((graph2 = string) != null)) {
                boolean bl = false;
                String string2 = "Apollo: graph is required to download from the registry";
                throw new IllegalStateException(string2.toString());
            }
            sdlSchema = this.downloadRegistry(key, graph2, graphVariant, registryUrl, headers, insecure);
        }
        File file = schema.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        String string = FilesKt.getExtension((File)schema).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)string, (Object)"json")) {
            if (introspectionSchema == null) {
                if (!(sdlSchema != null)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                IntrospectionSchemaKt.writeTo((IntrospectionSchema)Schema_to_introspectionKt.toIntrospectionSchema((Schema)ApolloParser.toSchema$default((BufferedSource)((BufferedSource)new Buffer().writeUtf8(sdlSchema)), null, (int)1, null)), (File)schema);
            } else {
                if (!(introspectionSchemaJson != null)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                FilesKt.writeText$default((File)schema, (String)introspectionSchemaJson, null, (int)2, null);
            }
        } else if (sdlSchema == null) {
            if (!(introspectionSchema != null)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            FilesKt.writeText$default((File)schema, (String)GqlnodeKt.toUtf8((GQLNode)((GQLNode)Introspection_to_schemaKt.toGQLDocument$default((IntrospectionSchema)introspectionSchema, null, (int)1, null)), (String)"  "), null, (int)2, null);
        } else {
            FilesKt.writeText$default((File)schema, (String)sdlSchema, null, (int)2, null);
        }
    }

    public static /* synthetic */ void download$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, String string5, File file, boolean bl, Map map, int n, Object object) {
        if ((n & 0x10) != 0) {
            string5 = "https://api.apollographql.com/graphql";
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        schemaDownloader.download(string, string2, string3, string4, string5, file, bl, map);
    }

    @NotNull
    public final String downloadIntrospection(@NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure, @NotNull SpecVersion specVersion) {
        Query query;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)((Object)specVersion), (String)"specVersion");
        switch (WhenMappings.$EnumSwitchMapping$0[specVersion.ordinal()]) {
            case 1: {
                query = new com.apollographql.apollo3.tooling.graphql.june2018.IntrospectionQuery();
                break;
            }
            case 2: {
                query = new com.apollographql.apollo3.tooling.graphql.october2021.IntrospectionQuery();
                break;
            }
            case 3: {
                query = new IntrospectionQuery();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return SchemaHelper.INSTANCE.executeSchemaQuery$apollo_tooling(query, endpoint, headers, insecure);
    }

    @NotNull
    public final String downloadRegistry(@NotNull String key, @NotNull String graph, @NotNull String variant, @NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure) {
        String document;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        ApolloClient apolloClient = OkHttpExtensionsKt.okHttpClient((ApolloClient.Builder)new ApolloClient.Builder().serverUrl(endpoint), (OkHttpClient)SchemaHelper.INSTANCE.newOkHttpClient$apollo_tooling(insecure)).build();
        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<DownloadSchemaQuery.Data>>, Object>(apolloClient, graph, variant, headers, key, null){
            int label;
            final /* synthetic */ ApolloClient $apolloClient;
            final /* synthetic */ String $graph;
            final /* synthetic */ String $variant;
            final /* synthetic */ Map<String, String> $headers;
            final /* synthetic */ String $key;
            {
                this.$apolloClient = $apolloClient;
                this.$graph = $graph;
                this.$variant = $variant;
                this.$headers = $headers;
                this.$key = $key;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Map<String, String> map = this.$headers;
                        ApolloCall apolloCall = this.$apolloClient.query((Query)new DownloadSchemaQuery(this.$graph, this.$variant));
                        boolean $i$f$map = false;
                        void var4_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            Map.Entry<K, V> item$iv$iv;
                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
                        }
                        this.label = 1;
                        Object object3 = apolloCall.httpHeaders(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new HttpHeader("x-api-key", this.$key))).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ApolloResponse<DownloadSchemaQuery.Data>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!(!response2.hasErrors())) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Cannot retrieve document from ").append(endpoint).append(": ");
            List list = response2.errors;
            Intrinsics.checkNotNull((Object)list);
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)downloadRegistry.1.1.INSTANCE, (int)31, null)).append("\nCheck graph id and variant").toString();
            throw new IllegalStateException(string.toString());
        }
        Object object = (DownloadSchemaQuery.Data)response2.data;
        String string = document = object != null && (object = ((DownloadSchemaQuery.Data)object).getGraph()) != null && (object = ((DownloadSchemaQuery.Graph)object).getVariant()) != null && (object = ((DownloadSchemaQuery.Variant)object).getLatestPublication()) != null && (object = ((DownloadSchemaQuery.LatestPublication)object).getSchema()) != null ? ((DownloadSchemaQuery.Schema)object).getDocument() : null;
        if (!(document != null)) {
            boolean bl = false;
            String string2 = "Cannot retrieve document from " + endpoint + "\nCheck graph id and variant";
            throw new IllegalStateException(string2.toString());
        }
        return document;
    }

    public static /* synthetic */ String downloadRegistry$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "https://api.apollographql.com/graphql";
        }
        return schemaDownloader.downloadRegistry(string, string2, string3, string4, map, bl);
    }

    public final /* synthetic */ <T> T cast(Object $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$cast;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/tooling/SchemaDownloader$SpecVersion;", "", "(Ljava/lang/String;I)V", "June_2018", "October_2021", "Draft", "apollo-tooling"})
    public static final class SpecVersion
    extends Enum<SpecVersion> {
        public static final /* enum */ SpecVersion June_2018 = new SpecVersion();
        public static final /* enum */ SpecVersion October_2021 = new SpecVersion();
        public static final /* enum */ SpecVersion Draft = new SpecVersion();
        private static final /* synthetic */ SpecVersion[] $VALUES;

        public static SpecVersion[] values() {
            return (SpecVersion[])$VALUES.clone();
        }

        public static SpecVersion valueOf(String value) {
            return Enum.valueOf(SpecVersion.class, value);
        }

        static {
            $VALUES = specVersionArray = new SpecVersion[]{SpecVersion.June_2018, SpecVersion.October_2021, SpecVersion.Draft};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpecVersion.values().length];
            try {
                nArray[SpecVersion.June_2018.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecVersion.October_2021.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecVersion.Draft.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

