/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.tooling;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.ast.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.ast.introspection.Schema_to_introspectionKt;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.tooling.SchemaDownloaderKt;
import com.apollographql.apollo3.tooling.SchemaHelper;
import java.io.Closeable;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jf\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011J*\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fJD\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0006\b\u0000\u0010\u0016\u0018\u0001*\u0004\u0018\u00010\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/tooling/SchemaDownloader;", "", "()V", "introspectionQuery", "", "download", "", "endpoint", "graph", "key", "graphVariant", "registryUrl", "schema", "Ljava/io/File;", "insecure", "", "headers", "", "downloadIntrospection", "downloadRegistry", "variant", "cast", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "apollo-tooling"})
@ApolloExperimental
public final class SchemaDownloader {
    @NotNull
    public static final SchemaDownloader INSTANCE = new SchemaDownloader();
    @NotNull
    private static final String introspectionQuery = StringsKt.trimIndent((String)"\n    query IntrospectionQuery {\n      __schema {\n        queryType { name }\n        mutationType { name }\n        subscriptionType { name }\n        types {\n          ...FullType\n        }\n        directives {\n          name\n          description\n          locations\n          args {\n            ...InputValue\n          }\n        }\n      }\n    }\n\n    fragment FullType on __Type {\n      kind\n      name\n      description\n      fields(includeDeprecated: true) {\n        name\n        description\n        args {\n          ...InputValue\n        }\n        type {\n          ...TypeRef\n        }\n        isDeprecated\n        deprecationReason\n      }\n      inputFields {\n        ...InputValue\n      }\n      interfaces {\n        ...TypeRef\n      }\n      enumValues(includeDeprecated: true) {\n        name\n        description\n        isDeprecated\n        deprecationReason\n      }\n      possibleTypes {\n        ...TypeRef\n      }\n    }\n\n    fragment InputValue on __InputValue {\n      name\n      description\n      type { ...TypeRef }\n      defaultValue\n    }\n\n    fragment TypeRef on __Type {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                  ofType {\n                    kind\n                    name\n                  }\n                }\n              }\n            }\n          }\n        }\n      }\n    }");

    private SchemaDownloader() {
    }

    /*
     * WARNING - void declaration
     */
    public final void download(@Nullable String endpoint, @Nullable String graph, @Nullable String key, @NotNull String graphVariant, @NotNull String registryUrl, @NotNull File schema, boolean insecure, @NotNull Map<String, String> headers) {
        String graph2;
        Intrinsics.checkNotNullParameter((Object)graphVariant, (String)"graphVariant");
        Intrinsics.checkNotNullParameter((Object)registryUrl, (String)"registryUrl");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String introspectionSchemaJson = null;
        IntrospectionSchema introspectionSchema = null;
        GQLDocument gqlSchema = null;
        if (endpoint != null) {
            introspectionSchemaJson = this.downloadIntrospection(endpoint, headers, insecure);
            introspectionSchema = IntrospectionSchemaKt.toIntrospectionSchema((String)introspectionSchemaJson);
        } else {
            if (!(key != null)) {
                boolean $i$a$-check-SchemaDownloader$download$32 = false;
                String $i$a$-check-SchemaDownloader$download$32 = "Apollo: either endpoint (for introspection) or key (for registry) is required";
                throw new IllegalStateException($i$a$-check-SchemaDownloader$download$32.toString());
            }
            String string = graph;
            if (string == null) {
                string = SchemaDownloaderKt.getGraph(key);
            }
            if (!((graph2 = string) != null)) {
                boolean $i$a$-check-SchemaDownloader$download$42 = false;
                String $i$a$-check-SchemaDownloader$download$42 = "Apollo: graph is required to download from the registry";
                throw new IllegalStateException($i$a$-check-SchemaDownloader$download$42.toString());
            }
            String it = this.downloadRegistry(key, graph2, graphVariant, registryUrl, headers, insecure);
            boolean bl = false;
            gqlSchema = (GQLDocument)ApolloParser.parseAsGQLDocument$default((BufferedSource)((BufferedSource)new Buffer().writeUtf8(it)), null, (int)1, null).valueAssertNoErrors();
        }
        File file = schema.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        String string = FilesKt.getExtension((File)schema).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)string, (Object)"json")) {
            if (introspectionSchema == null) {
                void $this$toJson$iv;
                GQLDocument gQLDocument = gqlSchema;
                Intrinsics.checkNotNull(gQLDocument);
                introspectionSchema = Schema_to_introspectionKt.toIntrospectionSchema((Schema)((Schema)ApolloParser.validateAsSchema(gQLDocument).valueAssertNoErrors()));
                graph2 = introspectionSchema;
                String indent$iv = "  ";
                boolean $i$f$toJson = false;
                boolean $i$f$getJsonAdapter = false;
                String string2 = MoshiKt.getMOSHI().adapter(IntrospectionSchema.class).indent(indent$iv).toJson((Object)$this$toJson$iv);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
                FilesKt.writeText$default((File)schema, (String)string2, null, (int)2, null);
            } else {
                String string3 = introspectionSchemaJson;
                Intrinsics.checkNotNull((Object)string3);
                FilesKt.writeText$default((File)schema, (String)string3, null, (int)2, null);
            }
        } else {
            if (gqlSchema == null) {
                IntrospectionSchema introspectionSchema2 = introspectionSchema;
                Intrinsics.checkNotNull((Object)introspectionSchema2);
                gqlSchema = Introspection_to_schemaKt.toGQLDocument$default((IntrospectionSchema)introspectionSchema2, null, (int)1, null);
            }
            FilesKt.writeText$default((File)schema, (String)GqlnodeKt.toUtf8((GQLNode)((GQLNode)gqlSchema), (String)"  "), null, (int)2, null);
        }
    }

    public static /* synthetic */ void download$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, String string5, File file, boolean bl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = "current";
        }
        if ((n & 0x10) != 0) {
            string5 = "https://graphql.api.apollographql.com/api/graphql";
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        schemaDownloader.download(string, string2, string3, string4, string5, file, bl, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String downloadIntrospection(@NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure) {
        String string;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query", (Object)introspectionQuery), TuplesKt.to((Object)"operationName", (Object)"IntrospectionQuery")};
        Map body = MapsKt.mapOf((Pair[])pairArray);
        Response response = SchemaHelper.INSTANCE.executeQuery$apollo_tooling(body, endpoint, headers, insecure);
        Closeable closeable = (Closeable)response.body();
        Throwable throwable = null;
        try {
            ResponseBody responseBody = (ResponseBody)closeable;
            boolean bl = false;
            ResponseBody responseBody2 = responseBody;
            Intrinsics.checkNotNull((Object)responseBody2);
            string = responseBody2.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final String downloadRegistry(@NotNull String key, @NotNull String graph, @NotNull String variant, @NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        query = StringsKt.trimIndent((String)"\n    query DownloadSchema($graphID: ID!, $variant: String!) {\n      service(id: $graphID) {\n        variant(name: $variant) {\n          activeSchemaPublish {\n            schema {\n              document\n            }\n          }\n        }\n      }\n    }\n  ");
        var9_8 = new Pair[]{TuplesKt.to((Object)"graphID", (Object)graph), TuplesKt.to((Object)"variant", (Object)variant)};
        variables = MapsKt.mapOf((Pair[])var9_8);
        response = SchemaHelper.INSTANCE.executeQuery$apollo_tooling(query, variables, endpoint, MapsKt.plus(headers, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)key))), insecure);
        var11_10 = (Closeable)response.body();
        var12_11 = null;
        try {
            it = (ResponseBody)var11_10;
            $i$a$-use-SchemaDownloader$downloadRegistry$responseString$1 = false;
            v0 = it;
            it = v0 != null ? v0.string() : null;
        }
        catch (Throwable it) {
            var12_11 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var11_10, (Throwable)var12_11);
        }
        responseString /* !! */  = it;
        var12_11 = this;
        $i$a$-use-SchemaDownloader$downloadRegistry$responseString$1 = this;
        var16_21 = this;
        var18_23 = this;
        var20_25 = this;
        var22_27 = this;
        if (responseString /* !! */  == null) ** GOTO lbl-1000
        var24_29 /* !! */  = responseString /* !! */ ;
        $i$f$fromJson = false;
        $i$f$getJsonAdapter = false;
        v1 = MoshiKt.getMOSHI().adapter(Map.class).fromJson((String)$this$fromJson$iv);
        Intrinsics.checkNotNull((Object)v1);
        var23_33 = (Map)v1;
        if (var23_33 != null) {
            v2 /* !! */  = var23_33.get("data");
        } else lbl-1000:
        // 2 sources

        {
            v2 /* !! */  = null;
        }
        var23_33 = v2 /* !! */ ;
        $i$f$cast = false;
        v3 = $this$cast$iv;
        if (!(v3 instanceof Map)) {
            v3 = null;
        }
        $this$cast$iv = (var21_34 = (Map)v3) != null ? var21_34.get("service") : null;
        $i$f$cast = false;
        v4 = $this$cast$iv;
        if (!(v4 instanceof Map)) {
            v4 = null;
        }
        $this$cast$iv = (var19_35 = (Map)v4) != null ? var19_35.get("variant") : null;
        $i$f$cast = false;
        v5 = $this$cast$iv;
        if (!(v5 instanceof Map)) {
            v5 = null;
        }
        $this$cast$iv = (var17_36 = (Map)v5) != null ? var17_36.get("activeSchemaPublish") : null;
        $i$f$cast = false;
        v6 = $this$cast$iv;
        if (!(v6 instanceof Map)) {
            v6 = null;
        }
        $this$cast$iv = (var15_37 = (Map)v6) != null ? var15_37.get("schema") : null;
        $i$f$cast = false;
        v7 = $this$cast$iv;
        if (!(v7 instanceof Map)) {
            v7 = null;
        }
        $this$cast$iv = (it = (Map)v7) != null ? it.get("document") : null;
        $i$f$cast = false;
        v8 = $this$cast$iv;
        if (!(v8 instanceof String)) {
            v8 = null;
        }
        if (!((document = (String)v8) != null)) {
            $i$a$-check-SchemaDownloader$downloadRegistry$1 = false;
            var13_16 = "Cannot retrieve document from " + (String)responseString /* !! */  + "\nCheck graph id and variant";
            throw new IllegalStateException(var13_16.toString());
        }
        return document;
    }

    public static /* synthetic */ String downloadRegistry$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "https://graphql.api.apollographql.com/api/graphql";
        }
        return schemaDownloader.downloadRegistry(string, string2, string3, string4, map, bl);
    }

    public final /* synthetic */ <T> T cast(Object $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$cast;
    }
}

