/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.testing;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.testing.TestResponse;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\n\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ,\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000f0\u0012\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\f0\u0014H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/testing/QueueTestNetworkTransport;", "Lcom/apollographql/apollo3/network/NetworkTransport;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/apollographql/apollo3/testing/TestResponse;", "dispose", "", "enqueue", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "response", "Lcom/apollographql/apollo3/api/ApolloResponse;", "enqueueNetworkError", "execute", "Lkotlinx/coroutines/flow/Flow;", "request", "Lcom/apollographql/apollo3/api/ApolloRequest;", "apollo-testing-support"})
@ApolloExperimental
public final class QueueTestNetworkTransport
implements NetworkTransport {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final ArrayDeque<TestResponse> queue = new ArrayDeque();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> execute(@NotNull ApolloRequest<D> request) {
        TestResponse testResponse;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            TestResponse testResponse2 = (TestResponse)this.queue.removeFirstOrNull();
            testResponse = testResponse2;
        }
        finally {
            reentrantLock.unlock();
        }
        if (testResponse == null) {
            throw new IllegalStateException("No more responses in queue".toString());
        }
        TestResponse response = testResponse;
        if (response instanceof TestResponse.NetworkError) {
            throw new ApolloNetworkException("Network error queued in QueueTestNetworkTransport", null, 2, null);
        }
        return FlowKt.flowOf(((TestResponse.Response)response).getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void enqueue(@NotNull ApolloResponse<D> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.queue.add((Object)new TestResponse.Response(response));
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueNetworkError() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.queue.add((Object)TestResponse.NetworkError.INSTANCE);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void dispose() {
    }
}

