/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.testing;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.testing.TestResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u000e\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0016J,\u0010\u0013\u001a\u00020\f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000fJ\u001e\u0010\u0016\u001a\u00020\f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\bR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/testing/MapTestNetworkTransport;", "Lcom/apollographql/apollo3/network/NetworkTransport;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "operationsToResponses", "", "Lcom/apollographql/apollo3/api/Operation;", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/testing/TestResponse;", "dispose", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "request", "Lcom/apollographql/apollo3/api/ApolloRequest;", "register", "operation", "response", "registerNetworkError", "apollo-testing-support"})
@ApolloExperimental
public final class MapTestNetworkTransport
implements NetworkTransport {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final Map<Operation<? extends Operation.Data>, TestResponse> operationsToResponses = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> execute(@NotNull ApolloRequest<D> request) {
        TestResponse testResponse;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            testResponse = this.operationsToResponses.get(request.getOperation());
        }
        finally {
            reentrantLock.unlock();
        }
        TestResponse testResponse2 = testResponse;
        if (testResponse2 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"No response registered for operation ", (Object)request.getOperation()).toString());
        }
        TestResponse response = testResponse2;
        if (response instanceof TestResponse.NetworkError) {
            throw new ApolloNetworkException("Network error queued in QueueTestNetworkTransport", null, 2, null);
        }
        return FlowKt.flowOf(((TestResponse.Response)response).getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void register(@NotNull Operation<D> operation, @NotNull ApolloResponse<D> response) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            Unit unit = this.operationsToResponses;
            TestResponse.Response response2 = new TestResponse.Response(response);
            unit.put(operation, (TestResponse)response2);
            unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void registerNetworkError(@NotNull Operation<D> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            Unit unit = this.operationsToResponses;
            TestResponse.NetworkError networkError = TestResponse.NetworkError.INSTANCE;
            unit.put(operation, (TestResponse)networkError);
            unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void dispose() {
    }
}

