/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.testing;

import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.testing.ReadFileJvmKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"checkFile", "", "actualText", "", "path", "pathToJsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "pathToUtf8", "toTestsPath", "Lokio/Path;", "apollo-testing-support"})
@JvmName(name="-FileSystemCommon")
public final class -FileSystemCommon {
    public static final void checkFile(@NotNull String actualText, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean updateTestFixtures = ReadFileJvmKt.shouldUpdateTestFixtures();
        Path expected = -FileSystemCommon.toTestsPath(path);
        try {
            string = Okio.buffer((Source)FileHandle.source$default((FileHandle)ReadFileJvmKt.getHostFileSystem().openReadOnly(expected), (long)0L, (int)1, null)).readUtf8();
        }
        catch (IOException e) {
            if (!updateTestFixtures) {
                throw e;
            }
            System.out.println((Object)Intrinsics.stringPlus((String)path, (Object)" is not found"));
            string = "";
        }
        String expectedText = string;
        if (!Intrinsics.areEqual((Object)actualText, (Object)expectedText)) {
            if (updateTestFixtures) {
                Okio.buffer((Sink)FileHandle.sink$default((FileHandle)ReadFileJvmKt.getHostFileSystem().openReadWrite(expected), (long)0L, (int)1, null)).writeUtf8(actualText);
            } else {
                throw new Exception(StringsKt.trimMargin$default((String)("generatedText doesn't match the expectedText.\n      |If you changed the compiler recently, you need to update the testFixtures.\n      |Run the tests with `-DupdateTestFixtures=true` to do so.\n      |generatedText: " + actualText + "\n      |expectedText : " + expectedText), null, (int)1, null));
            }
        }
    }

    private static final Path toTestsPath(String $this$toTestsPath) {
        return Path.resolve$default((Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)ReadFileJvmKt.getTestsPath(), (boolean)false, (int)1, null), (Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)$this$toTestsPath, (boolean)false, (int)1, null), (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String pathToUtf8(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Okio.buffer((Source)FileHandle.source$default((FileHandle)ReadFileJvmKt.getHostFileSystem().openReadOnly(-FileSystemCommon.toTestsPath(path)), (long)0L, (int)1, null)).readUtf8();
    }

    @NotNull
    public static final JsonReader pathToJsonReader(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return -JsonReaders.jsonReader((BufferedSource)Okio.buffer((Source)FileHandle.source$default((FileHandle)ReadFileJvmKt.getHostFileSystem().openReadOnly(-FileSystemCommon.toTestsPath(path)), (long)0L, (int)1, null)));
    }
}

