/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.rx3;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloPrefetch;
import com.apollographql.apollo3.ApolloQueryWatcher;
import com.apollographql.apollo3.ApolloSubscriptionCall;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Response;
import com.apollographql.apollo3.api.internal.Utils;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionTerminatedException;
import com.apollographql.apollo3.internal.util.Cancelable;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableOnSubscribe;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import org.jetbrains.annotations.NotNull;

public class Rx3Apollo {
    private Rx3Apollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Observable<Response<D>> from(final @NotNull ApolloQueryWatcher<D> watcher) {
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Response<D>>(){

            public void subscribe(final ObservableEmitter<Response<D>> emitter) throws Exception {
                ApolloQueryWatcher clone = watcher.clone();
                Rx3Apollo.cancelOnObservableDisposed(emitter, (Cancelable)clone);
                clone.enqueueAndWatch(new ApolloCall.Callback<D>(){

                    public void onResponse(@NotNull Response<D> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Observable<Response<D>> from(final @NotNull ApolloCall<D> call) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Response<D>>(){

            public void subscribe(final ObservableEmitter<Response<D>> emitter) throws Exception {
                ApolloCall clone = call.clone();
                Rx3Apollo.cancelOnObservableDisposed(emitter, (Cancelable)clone);
                clone.enqueue(new ApolloCall.Callback<D>(){

                    public void onResponse(@NotNull Response<D> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                        if (event == ApolloCall.StatusEvent.COMPLETED && !emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static Completable from(final @NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final CompletableEmitter emitter) {
                ApolloPrefetch clone = prefetch.clone();
                Rx3Apollo.cancelOnCompletableDisposed(emitter, (Cancelable)clone);
                clone.enqueue(new ApolloPrefetch.Callback(){

                    public void onSuccess() {
                        if (!emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Flowable<Response<D>> from(@NotNull ApolloSubscriptionCall<D> call) {
        return Rx3Apollo.from(call, BackpressureStrategy.LATEST);
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Flowable<Response<D>> from(final @NotNull ApolloSubscriptionCall<D> call, @NotNull BackpressureStrategy backpressureStrategy) {
        Utils.checkNotNull(call, (Object)"originalCall == null");
        Utils.checkNotNull((Object)backpressureStrategy, (Object)"backpressureStrategy == null");
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Response<D>>(){

            public void subscribe(final FlowableEmitter<Response<D>> emitter) throws Exception {
                ApolloSubscriptionCall clone = call.clone();
                Rx3Apollo.cancelOnFlowableDisposed(emitter, (Cancelable)clone);
                clone.execute(new ApolloSubscriptionCall.Callback<D>(){

                    public void onResponse(@NotNull Response<D> response) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isCancelled()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onCompleted() {
                        if (!emitter.isCancelled()) {
                            emitter.onComplete();
                        }
                    }

                    public void onTerminated() {
                        this.onFailure((ApolloException)new ApolloSubscriptionTerminatedException("Subscription server unexpectedly terminated connection"));
                    }

                    public void onConnected() {
                    }
                });
            }
        }, (BackpressureStrategy)backpressureStrategy);
    }

    private static void cancelOnCompletableDisposed(CompletableEmitter emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static <T> void cancelOnObservableDisposed(ObservableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static <T> void cancelOnFlowableDisposed(FlowableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static Disposable getRx3Disposable(final Cancelable cancelable) {
        return new Disposable(){

            public void dispose() {
                cancelable.cancel();
            }

            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

