/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.interceptor;

import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo3.api.internal.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.request.RequestHeaders;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ*\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020!H\u0016J\u0016\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J2\u00100\u001a\u00020\u00162\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ2\u00103\u001a\u00020\u00162\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ(\u00104\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010.\u001a\u00020/H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloServerInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "serverUrl", "Lokhttp3/HttpUrl;", "httpCallFactory", "Lokhttp3/Call$Factory;", "cachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "prefetch", "", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lokhttp3/HttpUrl;Lokhttp3/Call$Factory;Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;ZLcom/apollographql/apollo3/api/ResponseAdapterCache;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "disposed", "getDisposed", "()Z", "setDisposed", "(Z)V", "httpCallRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lokhttp3/Call;", "getHttpCallRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "setHttpCallRef", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getPrefetch", "getResponseAdapterCache", "()Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "decorateRequest", "", "requestBuilder", "Lokhttp3/Request$Builder;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "dispose", "executeHttpCall", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "httpGetCall", "writeQueryDocument", "autoPersistQueries", "httpPostCall", "interceptAsync", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "Companion", "apollo-runtime"})
public final class ApolloServerInterceptor
implements ApolloInterceptor {
    @NotNull
    private AtomicReference<Call> httpCallRef;
    private volatile boolean disposed;
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCachePolicy.Policy cachePolicy;
    private final boolean prefetch;
    @NotNull
    private final ResponseAdapterCache responseAdapterCache;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    public static final String HEADER_ACCEPT_TYPE = "Accept";
    @NotNull
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    public static final String JSON_CONTENT_TYPE = "application/json";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AtomicReference<Call> getHttpCallRef() {
        return this.httpCallRef;
    }

    public final void setHttpCallRef(@NotNull AtomicReference<Call> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.httpCallRef = atomicReference;
    }

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        dispatcher.execute(new Runnable(this, request, callBack){
            final /* synthetic */ ApolloServerInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public final void run() {
                this.this$0.executeHttpCall(this.$request, this.$callBack);
            }
            {
                this.this$0 = apolloServerInterceptor;
                this.$request = interceptorRequest;
                this.$callBack = callBack;
            }
        });
    }

    @Override
    public void dispose() {
        block0: {
            Call httpCall;
            this.disposed = true;
            Call call = httpCall = (Call)this.httpCallRef.getAndSet(null);
            if (call == null) break block0;
            call.cancel();
        }
    }

    public final void executeHttpCall(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.CallBack callBack) {
        Call previousCall;
        Call call;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (this.disposed) {
            return;
        }
        callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
        Call httpCall = null;
        try {
            call = request.getUseHttpGetMethodForQueries() && request.getOperation() instanceof Query ? this.httpGetCall(request.getOperation(), request.getCacheHeaders(), request.getRequestHeaders(), request.getSendQueryDocument(), request.getAutoPersistQueries()) : this.httpPostCall(request.getOperation(), request.getCacheHeaders(), request.getRequestHeaders(), request.getSendQueryDocument(), request.getAutoPersistQueries());
        }
        catch (IOException e) {
            this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", new Object[]{request.getOperation().name()});
            callBack.onFailure((ApolloException)new ApolloNetworkException("Failed to prepare http call", (Throwable)e));
            return;
        }
        httpCall = call;
        Call call2 = previousCall = this.httpCallRef.getAndSet(httpCall);
        if (call2 != null) {
            call2.cancel();
        }
        if (httpCall.isCanceled() || this.disposed) {
            this.httpCallRef.compareAndSet(httpCall, null);
            return;
        }
        httpCall.enqueue(new Callback(this, httpCall, request, callBack){
            final /* synthetic */ ApolloServerInterceptor this$0;
            final /* synthetic */ Call $httpCall;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    this.this$0.getLogger().e((Throwable)e, "Failed to execute http call for operation %s", new Object[]{this.$request.getOperation().name()});
                    this.$callBack.onFailure((ApolloException)new ApolloNetworkException("Failed to execute http call", (Throwable)e));
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    this.$callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response, null, 2, null));
                    this.$callBack.onCompleted();
                }
            }
            {
                this.this$0 = this$0;
                this.$httpCall = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$callBack = $captured_local_variable$3;
            }
        });
    }

    @NotNull
    public final Call httpGetCall(@NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Request.Builder requestBuilder;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        Request.Builder builder = requestBuilder = new Request.Builder().url(Companion.httpGetUrl(this.serverUrl, operation, this.responseAdapterCache, writeQueryDocument, autoPersistQueries)).get();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"requestBuilder");
        this.decorateRequest(builder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    @NotNull
    public final Call httpPostCall(@NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Request.Builder requestBuilder;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        OperationRequestBodyComposer.Body body = OperationRequestBodyComposer.compose(operation, (boolean)autoPersistQueries, (boolean)writeQueryDocument, (ResponseAdapterCache)this.responseAdapterCache);
        RequestBody requestBody2 = new RequestBody(body){
            final /* synthetic */ OperationRequestBodyComposer.Body $body;

            @Nullable
            public MediaType contentType() {
                return MediaType.parse((String)this.$body.getContentType());
            }

            public long contentLength() {
                return this.$body.getContentLength();
            }

            public void writeTo(@NotNull BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                this.$body.writeTo(sink);
            }
            {
                this.$body = $captured_local_variable$0;
            }
        };
        Request.Builder builder = requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody2);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"requestBuilder");
        this.decorateRequest(builder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    public final void decorateRequest(@NotNull Request.Builder requestBuilder, @NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        requestBuilder.header(HEADER_ACCEPT_TYPE, JSON_CONTENT_TYPE).header(HEADER_CONTENT_TYPE, JSON_CONTENT_TYPE).header(HEADER_APOLLO_OPERATION_ID, operation.id()).header(HEADER_APOLLO_OPERATION_NAME, operation.name()).tag((Object)operation.id());
        for (String header : requestHeaders.headers()) {
            String value = requestHeaders.headerValue(header);
            requestBuilder.header(header, value);
        }
        if (this.cachePolicy != null) {
            boolean skipCacheHttpResponse = StringsKt.equals((String)"true", (String)cacheHeaders.headerValue("do-not-store"), (boolean)true);
            String cacheKey = Companion.cacheKey(operation, this.responseAdapterCache);
            requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", this.cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(this.cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(this.cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch)).header("X-APOLLO-CACHE-DO-NOT-STORE", Boolean.toString(skipCacheHttpResponse));
        }
    }

    public final boolean getPrefetch() {
        return this.prefetch;
    }

    @NotNull
    public final ResponseAdapterCache getResponseAdapterCache() {
        return this.responseAdapterCache;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    public ApolloServerInterceptor(@NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @NotNull ResponseAdapterCache responseAdapterCache, @NotNull ApolloLogger logger) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)httpCallFactory, (String)"httpCallFactory");
        Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.cachePolicy = cachePolicy;
        this.prefetch = prefetch;
        this.responseAdapterCache = responseAdapterCache;
        this.logger = logger;
        this.httpCallRef = new AtomicReference();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ$\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloServerInterceptor$Companion;", "", "()V", "HEADER_ACCEPT_TYPE", "", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "HEADER_CONTENT_TYPE", "JSON_CONTENT_TYPE", "addExtensionsUrlQueryParameter", "", "urlBuilder", "Lokhttp3/HttpUrl$Builder;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "addVariablesUrlQueryParameter", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "cacheKey", "httpGetUrl", "Lokhttp3/HttpUrl;", "serverUrl", "writeQueryDocument", "", "autoPersistQueries", "apollo-runtime"})
    public static final class Companion {
        @NotNull
        public final String cacheKey(@NotNull Operation<?> operation, @NotNull ResponseAdapterCache responseAdapterCache) throws IOException {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
            return OperationRequestBodyComposer.compose(operation, (boolean)true, (boolean)true, (ResponseAdapterCache)responseAdapterCache).getOperations().md5().hex();
        }

        @NotNull
        public final HttpUrl httpGetUrl(@NotNull HttpUrl serverUrl, @NotNull Operation<?> operation, @Nullable ResponseAdapterCache responseAdapterCache, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
            Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            HttpUrl.Builder urlBuilder = serverUrl.newBuilder();
            if (!autoPersistQueries || writeQueryDocument) {
                urlBuilder.addQueryParameter("query", operation.document());
            }
            HttpUrl.Builder builder = urlBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"urlBuilder");
            this.addVariablesUrlQueryParameter(builder, operation, responseAdapterCache);
            urlBuilder.addQueryParameter("operationName", operation.name());
            if (autoPersistQueries) {
                this.addExtensionsUrlQueryParameter(urlBuilder, operation);
            }
            HttpUrl httpUrl = urlBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"urlBuilder.build()");
            return httpUrl;
        }

        public final void addVariablesUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?> operation, @Nullable ResponseAdapterCache responseAdapterCache) throws IOException {
            Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Buffer buffer = new Buffer();
            BufferedSinkJsonWriter jsonWriter = new BufferedSinkJsonWriter((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.beginObject();
            JsonWriter jsonWriter2 = (JsonWriter)jsonWriter;
            ResponseAdapterCache responseAdapterCache2 = responseAdapterCache;
            Intrinsics.checkNotNull((Object)responseAdapterCache2);
            operation.serializeVariables(jsonWriter2, responseAdapterCache2);
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("variables", buffer.readUtf8());
        }

        public final void addExtensionsUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?> operation) throws IOException {
            Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Buffer buffer = new Buffer();
            BufferedSinkJsonWriter jsonWriter = new BufferedSinkJsonWriter((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.beginObject();
            jsonWriter.name("persistedQuery").beginObject().name("version").value(1).name("sha256Hash").value(operation.id()).endObject();
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("extensions", buffer.readUtf8());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

