/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.fetcher;

import com.apollographql.apollo3.ResponseExtensionsKt;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheOnlyFetcher;", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "()V", "provideInterceptor", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "CacheOnlyInterceptor", "apollo-runtime"})
public final class CacheOnlyFetcher
implements ResponseFetcher {
    @Override
    @NotNull
    public ApolloInterceptor provideInterceptor(@Nullable ApolloLogger logger) {
        return new CacheOnlyInterceptor();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheOnlyFetcher$CacheOnlyInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "()V", "cacheMissResponse", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "dispose", "", "interceptAsync", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "apollo-runtime"})
    private static final class CacheOnlyInterceptor
    implements ApolloInterceptor {
        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(this, callBack, request){
                final /* synthetic */ CacheOnlyInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$callBack.onResponse(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$callBack.onResponse(this.this$0.cacheMissResponse(this.$request.getOperation()));
                    this.$callBack.onCompleted();
                }

                public void onCompleted() {
                    this.$callBack.onCompleted();
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
                {
                    this.this$0 = this$0;
                    this.$callBack = $captured_local_variable$1;
                    this.$request = $captured_local_variable$2;
                }
            });
        }

        @Override
        public void dispose() {
        }

        @NotNull
        public final ApolloInterceptor.InterceptorResponse cacheMissResponse(@Nullable Operation<?> operation) {
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            Operation<?> operation2 = operation;
            Intrinsics.checkNotNull(operation2);
            return new ApolloInterceptor.InterceptorResponse(null, ResponseExtensionsKt.withCacheInfo(new ApolloResponse(uUID, operation2, null, null, null, null, 56, null), true));
        }
    }
}

