/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.interceptor;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ResponseExtensionsKt;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.cache.normalized.internal.ReadMode;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloGenericException;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.internal.interceptor.ApolloCacheInterceptor;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000eJ\u0018\u0010#\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020!H\u0016J(\u0010%\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\u00020!2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aJ\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u000eJ\u0010\u0010/\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloCacheInterceptor;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "responseCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloCall$Callback;", "writeToCacheAsynchronously", "", "(Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Ljava/util/concurrent/atomic/AtomicReference;Z)V", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "disposed", "getDisposed", "()Z", "setDisposed", "(Z)V", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "cacheResponse", "", "", "networkResponse", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "cacheResponseAndPublish", "", "async", "cacheResponseAndPublishSynchronously", "dispose", "interceptAsync", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "publishCacheKeys", "cacheKeys", "resolveFromCache", "rollbackOptimisticUpdates", "publish", "writeOptimisticUpdatesAndPublish", "apollo-runtime"})
public final class ApolloCacheInterceptor<D extends Operation.Data>
implements ApolloInterceptor {
    private volatile boolean disposed;
    @NotNull
    private final ApolloStore apolloStore;
    private final Executor dispatcher;
    @NotNull
    private final ApolloLogger logger;
    private final AtomicReference<ApolloCall.Callback<D>> responseCallback;
    private final boolean writeToCacheAsynchronously;

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        dispatcher.execute(new Runnable(this, request, callBack, chain, dispatcher){
            final /* synthetic */ ApolloCacheInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;
            final /* synthetic */ ApolloInterceptorChain $chain;
            final /* synthetic */ Executor $dispatcher;

            public final void run() {
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.$request.getFetchFromCache()) {
                    this.$callBack.onFetch(ApolloInterceptor.FetchSourceType.CACHE);
                    ApolloInterceptor.InterceptorResponse cachedResponse = null;
                    try {
                        cachedResponse = this.this$0.resolveFromCache(this.$request);
                        this.$callBack.onResponse(cachedResponse);
                        this.$callBack.onCompleted();
                    }
                    catch (ApolloException e) {
                        this.$callBack.onFailure(e);
                    }
                } else {
                    ApolloCacheInterceptor.access$writeOptimisticUpdatesAndPublish(this.this$0, this.$request);
                    this.$chain.proceedAsync(this.$request, this.$dispatcher, new ApolloInterceptor.CallBack(this){
                        final /* synthetic */ interceptAsync.1 this$0;

                        public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            if (this.this$0.this$0.getDisposed()) {
                                return;
                            }
                            this.this$0.this$0.cacheResponseAndPublish(this.this$0.$request, response, ApolloCacheInterceptor.access$getWriteToCacheAsynchronously$p(this.this$0.this$0));
                            this.this$0.$callBack.onResponse(response);
                            this.this$0.$callBack.onCompleted();
                        }

                        public void onFailure(@NotNull ApolloException e) {
                            Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                            this.this$0.this$0.rollbackOptimisticUpdates(this.this$0.$request, true);
                            this.this$0.$callBack.onFailure(e);
                        }

                        public void onCompleted() {
                        }

                        public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                            Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                            this.this$0.$callBack.onFetch(sourceType);
                        }
                        {
                            this.this$0 = this$0;
                        }
                    });
                }
            }
            {
                this.this$0 = apolloCacheInterceptor;
                this.$request = interceptorRequest;
                this.$callBack = callBack;
                this.$chain = apolloInterceptorChain;
                this.$dispatcher = executor;
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @NotNull
    public final ApolloInterceptor.InterceptorResponse resolveFromCache(@NotNull ApolloInterceptor.InterceptorRequest request) throws ApolloException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Operation.Data data = this.apolloStore.readOperation(request.getOperation(), request.getCacheHeaders(), ReadMode.BATCH);
        if (data != null) {
            this.logger.d("Cache HIT for operation %s", new Object[]{request.getOperation().name()});
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            return new ApolloInterceptor.InterceptorResponse(null, ResponseExtensionsKt.withCacheInfo(new ApolloResponse(uUID, request.getOperation(), data, null, null, null, 56, null), true));
        }
        this.logger.d("Cache MISS for operation %s", new Object[]{request.getOperation().name()});
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Cache miss for operation %s";
        Object[] objectArray = new Object[]{request.getOperation().name()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        throw (Throwable)new ApolloGenericException(string2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse, ApolloInterceptor.InterceptorRequest request) {
        Set set;
        if (networkResponse.parsedResponse.isPresent()) {
            ApolloResponse<?> apolloResponse = networkResponse.parsedResponse.get();
            Intrinsics.checkNotNull(apolloResponse);
            if (apolloResponse.hasErrors() && !request.getCacheHeaders().hasHeader("store-partial-responses")) {
                return SetsKt.emptySet();
            }
        }
        ApolloResponse<?> apolloResponse = networkResponse.parsedResponse.get();
        Intrinsics.checkNotNull(apolloResponse);
        Operation.Data data = apolloResponse.getData();
        if (data != null) {
            Operation<?> operation = request.getOperation();
            if (operation == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.Operation<com.apollographql.apollo3.api.Operation.Data>");
            }
            Pair pair = this.apolloStore.writeOperationWithRecords(operation, data, request.getCacheHeaders(), false);
            Set set2 = (Set)pair.component1();
            Set changedKeys = (Set)pair.component2();
            ApolloCall.Callback<D> callback = this.responseCallback.get();
            if (callback != null) {
                void records;
                callback.onCached(CollectionsKt.toList((Iterable)((Iterable)records)));
            }
            set = changedKeys;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void cacheResponseAndPublish(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.InterceptorResponse networkResponse, boolean async) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)networkResponse, (String)"networkResponse");
        if (async) {
            this.dispatcher.execute(new Runnable(this, request, networkResponse){
                final /* synthetic */ ApolloCacheInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ ApolloInterceptor.InterceptorResponse $networkResponse;

                public final void run() {
                    ApolloCacheInterceptor.access$cacheResponseAndPublishSynchronously(this.this$0, this.$request, this.$networkResponse);
                }
                {
                    this.this$0 = apolloCacheInterceptor;
                    this.$request = interceptorRequest;
                    this.$networkResponse = interceptorResponse;
                }
            });
        } else {
            this.cacheResponseAndPublishSynchronously(request, networkResponse);
        }
    }

    private final void cacheResponseAndPublishSynchronously(ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse networkResponse) {
        try {
            Set<String> networkResponseCacheKeys = this.cacheResponse(networkResponse, request);
            Set<String> rolledBackCacheKeys = this.rollbackOptimisticUpdates(request, false);
            this.publishCacheKeys(SetsKt.plus(rolledBackCacheKeys, (Iterable)networkResponseCacheKeys));
        }
        catch (Exception rethrow) {
            this.rollbackOptimisticUpdates(request, true);
            throw (Throwable)rethrow;
        }
    }

    private final void writeOptimisticUpdatesAndPublish(ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(new Runnable(this, request){
            final /* synthetic */ ApolloCacheInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;

            public final void run() {
                try {
                    if (this.$request.getOptimisticUpdates().isPresent()) {
                        Operation.Data optimisticUpdates = this.$request.getOptimisticUpdates().get();
                        ApolloStore apolloStore = this.this$0.getApolloStore();
                        Operation<?> operation = this.$request.getOperation();
                        if (operation == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.Operation<com.apollographql.apollo3.api.Operation.Data>");
                        }
                        UUID uUID = this.$request.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"request.uniqueId");
                        ApolloStore.DefaultImpls.writeOptimisticUpdates$default((ApolloStore)apolloStore, operation, (Operation.Data)optimisticUpdates, (UUID)uUID, (boolean)false, (int)8, null);
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().e((Throwable)e, "failed to write operation optimistic updates, for: %s", new Object[]{this.$request.getOperation()});
                }
            }
            {
                this.this$0 = apolloCacheInterceptor;
                this.$request = interceptorRequest;
            }
        });
    }

    @NotNull
    public final Set<String> rollbackOptimisticUpdates(@NotNull ApolloInterceptor.InterceptorRequest request, boolean publish) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            UUID uUID = request.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"request.uniqueId");
            set = this.apolloStore.rollbackOptimisticUpdates(uUID, publish);
        }
        catch (Exception e) {
            this.logger.e((Throwable)e, "failed to rollback operation optimistic updates, for: %s", new Object[]{request.getOperation()});
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void publishCacheKeys(@Nullable Set<String> cacheKeys) {
        this.dispatcher.execute(new Runnable(this, cacheKeys){
            final /* synthetic */ ApolloCacheInterceptor this$0;
            final /* synthetic */ Set $cacheKeys;

            public final void run() {
                try {
                    ApolloStore apolloStore = this.this$0.getApolloStore();
                    Set set = this.$cacheKeys;
                    Intrinsics.checkNotNull((Object)set);
                    apolloStore.publish(set);
                }
                catch (Exception e) {
                    this.this$0.getLogger().e((Throwable)e, "Failed to publish cache changes", new Object[0]);
                }
            }
            {
                this.this$0 = apolloCacheInterceptor;
                this.$cacheKeys = set;
            }
        });
    }

    @NotNull
    public final ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    public ApolloCacheInterceptor(@NotNull ApolloStore apolloStore, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, @NotNull AtomicReference<ApolloCall.Callback<D>> responseCallback, boolean writeToCacheAsynchronously) {
        Intrinsics.checkNotNullParameter((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(responseCallback, (String)"responseCallback");
        this.apolloStore = apolloStore;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.responseCallback = responseCallback;
        this.writeToCacheAsynchronously = writeToCacheAsynchronously;
    }

    public static final /* synthetic */ void access$writeOptimisticUpdatesAndPublish(ApolloCacheInterceptor $this, ApolloInterceptor.InterceptorRequest request) {
        $this.writeOptimisticUpdatesAndPublish(request);
    }

    public static final /* synthetic */ boolean access$getWriteToCacheAsynchronously$p(ApolloCacheInterceptor $this) {
        return $this.writeToCacheAsynchronously;
    }

    public static final /* synthetic */ void access$cacheResponseAndPublishSynchronously(ApolloCacheInterceptor $this, ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse networkResponse) {
        $this.cacheResponseAndPublishSynchronously(request, networkResponse);
    }
}

